/*
 * Decompiled with CFR 0.152.
 */
package com.blibli.oss.qa.util.services;

import com.blibli.oss.qa.util.model.HarModel;
import com.blibli.oss.qa.util.services.HarEntryConverter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.sstoehr.harreader.model.Har;
import de.sstoehr.harreader.model.HarCreatorBrowser;
import de.sstoehr.harreader.model.HarEntry;
import de.sstoehr.harreader.model.HarLog;
import de.sstoehr.harreader.model.HarPage;
import de.sstoehr.harreader.model.HarPageTiming;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.NetworkInterceptor;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkListener {
    private static final Logger log = LoggerFactory.getLogger(NetworkListener.class);
    static final String targetPathFile = System.getProperty("user.dir") + "/target/";
    private final ConcurrentHashMap<String, HarModel> harModelHashMap = new ConcurrentHashMap();
    private WebDriver driver;
    private String baseRemoteUrl;
    private DevTools devTools;
    private String harFile = "";
    private HarCreatorBrowser harCreatorBrowser;

    public NetworkListener(WebDriver driver, String harFileName) {
        this.driver = driver;
        this.harFile = harFileName;
        try {
            Files.delete(Paths.get(this.harFile, new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.createHarBrowser();
    }

    public NetworkListener(WebDriver driver, String harFileName, String baseRemoteUrl) {
        this.driver = driver;
        this.harFile = harFileName;
        this.baseRemoteUrl = baseRemoteUrl;
        try {
            Files.delete(Paths.get(this.harFile, new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.createHarBrowser();
    }

    public NetworkListener(String harFileName) {
        this.harFile = harFileName;
    }

    private static String convertInputStreamToString(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            String line = bufferedReader.readLine();
            while (line != null) {
                stringBuilder.append(line);
                line = bufferedReader.readLine();
            }
        }
        return stringBuilder.toString();
    }

    public void start() {
        try {
            this.devTools = this.driver instanceof RemoteWebDriver ? this.getCdpUsingCustomurl() : ((HasDevTools)this.driver).getDevTools();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.devTools.createSession();
        Filter reportStatusCodes = next -> req -> {
            HttpResponse res = next.execute(req);
            this.harModelHashMap.put(String.valueOf(Calendar.getInstance().getTimeInMillis()), new HarModel(req, res));
            return res;
        };
        NetworkInterceptor networkInterceptor = new NetworkInterceptor(this.driver, reportStatusCodes);
    }

    public DevTools getCdpUsingCustomurl() {
        try {
            Field capabilitiesField = RemoteWebDriver.class.getDeclaredField("capabilities");
            capabilitiesField.setAccessible(true);
            String sessionId = ((RemoteWebDriver)this.driver).getSessionId().toString();
            String devtoolsUrl = String.format("ws://%s/devtools/%s/page", this.baseRemoteUrl, sessionId);
            MutableCapabilities mutableCapabilities = (MutableCapabilities)capabilitiesField.get(this.driver);
            mutableCapabilities.setCapability("se:cdp", devtoolsUrl);
            mutableCapabilities.setCapability("se:cdpVersion", mutableCapabilities.getBrowserVersion());
        }
        catch (Exception e) {
            log.info("Failed to spoof RemoteWebDriver capabilities :sadpanda:");
        }
        RemoteWebDriver augmenteDriver = (RemoteWebDriver)new Augmenter().augment(this.driver);
        DevTools devTools = ((HasDevTools)augmenteDriver).getDevTools();
        this.driver = augmenteDriver;
        return devTools;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public void createHarFile() {
        Har har = new Har();
        HarLog harLog = new HarLog();
        harLog.setCreator(this.harCreatorBrowser);
        harLog.setBrowser(this.harCreatorBrowser);
        ArrayList harPages = new ArrayList();
        ArrayList<HarEntry> harEntries = new ArrayList<HarEntry>();
        for (Map.Entry<String, HarModel> entry : this.harModelHashMap.entrySet()) {
            log.debug("Processing Har Entry   " + entry.getKey() + " Request URL " + entry.getValue().getHttpRequest().getUri());
            try {
                harEntries.add(this.createHarEntry(entry.getValue().getHttpRequest(), entry.getValue().getHttpResponse(), Long.parseLong(entry.getKey())));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        log.info("har entry size : %d", (Object)harEntries.size());
        harLog.setPages(harPages);
        harLog.setEntries(harEntries);
        har.setLog(harLog);
        this.createFile(har);
    }

    public void createFile(Har har) {
        ObjectMapper om = new ObjectMapper();
        try {
            String json = om.writeValueAsString((Object)har);
            Files.write(Paths.get(this.harFile, new String[0]), json.getBytes(), new OpenOption[0]);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createHarBrowser() {
        this.harCreatorBrowser = new HarCreatorBrowser();
        this.harCreatorBrowser.setName("gdn-qa-automation");
        this.harCreatorBrowser.setVersion("0.0.1");
        this.harCreatorBrowser.setComment("Created by HAR utils");
    }

    public HarPage createHarPage(HttpRequest request, HttpResponse response) {
        HarPage harPage = new HarPage();
        harPage.setComment("Create by Har Utils");
        HarPageTiming harPageTiming = new HarPageTiming();
        harPageTiming.setOnContentLoad(Integer.valueOf(0));
        harPage.setPageTimings(harPageTiming);
        harPage.setStartedDateTime(new Date());
        harPage.setTitle(request.getUri());
        return harPage;
    }

    public HarEntry createHarEntry(HttpRequest httpRequest, HttpResponse httpResponse, long time) {
        HarEntryConverter harEntry = new HarEntryConverter(httpRequest, httpResponse, time);
        harEntry.setup();
        return harEntry.getHarEntry();
    }

    public static void switchTab(NetworkListener networkListener, WebDriver driver, Integer tabIndex) {
        driver.switchTo().window((String)new ArrayList(driver.getWindowHandles()).get(tabIndex));
        networkListener.start();
        driver.navigate().refresh();
    }
}

