/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.util;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;

public class XIUtil {
    public static final boolean is1dot2 = XIUtil.is1dot2();
    public static final boolean is1dot3 = XIUtil.is1dot3();

    private static boolean is1dot2() {
        try {
            Method m = Class.class.getMethod("getProtectionDomain", new Class[0]);
            return m != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean is1dot3() {
        try {
            Method m = Runtime.class.getMethod("addShutdownHook", Thread.class);
            return m != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private XIUtil() {
    }

    public static final Frame getFrame(Component aComponent) {
        Component comp;
        for (comp = aComponent; comp != null && !(comp instanceof Frame); comp = comp.getParent()) {
        }
        return (Frame)comp;
    }

    public static final Window getWindow(Component aComponent) {
        Component comp;
        for (comp = aComponent; comp != null && !(comp instanceof Window); comp = comp.getParent()) {
        }
        return (Window)comp;
    }

    public static final Applet getApplet(Component aComponent) {
        Component comp;
        for (comp = aComponent; comp != null && !(comp instanceof Applet); comp = comp.getParent()) {
        }
        return (Applet)comp;
    }

    public static Image createImage(Class<?> baseClass, String gifFile) {
        byte[] buffer;
        try {
            int n;
            InputStream resource = baseClass.getResourceAsStream(gifFile);
            if (resource == null) {
                throw new IllegalArgumentException(baseClass.getName() + "/" + gifFile + " not found.");
            }
            BufferedInputStream in = new BufferedInputStream(resource);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            buffer = new byte[1024];
            while ((n = in.read(buffer)) > 0) {
                out.write(buffer, 0, n);
            }
            in.close();
            out.flush();
            buffer = out.toByteArray();
            if (buffer.length == 0) {
                throw new IllegalStateException("warning: " + gifFile + " is zero-length");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        return Toolkit.getDefaultToolkit().createImage(buffer);
    }

    public static char getMnemonic(String str) {
        int state = 0;
        block4: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (state) {
                case 0: {
                    if (ch != '&') continue block4;
                    state = 1;
                    continue block4;
                }
                case 1: {
                    if (ch != '&') {
                        return ch;
                    }
                    state = 0;
                }
            }
        }
        return '\u0000';
    }

    public static String removeMnemonics(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        int state = 0;
        block4: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (state) {
                case 0: {
                    if (ch == '&') {
                        state = 1;
                        continue block4;
                    }
                    sb.append(ch);
                    continue block4;
                }
                case 1: {
                    sb.append(ch);
                    state = 0;
                }
            }
        }
        return sb.toString();
    }
}

