/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.util;

import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Panel;
import java.awt.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class XIRatioLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private int ivHGap;
    private Map<Component, Constraints> ivConstraints = new HashMap<Component, Constraints>();
    private static final int PREFERRED = 0;
    private static final int MINIMUM = 1;
    private static final int MAXIMUM = 2;

    public XIRatioLayout() {
        this(0);
    }

    public XIRatioLayout(int hgap) {
        this.ivHGap = hgap;
    }

    public final int getHGap() {
        return this.ivHGap;
    }

    @Override
    public void addLayoutComponent(String aDescriptor, Component comp) {
        Float fl = Float.valueOf(aDescriptor);
        this.addLayoutComponent(comp, new Constraints(fl.floatValue(), 0));
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints != null && !(constraints instanceof Constraints)) {
            throw new IllegalArgumentException("XIRatioLayout.Constraints expected");
        }
        this.ivConstraints.put(comp, (Constraints)constraints);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.ivConstraints.remove(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container parent, int type) {
        int maxH;
        int maxW;
        Insets insets;
        int[] nComps = new int[3];
        Object object = parent.getTreeLock();
        synchronized (object) {
            insets = parent.getInsets();
            maxW = insets.left + insets.right;
            maxH = insets.top + insets.bottom;
            int n = parent.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Dimension dim;
                Component comp = parent.getComponent(i);
                if (!comp.isVisible()) continue;
                Constraints constr = this.ivConstraints.get(comp);
                if (constr != null) {
                    int n2 = constr.getAlignment();
                    nComps[n2] = nComps[n2] + 1;
                    continue;
                }
                switch (type) {
                    case 0: {
                        dim = comp.getPreferredSize();
                        break;
                    }
                    case 1: {
                        dim = comp.getMinimumSize();
                        break;
                    }
                    case 2: {
                        dim = comp.getMaximumSize();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                Point loc = comp.getLocation();
                maxW = Math.max(maxW, loc.x + dim.width - 1);
                maxH = Math.max(maxH, loc.y + dim.height - 1);
            }
        }
        int w = insets.left + insets.right;
        for (int i = 0; i <= 2; ++i) {
            if (nComps[i] <= 0) continue;
            w -= (nComps[i] - 1) * this.ivHGap;
        }
        maxW = Math.max(maxW, w);
        return new Dimension(maxW, maxH);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.layoutSize(parent, 0);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.layoutSize(parent, 1);
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.layoutSize(parent, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        int j;
        int x;
        Dimension parentDim;
        Constraints constr;
        int i;
        ArrayList[] constrs;
        ArrayList[] comps;
        Insets insets;
        Object object = parent.getTreeLock();
        synchronized (object) {
            insets = parent.getInsets();
            comps = new ArrayList[3];
            constrs = new ArrayList[3];
            int nComps = parent.getComponentCount();
            for (i = 0; i <= 2; ++i) {
                comps[i] = new ArrayList(nComps);
                constrs[i] = new ArrayList(nComps);
            }
            for (int i2 = 0; i2 < nComps; ++i2) {
                Component comp = parent.getComponent(i2);
                if (!comp.isVisible() || (constr = this.ivConstraints.get(comp)) == null) continue;
                comps[constr.getAlignment()].add(comp);
                constrs[constr.getAlignment()].add(constr);
            }
            parentDim = parent.getSize();
        }
        if (comps[0].size() == 0 && comps[1].size() == 0 && comps[2].size() == 0) {
            return;
        }
        int maxW = parentDim.width - (insets.left + insets.right);
        int maxH = parentDim.height - (insets.top + insets.bottom);
        for (i = 0; i <= 2; ++i) {
            if (comps[i].size() <= 0) continue;
            maxW -= (comps[i].size() - 1) * this.ivHGap;
        }
        int[] totW = new int[3];
        for (int i3 = 0; i3 <= 2; ++i3) {
            for (int j2 = 0; j2 < comps[i3].size(); ++j2) {
                Component comp = (Component)comps[i3].get(j2);
                constr = (Constraints)constrs[i3].get(j2);
                comp.setSize(Math.round((float)maxW * constr.getHRatio()), maxH);
                int n = i3;
                totW[n] = totW[n] + comp.getSize().width;
            }
        }
        if (comps[0].size() > 0) {
            x = insets.left;
            for (j = 0; j < comps[0].size(); ++j) {
                Component comp = (Component)comps[0].get(j);
                Dimension dim = comp.getSize();
                comp.setLocation(x, insets.top);
                x += dim.width + this.ivHGap;
            }
        }
        if (comps[2].size() > 0) {
            x = parentDim.width - insets.right;
            for (j = 0; j < comps[2].size(); ++j) {
                Component comp = (Component)comps[2].get(j);
                Dimension dim = comp.getSize();
                comp.setLocation(x - dim.width, insets.top);
                x -= dim.width + this.ivHGap;
            }
        }
        if (comps[1].size() > 0) {
            x = (parentDim.width - totW[1] - (comps[1].size() - 1) * this.ivHGap) / 2;
            for (j = 0; j < comps[1].size(); ++j) {
                Component comp = (Component)comps[1].get(j);
                Dimension dim = comp.getSize();
                comp.setLocation(x, insets.top);
                x += dim.width + this.ivHGap;
            }
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    public static void main(String[] args) {
        Frame frame = new Frame("TEST XIRatioLayout");
        Panel panel = new Panel(new XIRatioLayout(4));
        panel.add((Component)new Button("L1"), new Constraints(0.1f, 0));
        panel.add((Component)new Button("L2"), new Constraints(0.2f, 0));
        panel.add((Component)new Button("R1"), new Constraints(0.1f, 2));
        panel.add((Component)new Button("R2"), new Constraints(0.2f, 2));
        panel.add((Component)new Button("C1"), new Constraints(0.2f, 1));
        panel.add((Component)new Button("C2"), new Constraints(0.2f, 1));
        frame.add(panel);
        frame.setBounds(0, 0, 200, 200);
        frame.setVisible(true);
    }

    public static class Constraints
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private float ivHRatio;
        private int ivAlign;

        public Constraints(float hRatio) {
            this(hRatio, 0);
        }

        public Constraints(float hRatio, int alignment) {
            if (alignment < 0 || alignment > 2) {
                throw new IllegalArgumentException();
            }
            this.ivHRatio = hRatio;
            this.ivAlign = alignment;
        }

        public final float getHRatio() {
            return this.ivHRatio;
        }

        public final int getAlignment() {
            return this.ivAlign;
        }
    }
}

