/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tnprot;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import net.infordata.em.tnprot.XITelnetEmulator;

public class XITelnet {
    private static final Logger LOGGER = Logger.getLogger(XITelnet.class.getName());
    public static final byte TELOPT_BINARY = 0;
    public static final byte TELOPT_ECHO = 1;
    public static final byte TELOPT_RCP = 2;
    public static final byte TELOPT_SGA = 3;
    public static final byte TELOPT_NAMS = 4;
    public static final byte TELOPT_STATUS = 5;
    public static final byte TELOPT_TM = 6;
    public static final byte TELOPT_RCTE = 7;
    public static final byte TELOPT_NAOL = 8;
    public static final byte TELOPT_NAOP = 9;
    public static final byte TELOPT_NAOCRD = 10;
    public static final byte TELOPT_NAOHTS = 11;
    public static final byte TELOPT_NAOHTD = 12;
    public static final byte TELOPT_NAOFFD = 13;
    public static final byte TELOPT_NAOVTS = 14;
    public static final byte TELOPT_NAOVTD = 15;
    public static final byte TELOPT_NAOLFD = 16;
    public static final byte TELOPT_XASCII = 17;
    public static final byte TELOPT_LOGOUT = 18;
    public static final byte TELOPT_BM = 19;
    public static final byte TELOPT_DET = 20;
    public static final byte TELOPT_SUPDUP = 21;
    public static final byte TELOPT_SUPDUPOUTPUT = 22;
    public static final byte TELOPT_SNDLOC = 23;
    public static final byte TELOPT_TTYPE = 24;
    public static final byte TELOPT_EOR = 25;
    public static final byte TELOPT_TUID = 26;
    public static final byte TELOPT_OUTMRK = 27;
    public static final byte TELOPT_TTYLOC = 28;
    public static final byte TELOPT_3270REGIME = 29;
    public static final byte TELOPT_X3PAD = 30;
    public static final byte TELOPT_NAWS = 31;
    public static final byte TELOPT_TSPEED = 32;
    public static final byte TELOPT_LFLOW = 33;
    public static final byte TELOPT_LINEMODE = 34;
    public static final byte TELOPT_XDISPLOC = 35;
    public static final byte TELOPT_OLD_ENVIRON = 36;
    public static final byte TELOPT_AUTHENTICATION = 37;
    public static final byte TELOPT_ENCRYPT = 38;
    public static final byte TELOPT_NEW_ENVIRON = 39;
    public static final String[] TELOPT = new String[]{"BINARY", "ECHO", "RCP", "SUPPRESS GO AHEAD", "NAME", "STATUS", "TIMING MARK", "RCTE", "NAOL", "NAOP", "NAOCRD", "NAOHTS", "NAOHTD", "NAOFFD", "NAOVTS", "NAOVTD", "NAOLFD", "EXTEND ASCII", "LOGOUT", "BYTE MACRO", "DATA ENTRY TERMINAL", "SUPDUP", "SUPDUP OUTPUT", "SEND LOCATION", "TERMINAL TYPE", "END OF RECORD", "TACACS UID", "OUTPUT MARKING", "TTYLOC", "3270 REGIME", "X.3 PAD", "NAWS", "TSPEED", "LFLOW", "LINEMODE", "XDISPLOC", "OLD-ENVIRON", "AUTHENTICATION", "ENCRYPT", "NEW-ENVIRON", "<UNKNOWN>"};
    static final byte IAC = -1;
    static final byte DONT = -2;
    static final byte DO = -3;
    static final byte WONT = -4;
    static final byte WILL = -5;
    static final byte SB = -6;
    static final byte SE = -16;
    static final byte EOR = -17;
    static final String[] TELCMD = new String[]{"IAC", "DONT", "DO", "WONT", "WILL", "SB", "GA", "EL", "EC", "AYT", "AO", "IP", "BRK", "DATA MARK", "NOP", "SE", "EOR"};
    static final byte SEND = 1;
    static final byte IS = 0;
    static final int SIAC_START = 0;
    static final int SIAC_WCMD = 1;
    static final int SIAC_WOPT = 2;
    static final int SIAC_WSTR = 3;
    private String ivHost;
    private int ivPort;
    private int connectionTimeoutMillis;
    private SocketFactory socketFactory = SocketFactory.getDefault();
    private boolean disconnectOnException = true;
    private transient Socket ivSocket;
    private transient InputStream ivIn;
    private transient BufferedOutputStream ivOut;
    private transient RxThread ivReadTh;
    private transient byte ivIACCmd;
    private transient byte ivIACOpt;
    private transient String ivIACStr;
    private transient boolean[] ivLocalFlags = new boolean[128];
    private transient boolean[] ivRemoteFlags = new boolean[128];
    private boolean[] ivLocalReqFlags = new boolean[128];
    private boolean[] ivRemoteReqFlags = new boolean[128];
    private String ivTermType;
    private String ivEnvironment;
    private transient int ivIACParserStatus = 0;
    private XITelnetEmulator ivEmulator;
    private transient String ivFirstHost;
    private transient String ivSecondHost;
    private transient boolean ivUsed = false;

    public static int toInt(byte bb) {
        return bb & 0xFF;
    }

    public static String toHex(byte bb) {
        String hex = Integer.toString(XITelnet.toInt(bb), 16);
        return "00".substring(hex.length()) + hex;
    }

    public static String toHex(byte[] buf, int len) {
        StringBuilder sb = new StringBuilder(len * 4);
        for (int i = 0; i < len; ++i) {
            sb.append(XITelnet.toHex(buf[i])).append(' ');
        }
        return sb.toString();
    }

    public static String toHex(byte[] buf) {
        return XITelnet.toHex(buf, buf.length);
    }

    public XITelnet(String aHost) {
        this(aHost, 23);
    }

    public XITelnet(String aHost, int aPort) {
        if (aHost == null) {
            throw new IllegalArgumentException("Host cannot be null");
        }
        this.ivHost = aHost;
        this.ivPort = aPort;
        try {
            StringTokenizer st = new StringTokenizer(this.ivHost, "#");
            this.ivFirstHost = st.nextToken();
            this.ivSecondHost = st.nextToken();
        }
        catch (NoSuchElementException st) {
            // empty catch block
        }
        String[] parts = this.ivFirstHost.split(":");
        if (parts.length == 2) {
            this.ivFirstHost = parts[0];
            this.ivPort = Integer.parseInt(parts[1]);
        }
    }

    public String getHost() {
        return this.ivHost;
    }

    public int getPort() {
        return this.ivPort;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setDisconnectOnException(boolean disconnectOnException) {
        this.disconnectOnException = disconnectOnException;
    }

    public void setEmulator(XITelnetEmulator aEmulator) {
        this.ivEmulator = aEmulator;
    }

    public boolean isConnected() {
        return this.ivSocket != null;
    }

    public void setTerminalType(String aTerminalType) {
        if (this.isConnected()) {
            throw new IllegalArgumentException("Telnet already connected");
        }
        this.setLocalReqFlag((byte)24, true);
        this.ivTermType = aTerminalType;
    }

    public String getTerminalType() {
        return this.ivTermType;
    }

    public void setEnvironment(String aEnv) {
        if (this.isConnected()) {
            throw new IllegalArgumentException("Telnet already connected");
        }
        this.setLocalReqFlag((byte)39, true);
        this.ivEnvironment = aEnv;
    }

    public String getEnvironment() {
        return this.ivEnvironment;
    }

    public void setLocalReqFlag(byte flag, boolean b) {
        if (this.isConnected()) {
            throw new IllegalArgumentException("Telnet already connected");
        }
        this.ivLocalReqFlags[flag] = b;
    }

    public void setRemoteReqFlag(byte flag, boolean b) {
        if (this.isConnected()) {
            throw new IllegalArgumentException("Telnet already connected");
        }
        this.ivRemoteReqFlags[flag] = b;
    }

    public boolean isLocalFlagON(byte flag) {
        return this.ivLocalFlags[flag];
    }

    public boolean isRemoteFlagON(byte flag) {
        return this.ivRemoteFlags[flag];
    }

    public synchronized void connect() {
        if (this.ivUsed) {
            throw new IllegalArgumentException("XITelnet cannot be recycled");
        }
        this.disconnect();
        this.connecting();
        try {
            this.ivSocket = this.socketFactory.createSocket();
            this.ivSocket.connect(new InetSocketAddress(this.ivFirstHost, this.ivPort), this.connectionTimeoutMillis);
            this.ivIn = this.ivSocket.getInputStream();
            this.ivOut = new BufferedOutputStream(this.ivSocket.getOutputStream());
            this.ivReadTh = new RxThread();
            this.ivReadTh.start();
            this.ivUsed = true;
            this.connected();
        }
        catch (IOException ex) {
            this.caughtIOException(ex);
        }
    }

    private void closeSocket(boolean remote) {
        if (this.ivSocket != null) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("closing...");
                }
                this.ivSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ivSocket = null;
            this.disconnected(remote);
        }
    }

    public synchronized void disconnect() {
        this.disconnect(false);
    }

    private synchronized void disconnect(boolean remote) {
        if (this.ivReadTh != null) {
            this.ivReadTh.terminate();
            this.ivReadTh = null;
        }
        this.closeSocket(remote);
    }

    protected int processIAC(byte bb) {
        int res = 1;
        block1 : switch (this.ivIACParserStatus) {
            case 0: {
                switch (bb) {
                    case -1: {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("IAC");
                        }
                        this.ivIACParserStatus = 1;
                        res = 0;
                    }
                }
                break;
            }
            case 1: {
                if (LOGGER.isLoggable(Level.FINE)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(" r " + bb + " ");
                    try {
                        sb.append(TELCMD[-(bb + 1)] + " ");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LOGGER.fine(sb.toString());
                }
                switch (bb) {
                    case -1: {
                        this.ivIACParserStatus = 0;
                        break block1;
                    }
                    case -17: {
                        this.ivIACParserStatus = 0;
                        res = 0;
                        if (!this.ivLocalFlags[25]) break block1;
                        this.receivedEOR();
                        break block1;
                    }
                    case -5: 
                    case -4: 
                    case -3: 
                    case -2: {
                        this.ivIACCmd = bb;
                        this.ivIACParserStatus = 2;
                        res = 0;
                        break block1;
                    }
                    case -6: {
                        this.ivIACStr = "";
                        this.ivIACCmd = bb;
                        this.ivIACParserStatus = 2;
                        res = 0;
                        break block1;
                    }
                    case -16: {
                        this.ivIACParserStatus = 0;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("SE " + TELOPT[this.ivIACOpt]);
                        }
                        res = 0;
                        if (!this.ivLocalFlags[this.ivIACOpt]) break block1;
                        switch (this.ivIACOpt) {
                            case 24: {
                                this.sendIACStr((byte)-6, (byte)24, true, this.ivTermType);
                                break block1;
                            }
                            case 39: {
                                this.sendIACStr((byte)-6, (byte)39, true, this.ivEnvironment);
                                break block1;
                            }
                        }
                        this.unhandledRequest(this.ivIACOpt, this.ivIACStr);
                        break block1;
                    }
                }
                this.ivIACParserStatus = 0;
                res = 0;
                break;
            }
            case 2: {
                this.ivIACOpt = bb;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(TELOPT[this.ivIACOpt]);
                }
                res = 0;
                switch (this.ivIACCmd) {
                    case -6: {
                        break;
                    }
                    case -2: {
                        if (!this.ivLocalFlags[this.ivIACOpt]) break;
                        this.ivLocalFlags[this.ivIACOpt] = false;
                        this.sendIACCmd((byte)-4, this.ivIACOpt);
                        this.localFlagsChanged(this.ivIACOpt);
                        break;
                    }
                    case -3: {
                        if (this.ivLocalReqFlags[this.ivIACOpt]) {
                            if (this.ivLocalFlags[this.ivIACOpt]) break;
                            this.ivLocalFlags[this.ivIACOpt] = true;
                            this.sendIACCmd((byte)-5, this.ivIACOpt);
                            this.localFlagsChanged(this.ivIACOpt);
                            break;
                        }
                        this.sendIACCmd((byte)-4, this.ivIACOpt);
                        break;
                    }
                    case -4: {
                        if (!this.ivRemoteFlags[this.ivIACOpt]) break;
                        this.ivRemoteFlags[this.ivIACOpt] = false;
                        this.sendIACCmd((byte)-2, this.ivIACOpt);
                        this.remoteFlagsChanged(this.ivIACOpt);
                        break;
                    }
                    case -5: {
                        if (this.ivRemoteReqFlags[this.ivIACOpt]) {
                            if (this.ivRemoteFlags[this.ivIACOpt]) break;
                            this.ivRemoteFlags[this.ivIACOpt] = true;
                            this.sendIACCmd((byte)-3, this.ivIACOpt);
                            this.remoteFlagsChanged(this.ivIACOpt);
                            break;
                        }
                        this.sendIACCmd((byte)-2, this.ivIACOpt);
                    }
                }
                if (this.ivIACCmd != -6) {
                    this.ivIACParserStatus = 0;
                    break;
                }
                this.ivIACParserStatus = 3;
                break;
            }
            case 3: {
                res = 0;
                switch (bb) {
                    case -1: {
                        this.ivIACParserStatus = 1;
                        break block1;
                    }
                }
                this.ivIACStr = this.ivIACStr + (char)bb;
            }
        }
        return res;
    }

    public synchronized void sendEOR() {
        byte[] buf = new byte[]{-1, -17};
        try {
            this.ivOut.write(buf);
            this.ivOut.flush();
        }
        catch (IOException ex) {
            this.caughtIOException(ex);
        }
    }

    public synchronized void sendIACCmd(byte aCmd, byte aOpt) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(" t " + aCmd + " " + TELCMD[-(aCmd + 1)] + " " + TELOPT[aOpt]);
        }
        byte[] buf = new byte[]{-1, aCmd, aOpt};
        try {
            this.ivOut.write(buf);
            this.ivOut.flush();
        }
        catch (IOException ex) {
            this.caughtIOException(ex);
        }
    }

    public synchronized void sendIACStr(byte aCmd, byte aOpt, boolean sendIS, String aString) {
        byte[] byArray;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("t " + aCmd + " " + TELCMD[-(aCmd + 1)] + " " + TELOPT[aOpt] + " " + aString);
        }
        byte[] endBuf = new byte[]{-1, -16};
        if (sendIS) {
            byte[] byArray2 = new byte[4];
            byArray2[0] = -1;
            byArray2[1] = aCmd;
            byArray2[2] = aOpt;
            byArray = byArray2;
            byArray2[3] = 0;
        } else {
            byte[] byArray3 = new byte[3];
            byArray3[0] = -1;
            byArray3[1] = aCmd;
            byArray = byArray3;
            byArray3[2] = aOpt;
        }
        byte[] startBuf = byArray;
        try {
            this.ivOut.write(startBuf);
            this.ivOut.write(aString.getBytes());
            this.ivOut.write(endBuf);
            this.ivOut.flush();
        }
        catch (IOException ex) {
            this.caughtIOException(ex);
        }
    }

    public synchronized void send(byte[] aBuf, int aLen) {
        try {
            for (int i = 0; i < aLen; ++i) {
                this.ivOut.write(aBuf[i]);
                if (aBuf[i] != -1) continue;
                this.ivOut.write(-1);
            }
            this.ivOut.flush();
        }
        catch (IOException ex) {
            this.caughtIOException(ex);
        }
    }

    public void send(byte[] aBuf) {
        this.send(aBuf, aBuf.length);
    }

    public synchronized void flush() {
        try {
            this.ivOut.flush();
        }
        catch (IOException ex) {
            this.caughtIOException(ex);
        }
    }

    protected void connecting() {
        if (this.ivEmulator != null) {
            this.ivEmulator.connecting();
        }
    }

    protected void connected() {
        if (this.ivSecondHost != null && !this.ivSecondHost.equals("")) {
            this.send((this.ivSecondHost + "\n").getBytes());
        }
        if (this.ivEmulator != null) {
            this.ivEmulator.connected();
        }
    }

    protected void disconnected(boolean remote) {
        if (this.ivEmulator != null) {
            this.ivEmulator.disconnected(remote);
        }
    }

    protected synchronized void caughtIOException(IOException ex) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "", ex);
        }
        try {
            if (this.ivEmulator != null) {
                this.ivEmulator.caughtIOException(ex);
            }
        }
        finally {
            if (this.disconnectOnException) {
                this.disconnect();
            }
        }
    }

    protected void unhandledRequest(byte aIACOpt, String aIACStr) {
        if (this.ivEmulator != null) {
            this.ivEmulator.unhandledRequest(aIACOpt, aIACStr);
        }
    }

    protected void localFlagsChanged(byte aIACOpt) {
        if (this.ivEmulator != null) {
            this.ivEmulator.localFlagsChanged(aIACOpt);
        }
    }

    protected void remoteFlagsChanged(byte aIACOpt) {
        if (this.ivEmulator != null) {
            this.ivEmulator.remoteFlagsChanged(aIACOpt);
        }
    }

    protected void receivedData(byte[] buf, int len) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(XITelnet.toHex(buf, len));
        }
        if (this.ivEmulator != null) {
            this.ivEmulator.receivedData(buf, len);
        }
    }

    protected void receivedEOR() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("EOR");
        }
        if (this.ivEmulator != null) {
            this.ivEmulator.receivedEOR();
        }
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    public static void main(String[] argv) {
        XITelnet tn = new XITelnet("192.168.0.1#192.168.0.4");
        tn.setTerminalType("IBM-3477-FC");
        tn.setLocalReqFlag((byte)0, true);
        tn.setLocalReqFlag((byte)24, true);
        tn.setLocalReqFlag((byte)25, true);
        tn.setRemoteReqFlag((byte)0, true);
        tn.setRemoteReqFlag((byte)25, true);
        try {
            tn.connect();
            Thread.sleep(10000L);
            tn.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class RxThread
    extends Thread {
        private boolean ivTerminate;

        public RxThread() {
            super("XITelnet rx thread");
            this.ivTerminate = false;
        }

        public void terminate() {
            this.ivTerminate = true;
            if (this != Thread.currentThread()) {
                this.interrupt();
            }
        }

        @Override
        public void run() {
            block8: {
                byte[] buf = new byte[1024];
                byte[] rBuf = new byte[1024];
                int len = 0;
                try {
                    while (!this.ivTerminate) {
                        len = XITelnet.this.ivIn.read(buf);
                        if (len < 0) {
                            XITelnet.this.disconnect(true);
                            return;
                        }
                        int j = 0;
                        for (int i = 0; i < len; ++i) {
                            rBuf[j] = buf[i];
                            if (XITelnet.this.ivIACParserStatus != 0 || buf[i] == -1) {
                                if (XITelnet.this.ivIACParserStatus == 0 && buf[i] == -1) {
                                    if (j > 0) {
                                        XITelnet.this.receivedData(rBuf, j);
                                    }
                                    j = 0;
                                }
                                j += XITelnet.this.processIAC(buf[i]);
                                continue;
                            }
                            ++j;
                        }
                        if (j <= 0) continue;
                        XITelnet.this.receivedData(rBuf, j);
                    }
                }
                catch (IOException ex) {
                    if (this.ivTerminate) break block8;
                    XITelnet.this.caughtIOException(ex);
                }
            }
        }
    }
}

