/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250ext;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JComponent;

public class XIHint
extends JComponent {
    private static final long serialVersionUID = 1L;
    private String ivText = null;
    private int ivMaxWidth = 0;
    private Font ivFont = null;
    private int ivSpaceLine = 1;
    private int ivSpaceUp = 1;
    private int ivSpaceDown = 2;
    private int ivSpaceRight = 2;
    private int ivSpaceLeft = 4;
    private int ivHeightShortText;
    private ArrayList<String> ivVectorLines;
    private Font ivFBold;
    private Font ivFItalic;
    private Font ivFBoldItalic;

    public XIHint(String aText) {
        this(aText, 0);
    }

    public XIHint(String aText, int aWidth) {
        this.ivText = aText;
        this.ivFont = new Font("Helvetica", 0, 11);
        this.ivFBold = new Font(this.ivFont.getName(), 1, this.ivFont.getSize());
        this.ivFItalic = new Font(this.ivFont.getName(), 2, this.ivFont.getSize());
        this.ivFBoldItalic = new Font(this.ivFont.getName(), 3, this.ivFont.getSize());
        this.ivMaxWidth = aWidth;
        this.ivVectorLines = this.calculateLines(this.ivText, this.ivFont);
    }

    @Override
    public Dimension getPreferredSize() {
        int x = this.ivSpaceLeft;
        x += this.getTextSize((Font)this.ivFont).width + 2;
        int y = this.getTextSize((Font)this.ivFont).height + 2;
        return new Dimension(x += this.ivSpaceRight, y += this.ivSpaceDown);
    }

    public String getText() {
        return this.ivText;
    }

    @Override
    protected void paintComponent(Graphics aGraphics) {
        int vXPos = 0;
        aGraphics.setFont(this.ivFont);
        aGraphics.setColor(Color.black);
        this.drawMultiLineString(aGraphics, this.ivVectorLines, this.ivFont, vXPos + this.ivSpaceLeft, this.ivSpaceUp);
    }

    private int strWidth(String str, Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f).stringWidth(str);
    }

    private int strHeight(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f).getHeight();
    }

    private FontMetrics fontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    private Dimension textDim(ArrayList<String> v, Font f) {
        int maxW = 0;
        int lineW = 0;
        int h = 0;
        boolean bold = false;
        boolean italic = false;
        for (String str : v) {
            if (this.isEscapeChar(str, "#") || this.isEscapeChar(str, "@")) {
                StringTokenizer st = new StringTokenizer(str, "#@", true);
                while (st.hasMoreElements()) {
                    String token = st.nextToken();
                    if ("#".equals(token)) {
                        bold = !bold;
                        continue;
                    }
                    if ("@".equals(token)) {
                        italic = !italic;
                        continue;
                    }
                    if (bold && italic) {
                        lineW += this.strWidth(token, this.ivFBoldItalic);
                        continue;
                    }
                    if (bold) {
                        lineW += this.strWidth(token, this.ivFBold);
                        continue;
                    }
                    if (italic) {
                        lineW += this.strWidth(token, this.ivFItalic);
                        continue;
                    }
                    lineW += this.strWidth(token, f);
                }
            } else {
                lineW = this.strWidth(str, f);
            }
            maxW = Math.max(maxW, lineW);
            lineW = 0;
            h += this.strHeight(f) - this.fontMetrics(f).getDescent() + this.ivSpaceLine;
        }
        return new Dimension(maxW, h);
    }

    private boolean isEscapeChar(String text, String escChar) {
        if (escChar == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(text, escChar, true);
        while (st.hasMoreTokens()) {
            if (!escChar.equals(st.nextToken())) continue;
            return true;
        }
        return false;
    }

    public Dimension getTextSize(Font f) {
        return new Dimension(this.textDim(this.ivVectorLines, f));
    }

    private void drawMultiLineString(Graphics g, ArrayList<String> v, Font f, int x, int y) {
        int xBegin = x;
        boolean bold = false;
        boolean italic = false;
        for (String aV : v) {
            y += this.ivHeightShortText - this.fontMetrics(f).getDescent();
            StringTokenizer st = new StringTokenizer(aV, "#@", true);
            while (st.hasMoreElements()) {
                String token = st.nextToken();
                if ("#".equals(token)) {
                    bold = !bold;
                    continue;
                }
                if ("@".equals(token)) {
                    italic = !italic;
                    continue;
                }
                if (bold && italic) {
                    g.setFont(this.ivFBoldItalic);
                } else if (bold) {
                    g.setFont(this.ivFBold);
                } else if (italic) {
                    g.setFont(this.ivFItalic);
                } else {
                    g.setFont(f);
                }
                g.drawString(token, x, y);
                x += this.strWidth(token, g.getFont());
            }
            x = xBegin;
            y += this.ivSpaceLine;
        }
    }

    private ArrayList<String> calculateLines(String text, Font f) {
        StringTokenizer st = new StringTokenizer(text, "\n");
        ArrayList<String> v = new ArrayList<String>(10);
        this.ivHeightShortText = this.strHeight(f);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (this.ivMaxWidth > 0 && this.strWidth(token, f) > this.ivMaxWidth) {
                StringTokenizer subSt = new StringTokenizer(token);
                String subToken = "";
                while (subSt.hasMoreTokens()) {
                    String str1 = subSt.nextToken();
                    if (this.strWidth(subToken + str1, f) < this.ivMaxWidth) {
                        subToken = subToken + str1 + " ";
                        continue;
                    }
                    v.add(this.trimRight(subToken));
                    subToken = str1 + " ";
                }
                v.add(this.trimRight(subToken));
                continue;
            }
            v.add(this.trimRight(token));
        }
        return v;
    }

    private String trimRight(String str) {
        String str1 = str;
        while (str.endsWith(" ")) {
            str = str1 = str.substring(0, str.length() - 1);
        }
        return str1;
    }
}

