/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250ext;

import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import net.infordata.em.crt5250.XI5250Field;
import net.infordata.em.tn5250ext.XI5250EmulatorExt;
import net.infordata.em.tn5250ext.XI5250PanelConnection;
import net.infordata.em.tn5250ext.XI5250PanelHandler;
import net.infordata.em.tn5250ext.XI5250PanelsDispatcher;

public class PSHBTNCHCHandler
extends XI5250PanelHandler {
    private FontsCache ivFontsCache;
    private List<JButton> ivButtons = new ArrayList<JButton>();

    public PSHBTNCHCHandler(XI5250PanelsDispatcher disp) {
        super(disp, "");
    }

    @Override
    protected void sizeChanged() {
        super.sizeChanged();
        XI5250EmulatorExt em = this.getEmulator();
        for (JButton btn : this.ivButtons) {
            btn.setFont(this.ivFontsCache.getFont(Math.max(1, em.getFont().getSize() - 2)));
        }
    }

    @Override
    protected boolean detailedTest() {
        return true;
    }

    @Override
    protected void start() {
        this.ivButtons.clear();
        final XI5250EmulatorExt em = this.getEmulator();
        int crtWidth = em.getCrtSize().width;
        for (final XI5250Field field : this.getFields()) {
            int fieldEnd;
            String str;
            int idx;
            int len;
            if (!field.isIOOnly()) continue;
            int col = field.getCol() - 1;
            int row = field.getRow();
            if (col < 0 || !"<".equals(em.getString(col, row, 1)) || (len = (idx = (str = em.getString((fieldEnd = col + field.getLength()) + 1, row, crtWidth - fieldEnd)).indexOf(">")) < 0 ? -1 : idx + 2 + 1) <= 0) continue;
            String txt = em.getString(col + 1, row, len - 2);
            JButton btn = new JButton(txt);
            if (this.ivFontsCache == null) {
                this.ivFontsCache = new FontsCache(btn.getFont());
            }
            btn.setFont(this.ivFontsCache.getFont(Math.max(1, em.getFont().getSize() - 2)));
            btn.setMargin(new Insets(2, 2, 2, 2));
            btn.setFocusable(false);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    em.setCursorPos(field.getCol(), field.getRow());
                    em.requestFocusInWindow();
                    em.processRawKeyEvent(new KeyEvent(em, 401, 0L, 0, 10, '\n'));
                }
            });
            this.ivButtons.add(btn);
            new XI5250PanelConnection(this, btn, col, row, len, 1);
        }
    }

    @Override
    protected void stop() {
        this.ivButtons.clear();
    }

    private static class FontsCache {
        private Font[] ivFonts = new Font[50];
        private Font ivFont;

        public FontsCache(Font font) {
            this.ivFont = font;
        }

        public Font getFont(int size) {
            if (this.ivFonts[size - 1] == null) {
                this.ivFonts[size - 1] = new Font(this.ivFont.getName(), this.ivFont.getStyle(), size);
            }
            return this.ivFonts[size - 1];
        }
    }
}

