/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.io.IOException;
import java.io.InputStream;
import net.infordata.em.tn5250.XI5250Ord;
import net.infordata.em.tnprot.XITelnet;

public class XISFOrd
extends XI5250Ord {
    protected byte[] FFW = new byte[2];
    protected byte[] FCW = new byte[2];
    protected byte ivScreenAttr;
    protected int ivFieldLen;

    @Override
    protected void readFrom5250Stream(InputStream inStream) throws IOException {
        inStream.mark(1);
        byte bb = (byte)Math.max(0, inStream.read());
        if ((bb & 0xC0) == 64) {
            this.FFW[0] = bb;
            this.FFW[1] = (byte)Math.max(0, inStream.read());
            inStream.mark(1);
            bb = (byte)Math.max(0, inStream.read());
            if ((bb & 0xC0) == 128) {
                this.FCW[0] = bb;
                this.FCW[1] = (byte)Math.max(0, inStream.read());
            } else {
                inStream.reset();
            }
        } else {
            inStream.reset();
        }
        this.ivScreenAttr = (byte)Math.max(0, inStream.read());
        this.ivFieldLen = (Math.max(0, inStream.read()) << 8) + Math.max(0, inStream.read());
    }

    @Override
    protected void execute() {
        if (this.ivScreenAttr != 0) {
            this.ivEmulator.drawString(String.valueOf('\u0001'), this.ivEmulator.getSBACol(), this.ivEmulator.getSBARow(), this.ivScreenAttr);
            this.ivEmulator.setSBA(this.ivEmulator.getSBA() + 1);
        }
        this.ivEmulator.addField(this.ivEmulator.create5250Field((byte[])this.FFW.clone(), (byte[])this.FCW.clone(), this.ivEmulator.getSBACol(), this.ivEmulator.getSBARow(), this.ivFieldLen, -1));
    }

    public String toString() {
        return super.toString() + " [FFW=[" + XITelnet.toHex(this.FFW[0]) + "," + XITelnet.toHex(this.FFW[1]) + "],FCW=[" + XITelnet.toHex(this.FCW[0]) + "," + XITelnet.toHex(this.FCW[1]) + "]," + XITelnet.toHex(this.ivScreenAttr) + "," + this.ivFieldLen + "]";
    }
}

