/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.io.IOException;
import java.io.InputStream;
import net.infordata.em.tn5250.XI5250Exception;
import net.infordata.em.tn5250.XI5250Ord;
import net.infordata.em.tnprot.XITelnet;

public class XIEAOrd
extends XI5250Ord {
    protected int ivRow;
    protected int ivCol;
    protected int ivLen;
    protected byte[] ivAttributeTypes;

    @Override
    protected void readFrom5250Stream(InputStream inStream) throws IOException, XI5250Exception {
        byte[] buf = new byte[3];
        if (inStream.read(buf) < buf.length) {
            throw new XI5250Exception("EOF reached", 10050122);
        }
        this.ivRow = XITelnet.toInt(buf[0]);
        this.ivCol = XITelnet.toInt(buf[1]);
        this.ivLen = XITelnet.toInt(buf[2]);
        if (this.ivLen < 2 || this.ivLen > 5) {
            throw new XI5250Exception("Invalid len: " + this.ivLen, 10050122);
        }
        --this.ivLen;
        this.ivAttributeTypes = new byte[this.ivLen];
        if (inStream.read(this.ivAttributeTypes) < this.ivLen) {
            throw new XI5250Exception("EOF reached", 10050122);
        }
    }

    @Override
    protected void execute() {
        throw new IllegalStateException("Not supported");
    }

    public String toString() {
        return super.toString() + " [" + this.ivRow + "," + this.ivCol + "," + this.ivLen + ",,[" + XITelnet.toHex(this.ivAttributeTypes) + "]]";
    }
}

