/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.infordata.em.tn5250.XI5250Emulator;
import net.infordata.em.tn5250.XI5250Exception;
import net.infordata.em.tn5250.XI5250Ord;
import net.infordata.em.tn5250.XIDataOrd;
import net.infordata.em.tn5250.XIEAOrd;
import net.infordata.em.tn5250.XIICOrd;
import net.infordata.em.tn5250.XIMCOrd;
import net.infordata.em.tn5250.XIRAOrd;
import net.infordata.em.tn5250.XISBAOrd;
import net.infordata.em.tn5250.XISFOrd;
import net.infordata.em.tn5250.XISOHOrd;
import net.infordata.em.tn5250.XITDOrd;
import net.infordata.em.tn5250.XIWEAOrd;
import net.infordata.em.tn5250.XIWdsfOrd;
import net.infordata.em.tnprot.XITelnet;

public class XI5250OrdList
extends XI5250Ord {
    private static final Logger LOGGER = Logger.getLogger(XI5250OrdList.class.getName());
    private static Class<?>[] cv5250OrdClasses = new Class[256];
    protected List<XI5250Ord> ivOrdVect;
    protected boolean[] ivOrdPresent = new boolean[256];

    protected XI5250OrdList(XI5250Emulator aEmulator) {
        this.init(aEmulator);
    }

    public boolean isOrderPresent(byte aOrder) {
        return this.ivOrdPresent[aOrder];
    }

    @Override
    protected void readFrom5250Stream(InputStream inStream) throws IOException, XI5250Exception {
        block17: {
            int bb;
            this.ivOrdVect = new ArrayList<XI5250Ord>(100);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("  START OF ORDERS LIST");
            }
            while (true) {
                XI5250Ord ord;
                inStream.mark(1);
                bb = inStream.read();
                if (bb == -1) break block17;
                if ((byte)bb == 4) {
                    inStream.reset();
                    break block17;
                }
                if (XIDataOrd.isDataCharacter(bb)) {
                    inStream.reset();
                    if (this.ivEmulator.isStrPcCmdEnabled()) {
                        inStream.mark(XI5250Emulator.STRPCCMD.length);
                        byte[] lhbb = new byte[XI5250Emulator.STRPCCMD.length];
                        int sz = inStream.read(lhbb);
                        if (sz == XI5250Emulator.STRPCCMD.length) {
                            if (Arrays.equals(lhbb, XI5250Emulator.STRPCCMD)) {
                                this.ivEmulator.receivedStrPcCmd();
                            } else if (Arrays.equals(lhbb, XI5250Emulator.ENDSTRPCCMD)) {
                                this.ivEmulator.receivedEndStrPcCmd();
                            } else {
                                inStream.reset();
                            }
                        } else {
                            inStream.reset();
                        }
                    }
                } else {
                    this.ivOrdPresent[bb] = true;
                }
                try {
                    ord = this.createOrdInstance(bb);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                if (ord == null) break;
                ord.init(this.ivEmulator);
                ord.readFrom5250Stream(inStream);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("  " + ord);
                }
                this.ivOrdVect.add(ord);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Order not supported : 0x" + XITelnet.toHex((byte)bb));
                for (int ii = 0; ii < this.ivOrdVect.size(); ++ii) {
                    LOGGER.fine("Prev. order[" + ii + "]: " + this.ivOrdVect.get(ii));
                }
                byte[] buf = new byte[10];
                int count = inStream.read(buf);
                LOGGER.fine("Next " + count + " bytes: " + XITelnet.toHex(buf, count));
            }
            throw new XI5250Exception("Order not supported : 0x" + XITelnet.toHex((byte)bb), 10030101);
        }
    }

    @Override
    protected void execute() {
        for (XI5250Ord anIvOrdVect : this.ivOrdVect) {
            anIvOrdVect.execute();
        }
    }

    public XI5250Ord createOrdInstance(int aOrd) throws IllegalAccessException, InstantiationException {
        Class cls = XIDataOrd.isDataCharacter(aOrd) ? XIDataOrd.class : cv5250OrdClasses[aOrd];
        if (cls != null) {
            return (XI5250Ord)cls.newInstance();
        }
        return null;
    }

    public String toString() {
        return super.toString() + this.ivOrdVect.toString();
    }

    static {
        XI5250OrdList.cv5250OrdClasses[19] = XIICOrd.class;
        XI5250OrdList.cv5250OrdClasses[2] = XIRAOrd.class;
        XI5250OrdList.cv5250OrdClasses[17] = XISBAOrd.class;
        XI5250OrdList.cv5250OrdClasses[29] = XISFOrd.class;
        XI5250OrdList.cv5250OrdClasses[1] = XISOHOrd.class;
        XI5250OrdList.cv5250OrdClasses[20] = XIMCOrd.class;
        XI5250OrdList.cv5250OrdClasses[3] = XIEAOrd.class;
        XI5250OrdList.cv5250OrdClasses[16] = XITDOrd.class;
        XI5250OrdList.cv5250OrdClasses[18] = XIWEAOrd.class;
        XI5250OrdList.cv5250OrdClasses[21] = XIWdsfOrd.class;
    }
}

