/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.tn5250;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.infordata.em.crt5250.XIEbcdicTranslator;
import net.infordata.em.tn5250.XI5250Emulator;
import net.infordata.em.tn5250.XI5250Frame;

public class Test {
    private Test() {
    }

    private static void usageError(String msg) {
        System.err.println(msg);
        System.err.println("Usage: [-3dFX] [-altFKeyRemap] [-cp codepage] host-name");
        System.err.println("Supported code pages:");
        for (String cp : XIEbcdicTranslator.getRegisteredTranslators().keySet()) {
            System.err.println("  " + cp + ("CP1144".equalsIgnoreCase(cp) ? " default" : ""));
        }
        System.exit(1);
    }

    public static void main(String[] args) {
        boolean pUse3dFX = false;
        boolean pAltFKeyRemap = false;
        String pHost = null;
        boolean expectCP = false;
        String cp = null;
        for (String arg1 : args) {
            String arg = arg1;
            if (arg.startsWith("-")) {
                if ("-3dfx".equalsIgnoreCase(arg)) {
                    pUse3dFX = true;
                    continue;
                }
                if ("-altFKeyRemap".equalsIgnoreCase(arg)) {
                    pAltFKeyRemap = true;
                    continue;
                }
                if ("-cp".equalsIgnoreCase(arg)) {
                    expectCP = true;
                    continue;
                }
                Test.usageError("Wrong option: " + arg);
                continue;
            }
            if (expectCP) {
                expectCP = false;
                if (XIEbcdicTranslator.getTranslator(arg) == null) {
                    Test.usageError("Unknown codepage: " + arg);
                }
                cp = arg;
                continue;
            }
            if (pHost == null) {
                pHost = arg;
                continue;
            }
            Test.usageError("Too many host names.");
        }
        if (expectCP) {
            Test.usageError("A code page is expected");
        }
        boolean altFKeyRemap = pAltFKeyRemap;
        boolean use3dFX = pUse3dFX;
        String host = pHost;
        String codePage = cp;
        try {
            SwingUtilities.invokeAndWait(() -> {
                XI5250Emulator em = new XI5250Emulator();
                em.setTerminalType("IBM-3477-FC");
                em.setKeyboardQueue(true);
                em.setAltFKeyRemap(altFKeyRemap);
                em.setCodePage(codePage);
                if (host != null) {
                    em.setHost(host);
                    em.setActive(true);
                }
                XI5250Frame frm = new XI5250Frame("tn5250 1.19m", em);
                frm.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        System.exit(0);
                    }
                });
                if (use3dFX) {
                    em.setDefFieldsBorderStyle(3);
                    em.setDefBackground(UIManager.getColor("control"));
                }
                frm.centerOnScreen(70);
                frm.setVisible(true);
            });
        }
        catch (InterruptedException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }
}

