/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em.crt5250;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import net.infordata.em.crt5250.XI5250Crt;
import net.infordata.em.crt5250.XI5250CrtCtrl;
import net.infordata.em.crt5250.XIImagesBdl;
import net.infordata.em.util.XICommandMgr;
import net.infordata.em.util.XIUtil;

public class XI5250CrtFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static XIImagesBdl cvImagesBdl = XIImagesBdl.getImagesBdl();
    private static ResourceBundle cvRes = ResourceBundle.getBundle("net.infordata.em.crt5250.resources.Res");
    private boolean ivPending;
    private boolean ivOpened;
    private boolean ivFirstTime = true;
    private boolean ivSizeControlledFrame = false;
    private XI5250CrtCtrl ivCrtCtrl;
    public static final String EXIT_CMD = "EXIT_CMD";

    public XI5250CrtFrame(String aTitle, XI5250Crt aCrt) {
        this(aTitle, aCrt, false, true, true);
    }

    public XI5250CrtFrame(String aTitle, XI5250Crt aCrt, boolean dspToolBar, boolean dspMenuBar) {
        this(aTitle, aCrt, false, dspToolBar, dspMenuBar);
    }

    public XI5250CrtFrame(String aTitle, XI5250Crt aCrt, boolean sizeControlledFrame, boolean dspToolBar, boolean dspMenuBar) {
        super(aTitle);
        this.ivSizeControlledFrame = sizeControlledFrame;
        if (aCrt == null) {
            throw new IllegalArgumentException("An XI5250Crt instance is required.");
        }
        this.setDefaultCloseOperation(0);
        this.ivCrtCtrl = this.createController(aCrt);
        this.enableEvents(64L);
        XI5250Crt.SupportPanel panel = new XI5250Crt.SupportPanel(this.getCrt());
        panel.setBackground(this.getCrt().getBackground());
        this.getContentPane().add((Component)panel, "Center");
        this.getCrt().addPropertyChangeListener(this::emulatorPropertyChanged);
        if (dspToolBar) {
            JToolBar toolBar = this.createToolBar();
            this.getContentPane().add((Component)toolBar, "North");
        }
        if (dspMenuBar) {
            JMenuBar menuBar = this.createMenuBar();
            this.setJMenuBar(menuBar);
        }
        this.getCommandMgr().setCommand(EXIT_CMD, this::processExitCmd);
    }

    public void doNotPackOnStartup() {
        this.ivFirstTime = false;
    }

    protected void processExitCmd() {
        this.setVisible(false);
        this.dispose();
    }

    protected XI5250CrtCtrl createController(XI5250Crt crt) {
        return new XI5250CrtCtrl(crt);
    }

    protected final XI5250CrtCtrl getCrtCtrl() {
        return this.ivCrtCtrl;
    }

    public final XI5250Crt getCrt() {
        return this.ivCrtCtrl.getCrt();
    }

    private void emulatorPropertyChanged(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("background".equals(propertyName)) {
            this.getCrt().getParent().setBackground(this.getCrt().getBackground());
        } else if ("font".equals(propertyName) || "crtSize".equals(propertyName)) {
            this.getCrt().revalidate();
            this.sizeChanged();
        }
    }

    public final XICommandMgr getCommandMgr() {
        return this.ivCrtCtrl.getCommandMgr();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.sizeChanged();
    }

    protected void sizeChanged() {
        if (this.ivOpened && !this.ivPending) {
            this.ivPending = true;
            SwingUtilities.invokeLater(() -> {
                try {
                    if (this.ivFirstTime || this.ivSizeControlledFrame) {
                        this.ivFirstTime = false;
                        this.pack();
                    }
                }
                finally {
                    this.ivPending = false;
                }
            });
        }
    }

    public void centerOnScreen() {
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dim = this.getSize();
        this.setBounds((ss.width - dim.width) / 2, (ss.height - dim.height) / 2, dim.width, dim.height);
    }

    public void centerOnScreen(int perc) {
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dim = this.getSize();
        dim.width = ss.width * perc / 100;
        dim.height = ss.height * perc / 100;
        this.setBounds((ss.width - dim.width) / 2, (ss.height - dim.height) / 2, dim.width, dim.height);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 200: {
                this.getCrt().requestFocus();
                this.ivOpened = true;
                this.sizeChanged();
                break;
            }
            case 201: {
                this.getCommandMgr().dispatchCommand(EXIT_CMD);
                break;
            }
        }
        super.processWindowEvent(e);
    }

    protected JMenuBar createMenuBar() {
        String str = cvRes.getString("TXT_Edit");
        JMenu editMenu = new JMenu(XIUtil.removeMnemonics(str));
        editMenu.setMnemonic(XIUtil.getMnemonic(str));
        JMenuItem copyItem = new JMenuItem(cvRes.getString("TXT_Copy"));
        JMenuItem pasteItem = new JMenuItem(cvRes.getString("TXT_Paste"));
        JMenuItem printItem = new JMenuItem(cvRes.getString("TXT_Print"));
        editMenu.add(copyItem);
        editMenu.add(pasteItem);
        editMenu.addSeparator();
        editMenu.add(printItem);
        this.getCommandMgr().handleCommand(copyItem, "COPY_CMD");
        this.getCommandMgr().handleCommand(pasteItem, "PASTE_CMD");
        this.getCommandMgr().handleCommand(printItem, "PRINT_CMD");
        str = cvRes.getString("TXT_Options");
        JMenu optionsMenu = new JMenu(XIUtil.removeMnemonics(str));
        optionsMenu.setMnemonic(XIUtil.getMnemonic(str));
        JCheckBoxMenuItem switch3DfxItem = new JCheckBoxMenuItem(cvRes.getString("TXT_3dFx"));
        JCheckBoxMenuItem referenceCursorItem = new JCheckBoxMenuItem(cvRes.getString("TXT_RefCursor"));
        optionsMenu.add(switch3DfxItem);
        optionsMenu.add(referenceCursorItem);
        this.getCommandMgr().handleCommand(switch3DfxItem, "SWITCH_3DFX_CMD");
        this.getCommandMgr().handleCommand(referenceCursorItem, "REFERENCE_CURSOR_CMD");
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(editMenu);
        menuBar.add(optionsMenu);
        return menuBar;
    }

    protected JToolBar createToolBar() {
        AbstractButton[] buttons = new AbstractButton[]{new JButton(cvImagesBdl.getIcon("Copy")), new JButton(cvImagesBdl.getIcon("Paste")), null, new JButton(cvImagesBdl.getIcon("Print")), null, new JToggleButton(cvImagesBdl.getIcon("3dFx")), new JToggleButton(cvImagesBdl.getIcon("RefCursor"))};
        String[] buttonsActCmd = new String[]{"COPY_CMD", "PASTE_CMD", null, "PRINT_CMD", null, "SWITCH_3DFX_CMD", "REFERENCE_CURSOR_CMD"};
        String[] buttonHints = new String[]{cvRes.getString("TXT_Copy"), cvRes.getString("TXT_Paste"), null, cvRes.getString("TXT_Print"), null, cvRes.getString("TXT_3dFx"), cvRes.getString("TXT_RefCursor")};
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        Dimension size = new Dimension(26, 26);
        for (int i = 0; i < buttons.length; ++i) {
            if (buttons[i] != null) {
                AbstractButton button = buttons[i];
                toolBar.add(button);
                button.setToolTipText(buttonHints[i]);
                button.setMinimumSize(size);
                button.setPreferredSize(size);
                button.setMaximumSize(size);
                button.setRequestFocusEnabled(false);
                this.getCommandMgr().handleCommand(button, buttonsActCmd[i]);
                continue;
            }
            toolBar.addSeparator();
        }
        return toolBar;
    }
}

