/*
 * Decompiled with CFR 0.152.
 */
package net.infordata.em;

import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.infordata.em.crt5250.XI5250Field;
import net.infordata.em.crt5250.XIEbcdicTranslator;
import net.infordata.em.tn5250.XI5250Emulator;
import net.infordata.em.tn5250.XI5250Frame;
import net.infordata.em.tn5250ext.PSHBTNCHCHandler;
import net.infordata.em.tn5250ext.XI5250EmulatorExt;
import net.infordata.em.tn5250ext.XI5250PanelHandler;
import net.infordata.em.tn5250ext.XI5250PanelsDispatcher;

public class Main {
    private Main() {
    }

    private static void usageError(String msg) {
        System.err.println(msg);
        System.err.println("Usage: [-3dFX] [-PSHBTNCHC] [-STRPCCMD] [-altFKeyRemap] [-maximized] [-cp codepage] [-devName name] [-autoLogon <fieldsCount>;<usrFieldLabel>;<pwdFieldLabel>;<user>;<passwd>] [-hideToolBar] [-hideMenuBar] host-name");
        System.err.println("Supported code pages:");
        for (String cp : XIEbcdicTranslator.getRegisteredTranslators().keySet()) {
            System.err.println("  " + cp + ("CP1144".equalsIgnoreCase(cp) ? " default" : ""));
        }
        System.exit(1);
    }

    public static void main(String[] args) {
        boolean pUse3dFX = false;
        boolean pAltFKeyRemap = false;
        boolean pPSHBTNCHC = false;
        boolean pSTRPCCMD = false;
        boolean pMaximized = false;
        boolean wkToolBar = true;
        boolean wkMenuBar = true;
        String pHost = null;
        boolean expectCP = false;
        boolean expectDevName = false;
        boolean expectLogonInfo = false;
        String cp = null;
        String devName = null;
        LogonInfo logonInfo = null;
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if ("-3dfx".equalsIgnoreCase(arg)) {
                    pUse3dFX = true;
                    continue;
                }
                if ("-PSHBTNCHC".equalsIgnoreCase(arg)) {
                    pPSHBTNCHC = true;
                    continue;
                }
                if ("-STRPCCMD".equalsIgnoreCase(arg)) {
                    pSTRPCCMD = true;
                    continue;
                }
                if ("-maximized".equalsIgnoreCase(arg)) {
                    pMaximized = true;
                    continue;
                }
                if ("-altFKeyRemap".equalsIgnoreCase(arg)) {
                    pAltFKeyRemap = true;
                    continue;
                }
                if ("-cp".equalsIgnoreCase(arg)) {
                    expectCP = true;
                    continue;
                }
                if ("-devName".equalsIgnoreCase(arg)) {
                    expectDevName = true;
                    continue;
                }
                if ("-autoLogon".equalsIgnoreCase(arg)) {
                    expectLogonInfo = true;
                    continue;
                }
                if ("-hideToolBar".equalsIgnoreCase(arg)) {
                    wkToolBar = false;
                    continue;
                }
                if ("-hideMenuBar".equalsIgnoreCase(arg)) {
                    wkMenuBar = false;
                    continue;
                }
                Main.usageError("Wrong option: " + arg);
                continue;
            }
            if (expectCP) {
                expectCP = false;
                if (XIEbcdicTranslator.getTranslator(arg) == null) {
                    Main.usageError("Unknown codepage: " + arg);
                }
                cp = arg;
                continue;
            }
            if (expectDevName) {
                expectDevName = false;
                devName = arg;
                continue;
            }
            if (expectLogonInfo) {
                expectLogonInfo = false;
                try {
                    logonInfo = new LogonInfo(arg);
                }
                catch (IllegalArgumentException ex) {
                    Main.usageError(ex.getMessage());
                }
                continue;
            }
            if (pHost == null) {
                pHost = arg;
                continue;
            }
            Main.usageError("Too many host names.");
        }
        boolean dspToolBar = wkToolBar;
        boolean dspMenuBar = wkMenuBar;
        if (expectCP) {
            Main.usageError("A code page is expected");
        }
        boolean altFKeyRemap = pAltFKeyRemap;
        boolean use3dFX = pUse3dFX;
        boolean enablePSHBTNCHC = pPSHBTNCHC;
        boolean enableSTRPCCMD = pSTRPCCMD;
        boolean maximized = pMaximized;
        String host = pHost;
        String codePage = cp;
        String deviceName = devName;
        LogonInfo autoLogonInfo = logonInfo;
        try {
            SwingUtilities.invokeAndWait(() -> {
                XI5250Emulator em;
                XI5250EmulatorExt emext;
                if (enablePSHBTNCHC) {
                    emext = new XI5250EmulatorExt();
                    PanelsDispatcher disp = new PanelsDispatcher();
                    disp.setEmulator(emext);
                    new PSHBTNCHCHandler(disp);
                    if (autoLogonInfo != null) {
                        new AutoLogonHandler(disp, autoLogonInfo);
                    }
                    em = emext;
                } else if (autoLogonInfo != null) {
                    emext = new XI5250EmulatorExt();
                    PanelsDispatcher disp = new PanelsDispatcher();
                    disp.setEmulator(emext);
                    new AutoLogonHandler(disp, autoLogonInfo);
                    em = emext;
                } else {
                    em = new XI5250Emulator();
                }
                em.setTerminalType("IBM-3477-FC");
                em.setKeyboardQueue(true);
                em.setStrPcCmdEnabled(enableSTRPCCMD);
                em.setAltFKeyRemap(altFKeyRemap);
                em.setCodePage(codePage);
                if (deviceName != null) {
                    em.setTelnetEnv("\u0003DEVNAME\u0001" + deviceName);
                }
                if (host != null) {
                    em.setHost(host);
                    em.setActive(true);
                }
                XI5250Frame frm = new XI5250Frame("tn5250 1.19m", em, dspToolBar, dspMenuBar);
                frm.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        System.exit(0);
                    }
                });
                if (use3dFX) {
                    em.setDefFieldsBorderStyle(3);
                    em.setDefBackground(UIManager.getColor("control"));
                }
                frm.centerOnScreen(70);
                if (maximized) {
                    frm.doNotPackOnStartup();
                    frm.setExtendedState(6);
                }
                frm.setVisible(true);
            });
        }
        catch (InterruptedException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    private static class AutoLogonHandler
    extends XI5250PanelHandler {
        private final LogonInfo ivLogonInfo;
        private boolean ivLoggedOn;

        private AutoLogonHandler(XI5250PanelsDispatcher aPanelDisp, LogonInfo info) {
            super(aPanelDisp);
            this.ivLogonInfo = info;
        }

        @Override
        protected boolean detailedTest() {
            if (this.ivLoggedOn) {
                return false;
            }
            if (this.getFields().size() != this.ivLogonInfo.fieldsCount) {
                return false;
            }
            if (!this.checkField(this.getFieldNextTo(this.ivLogonInfo.userLabel), 10)) {
                return false;
            }
            return this.checkField(this.getFieldNextTo(this.ivLogonInfo.passwdLabel), 10);
        }

        @Override
        protected void start() {
            this.ivLoggedOn = true;
            XI5250Field userField = this.getFieldNextTo(this.ivLogonInfo.userLabel);
            XI5250Field passwdField = this.getFieldNextTo(this.ivLogonInfo.passwdLabel);
            userField.setString(this.ivLogonInfo.user);
            passwdField.setString(this.ivLogonInfo.passwd);
            this.getEmulator().processRawKeyEvent(new KeyEvent(this.getEmulator(), 401, 0L, 0, 10, '\uffff'));
        }

        @Override
        protected void stop() {
        }
    }

    private static class LogonInfo {
        final int fieldsCount;
        final String userLabel;
        final String passwdLabel;
        final String user;
        final String passwd;

        private LogonInfo(String info) {
            String[] ss = info.split(";", 5);
            if (ss.length < 5) {
                throw new IllegalArgumentException("Invalid autoLogon argument");
            }
            try {
                this.fieldsCount = Integer.parseInt(ss[0]);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Invalid autoLogon argument: " + ex.getMessage());
            }
            this.userLabel = ss[1];
            this.passwdLabel = ss[2];
            this.user = ss[3];
            this.passwd = ss[4];
        }
    }

    private static class PanelsDispatcher
    extends XI5250PanelsDispatcher {
        private AutoLogonHandler ivAutoLogonHandler;
        private XI5250PanelHandler ivHandler;

        private PanelsDispatcher() {
        }

        @Override
        public synchronized void addPanelHandler(XI5250PanelHandler panel) {
            if (panel instanceof AutoLogonHandler) {
                if (this.ivAutoLogonHandler != null) {
                    throw new IllegalArgumentException("Handler already setted");
                }
                this.ivAutoLogonHandler = (AutoLogonHandler)panel;
                return;
            }
            if (this.ivHandler != null) {
                throw new IllegalArgumentException("Handler already setted");
            }
            this.ivHandler = panel;
        }

        @Override
        protected synchronized XI5250PanelHandler getCurrentPanelHandler() {
            return this.ivAutoLogonHandler != null && this.ivAutoLogonHandler.detailedTest() ? this.ivAutoLogonHandler : this.ivHandler;
        }

        @Override
        public synchronized void removePanelHandler(XI5250PanelHandler panel) {
            if (this.ivHandler != panel) {
                throw new IllegalArgumentException("Not the registered handler " + panel);
            }
            this.ivHandler = null;
        }
    }
}

