/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.jvt220.terminal.vt220;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import nl.lxtreme.jvt220.terminal.ITerminal;
import nl.lxtreme.jvt220.terminal.ITerminalFrontend;
import nl.lxtreme.jvt220.terminal.vt220.AbstractTerminal;
import nl.lxtreme.jvt220.terminal.vt220.CharacterSets;
import nl.lxtreme.jvt220.terminal.vt220.TextAttributes;
import nl.lxtreme.jvt220.terminal.vt220.VT220Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VT220Terminal
extends AbstractTerminal
implements VT220Parser.VT220ParserHandler {
    private static final Logger LOG = LoggerFactory.getLogger(VT220Terminal.class);
    private static final int OPTION_132COLS = 5;
    private static final int OPTION_ENABLE_132COLS = 6;
    private static final int OPTION_8BIT = 7;
    private static final int OPTION_ERASURE_MODE = 8;
    private static final int OPTION_REVERSE_WRAP_AROUND = 9;
    private static final int OPTION_APPLICATION_CURSOR_KEYS = 10;
    private final GraphicSetState m_graphicSetState = new GraphicSetState();
    private final VT220Parser m_vt220parser = new VT220Parser();
    private final StateHolder m_savedState = new StateHolder();
    private boolean alarmSounded;

    public VT220Terminal(int columns, int lines) {
        super(columns, lines);
        this.reset();
    }

    @Override
    public void handleCharacter(char ch) throws IOException {
        int idx = this.getAbsoluteCursorIndex();
        idx = this.isInsertMode() ? this.insertChars(idx, this.m_graphicSetState.map(ch), 1) + 1 : this.writeChar(idx, this.m_graphicSetState.map(ch));
        this.updateCursorByAbsoluteIndex(idx);
    }

    @Override
    public void handleControl(char controlChar) throws IOException {
        int idx = this.getAbsoluteCursorIndex();
        switch (controlChar) {
            case '\u0005': {
                this.write(this.getClass().getSimpleName());
                break;
            }
            case '\u000e': {
                this.m_graphicSetState.setGL(1);
                break;
            }
            case '\u000f': {
                this.m_graphicSetState.setGL(0);
                break;
            }
            case '\u0007': {
                this.alarmSounded = true;
                Toolkit.getDefaultToolkit().beep();
                break;
            }
            case '\b': {
                if (this.isWrapped() && (this.isAutoWrapMode() || this.isReverseWrapAround())) {
                    if ((idx -= this.isWrapped() ? 2 : 1) >= this.getAbsoluteIndex(0, this.getFirstScrollLine())) break;
                    idx = this.getAbsoluteIndex(this.getWidth(), this.getLastScrollLine());
                    break;
                }
                idx -= idx % this.getWidth() == 0 ? 0 : 1;
                break;
            }
            case '\t': {
                idx += this.getTabulator().getNextTabWidth(idx % this.getWidth());
                break;
            }
            case '\n': 
            case '\u000b': 
            case '\f': {
                int row = idx / this.getWidth();
                if (row >= this.getLastScrollLine()) {
                    this.scrollUp(1);
                } else {
                    idx += this.getWidth();
                }
                if (!this.isAutoNewlineMode()) break;
            }
            case '\r': {
                if (this.isWrapped() && this.isAutoWrapMode()) {
                    --idx;
                }
                idx -= idx % this.getWidth();
                break;
            }
            default: {
                LOG.warn("Unknown control character: {}", (Object)controlChar);
            }
        }
        this.updateCursorByAbsoluteIndex(idx);
        this.resetWrapped();
    }

    @Override
    public void handleCSI(VT220Parser.CSIType type, int ... parameters) throws IOException {
        int idx = this.getAbsoluteCursorIndex();
        block0 : switch (type) {
            case ICH: {
                int count = parameters[0];
                idx = this.insertChars(idx, ' ', count);
                break;
            }
            case SL: {
                int count = parameters[0];
                int last = this.getLastScrollLine();
                for (int r = this.getFirstScrollLine(); r < last; ++r) {
                    this.deleteChars(this.getAbsoluteIndex(0, r), count);
                }
                break;
            }
            case CUU: {
                int n = parameters[0];
                int col = idx % this.getWidth();
                int row = Math.max(this.getFirstScrollLine(), idx / this.getWidth() - n);
                idx = this.getAbsoluteIndex(col, row);
                break;
            }
            case SR: {
                int count = parameters[0];
                int last = this.getLastScrollLine();
                for (int r = this.getFirstScrollLine(); r < last; ++r) {
                    this.insertChars(this.getAbsoluteIndex(0, r), ' ', count);
                }
                break;
            }
            case CUD: {
                int n = parameters[0];
                int col = idx % this.getWidth();
                int row = Math.min(this.getLastScrollLine(), idx / this.getWidth() + n);
                idx = this.getAbsoluteIndex(col, row);
                break;
            }
            case CUF: {
                int n = parameters[0];
                int col = Math.min(this.getWidth() - 1, idx % this.getWidth() + n);
                int row = idx / this.getWidth();
                idx = this.getAbsoluteIndex(col, row);
                break;
            }
            case CUB: {
                int n = parameters[0];
                if (this.isAutoWrapMode() && this.isWrapped()) {
                    idx = Math.max(this.getFirstAbsoluteIndex(), idx - n);
                    break;
                }
                int col = Math.max(0, idx % this.getWidth() - n);
                int row = idx / this.getWidth();
                idx = this.getAbsoluteIndex(col, row);
                break;
            }
            case CNL: {
                int n = parameters[0];
                int col = 0;
                int row = Math.min(this.getLastScrollLine(), idx / this.getWidth() + n);
                idx = this.getAbsoluteIndex(col, row);
                break;
            }
            case CPL: {
                int n = parameters[0];
                int col = 0;
                int row = Math.max(this.getFirstScrollLine(), idx / this.getWidth() - n);
                idx = this.getAbsoluteIndex(col, row);
                break;
            }
            case CHA: {
                int x = parameters[0];
                int col = Math.max(0, Math.min(this.getWidth(), x - 1));
                int row = Math.max(this.getFirstScrollLine(), Math.min(this.getLastScrollLine(), idx / this.getWidth()));
                idx = this.getAbsoluteIndex(col, row);
                break;
            }
            case CUP: {
                int row = parameters[0] - 1;
                int col = parameters[1] - 1;
                if (this.isOriginMode()) {
                    row += this.getFirstScrollLine();
                }
                if (row > this.getLastScrollLine()) {
                    row = this.getLastScrollLine();
                }
                if (col >= this.getWidth()) {
                    col = this.getWidth() - 1;
                }
                idx = this.getAbsoluteIndex(col, row);
                break;
            }
            case CHT: {
                int count = parameters[0];
                while (count-- > 0) {
                    idx += this.getTabulator().getNextTabWidth(idx % this.getWidth());
                }
                break;
            }
            case ED: {
                int mode = parameters[0];
                this.clearScreen(mode, idx, this.isErasureMode());
                break;
            }
            case DECSED: {
                int mode = parameters[0];
                this.clearScreen(mode, idx, true);
                break;
            }
            case EL: {
                int mode = parameters[0];
                this.clearLine(mode, idx, this.isErasureMode());
                break;
            }
            case DECSEL: {
                int mode = parameters[0];
                this.clearLine(mode, idx, true);
                break;
            }
            case IL: {
                int lines = parameters[0];
                int row = idx / this.getWidth();
                if (row < this.getFirstScrollLine() || row >= this.getLastScrollLine()) break;
                int col = idx % this.getWidth();
                this.scrollDown(row, this.getLastScrollLine(), lines);
                idx -= col;
                break;
            }
            case DL: {
                int lines = parameters[0];
                int row = idx / this.getWidth();
                if (row < this.getFirstScrollLine() || row >= this.getLastScrollLine()) break;
                int col = idx % this.getWidth();
                this.scrollUp(row, this.getLastScrollLine(), lines);
                idx -= col;
                break;
            }
            case DCH: {
                int count = parameters[0];
                idx = this.deleteChars(idx, count);
                break;
            }
            case SU: {
                int lines = parameters[0];
                this.scrollUp(lines);
                break;
            }
            case SD: {
                int lines = parameters[0];
                this.scrollDown(lines);
                break;
            }
            case ECH: {
                int n = parameters[0] - 1;
                int tmpIdx = idx;
                if (tmpIdx + n > this.getWidth()) {
                    n = this.getWidth() - tmpIdx % this.getWidth() - 1;
                }
                do {
                    this.removeChar(tmpIdx++, this.isErasureMode());
                } while (n-- > 0);
                break;
            }
            case CBT: {
                int count = parameters[0];
                while (count-- > 0) {
                    idx -= this.getTabulator().getPreviousTabWidth(idx % this.getWidth());
                }
                break;
            }
            case HPR: {
                int n = parameters[0];
                int w = this.getWidth();
                int col = Math.min(w - 1, idx % w + n);
                int row = idx / w;
                idx = this.getAbsoluteIndex(col, row);
                break;
            }
            case REP: {
                int count = parameters[0];
                char ch = (char)parameters[1];
                while (count-- > 0) {
                    idx = this.writeChar(idx, ch);
                }
                break;
            }
            case PrimaryDA: {
                int arg = parameters[0];
                this.sendDeviceAttributes(arg);
                break;
            }
            case SecondaryDA: {
                int arg = parameters[0];
                if (arg != 0) break;
                this.writeResponse(ResponseType.CSI, ">1;123;0c");
                break;
            }
            case VPA: {
                int row = parameters[0] - 1;
                int col = idx % this.getWidth();
                if (row < this.getFirstScrollLine()) {
                    row = this.getFirstScrollLine();
                } else if (row > this.getLastScrollLine()) {
                    row = this.getLastScrollLine();
                }
                idx = this.getAbsoluteIndex(col, row);
                break;
            }
            case VPR: {
                int n = parameters[0];
                int col = idx % this.getWidth();
                int row = idx / this.getWidth() + n;
                if (row > this.getLastScrollLine()) {
                    row = this.getLastScrollLine();
                }
                idx = this.getAbsoluteIndex(col, row);
                break;
            }
            case TBC: {
                int arg = parameters[0];
                if (arg == 0) {
                    int col = idx % this.getWidth();
                    this.getTabulator().clear(col);
                    break;
                }
                if (arg != 3) break;
                this.clearAllTabStops();
                break;
            }
            case SM: {
                int arg = parameters[0];
                switch (arg) {
                    case 4: {
                        this.setInsertMode(true);
                        break block0;
                    }
                    case 6: {
                        this.setErasureMode(false);
                        break block0;
                    }
                    case 20: {
                        this.setAutoNewlineMode(true);
                        break block0;
                    }
                }
                LOG.warn("Unknown SET MODE: {}", (Object)arg);
                break;
            }
            case DECSET: {
                int arg = parameters[0];
                switch (arg) {
                    case 1: {
                        this.setApplicationCursorKeys(true);
                        break;
                    }
                    case 2: {
                        this.m_graphicSetState.resetState();
                        this.set8bitMode(false);
                        break;
                    }
                    case 3: {
                        if (!this.isEnable132ColumnMode()) break block0;
                        this.set132ColumnMode(true);
                        this.clearScreen(2);
                        this.setOriginMode(false);
                        this.setScrollRegion(this.getFirstScrollLine(), this.getLastScrollLine());
                        idx = this.getAbsoluteIndex(0, this.getFirstScrollLine());
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        this.setReverse(true);
                        break;
                    }
                    case 6: {
                        this.setOriginMode(true);
                        idx = this.getAbsoluteIndex(0, this.getFirstScrollLine());
                        break;
                    }
                    case 7: {
                        this.setAutoWrap(true);
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 25: {
                        this.getCursor().setVisible(true);
                        break;
                    }
                    case 40: {
                        this.setEnable132ColumnMode(true);
                        break;
                    }
                    case 45: {
                        this.setReverseWrapAround(true);
                        break;
                    }
                    default: {
                        LOG.warn("Unknown DEC SET PRIVATE MODE: {}", (Object)arg);
                        break;
                    }
                }
                break;
            }
            case MC: 
            case DECSMC: {
                break;
            }
            case HPB: {
                int n = parameters[0];
                int col = Math.max(0, idx % this.getWidth() - n);
                int row = idx / this.getWidth();
                idx = this.getAbsoluteIndex(col, row);
                break;
            }
            case VPB: {
                int n = parameters[0];
                int w = this.getWidth();
                int col = idx % w;
                int row = Math.max(this.getFirstScrollLine(), idx / w - n);
                idx = this.getAbsoluteIndex(col, row);
                break;
            }
            case RM: {
                int arg = parameters[0];
                switch (arg) {
                    case 4: {
                        this.setInsertMode(false);
                        break block0;
                    }
                    case 6: {
                        this.setErasureMode(true);
                        break block0;
                    }
                    case 20: {
                        this.setAutoNewlineMode(false);
                        break block0;
                    }
                }
                LOG.warn("Unknown RESET MODE: {}", (Object)arg);
                break;
            }
            case DECRST: {
                int arg = parameters[0];
                switch (arg) {
                    case 1: {
                        this.setApplicationCursorKeys(false);
                        break block0;
                    }
                    case 2: {
                        this.m_graphicSetState.resetState();
                        break block0;
                    }
                    case 3: {
                        this.set132ColumnMode(false);
                        this.clearScreen(2);
                        this.setOriginMode(false);
                        this.setScrollRegion(this.getFirstScrollLine(), this.getLastScrollLine());
                        idx = this.getAbsoluteIndex(0, this.getFirstScrollLine());
                        break block0;
                    }
                    case 4: {
                        break block0;
                    }
                    case 5: {
                        this.setReverse(false);
                        break block0;
                    }
                    case 6: {
                        this.setOriginMode(false);
                        idx = this.getAbsoluteIndex(0, this.getFirstScrollLine());
                        break block0;
                    }
                    case 7: {
                        this.setAutoWrap(false);
                        break block0;
                    }
                    case 8: {
                        break block0;
                    }
                    case 25: {
                        this.getCursor().setVisible(false);
                        break block0;
                    }
                    case 40: {
                        this.setEnable132ColumnMode(false);
                        break block0;
                    }
                    case 45: {
                        this.setReverseWrapAround(false);
                        break block0;
                    }
                }
                LOG.warn("Unknown DEC RESET PRIVATE MODE: {}", (Object)arg);
                break;
            }
            case SGR: {
                this.handleGraphicsRendering(parameters);
                break;
            }
            case DSR: {
                int arg = parameters[0];
                if (arg == 5) {
                    this.writeResponse(ResponseType.CSI, "0n");
                    break;
                }
                if (arg != 6) break;
                int col = idx % this.getWidth() + 1;
                int row = idx / this.getWidth() + 1;
                this.writeResponse(ResponseType.CSI, String.format("%d;%dR", row, col));
                break;
            }
            case DECSDSR: {
                int arg = parameters[0];
                switch (arg) {
                    case 6: {
                        int col = idx % this.getWidth() + 1;
                        int row = idx / this.getWidth() + 1;
                        this.writeResponse(ResponseType.CSI, String.format("?%d;%dR", row, col));
                        break block0;
                    }
                    case 15: {
                        this.writeResponse(ResponseType.CSI, "?11n");
                        break block0;
                    }
                    case 25: {
                        this.writeResponse(ResponseType.CSI, "?21n");
                        break block0;
                    }
                    case 26: {
                        this.writeResponse(ResponseType.CSI, "?27;1;0;0n");
                        break block0;
                    }
                }
                LOG.warn("Unknown/unhandled DECSDR argument: {}", (Object)arg);
                break;
            }
            case DECSTR: {
                this.softReset();
                break;
            }
            case DECSCL: {
                int compatibilityLevel = parameters[0] - 60;
                int eightBitMode = parameters.length > 1 ? parameters[1] : 0;
                this.setConformanceLevel(compatibilityLevel, eightBitMode != 1);
                break;
            }
            case DECSCA: {
                int mode = parameters[0];
                this.m_textAttributes.setProtected(mode == 1);
                break;
            }
            case DECSTBM: {
                int top = parameters[0];
                int bottom = parameters[1];
                if (bottom == 0) {
                    bottom = this.getHeight();
                }
                if (bottom <= top) break;
                this.setScrollRegion(top - 1, bottom - 1);
                idx = this.getAbsoluteIndex(0, this.getFirstScrollLine());
                break;
            }
            case RestoreDECPM: 
            case DECCARA: 
            case SaveDECPM: {
                break;
            }
            case WindowManipulation: {
                int param = parameters[0];
                switch (param) {
                    case 4: {
                        if (parameters.length != 3) break block0;
                        int height = parameters[1];
                        int width = parameters[2];
                        this.setDimensionsInPixels(width, height);
                        idx = this.getFirstAbsoluteIndex();
                        break;
                    }
                    case 8: {
                        if (parameters.length != 3) break block0;
                        int rows = parameters[1];
                        int cols = parameters[2];
                        this.setDimensions(cols, rows);
                        idx = this.getFirstAbsoluteIndex();
                        break;
                    }
                    case 11: {
                        this.writeResponse(ResponseType.CSI, "1t");
                        break;
                    }
                    case 13: {
                        this.writeResponse(ResponseType.CSI, "3;0;0t");
                        break;
                    }
                    case 14: {
                        int width = 0;
                        int height = 0;
                        ITerminalFrontend frontend = this.getFrontend();
                        if (frontend != null) {
                            Dimension size = frontend.getSize();
                            width = size.width;
                            height = size.height;
                        }
                        this.writeResponse(ResponseType.CSI, String.format("%d;%d;%dt", param - 10, height, width));
                        break;
                    }
                    case 18: 
                    case 19: {
                        this.writeResponse(ResponseType.CSI, String.format("%d;%d;%dt", param - 10, this.getHeight(), this.getWidth()));
                        break;
                    }
                    case 20: {
                        this.writeResponse(ResponseType.OSC, "L\u001b\\");
                        break;
                    }
                    case 21: {
                        this.writeResponse(ResponseType.OSC, "l\u001b\\");
                        break;
                    }
                    default: {
                        if (param < 24) break block0;
                        int cols = this.getWidth();
                        int rows = param;
                        this.setDimensions(cols, rows);
                        idx = this.getFirstAbsoluteIndex();
                        break;
                    }
                }
                break;
            }
            case DECRARA: 
            case DECCRA: 
            case DECEFR: {
                break;
            }
            case DECREQTPARM: {
                int arg = parameters[0];
                this.writeResponse(ResponseType.CSI, String.format("%d;1;1;112;112;1;0x", arg + 2));
                break;
            }
            case DECFRA: 
            case DECELR: 
            case DECERA: 
            case DECSLE: 
            case DECSERA: 
            case DECRQLP: {
                break;
            }
            default: {
                LOG.warn("Unhandled CSI: {}", (Object)type);
            }
        }
        this.updateCursorByAbsoluteIndex(idx);
        this.resetWrapped();
    }

    @Override
    public void handleESC(char designator, int ... parameters) throws IOException {
        int idx = this.getAbsoluteCursorIndex();
        block0 : switch (designator) {
            case 'D': {
                idx = this.handleIND(idx);
                break;
            }
            case 'E': {
                idx = this.handleNEL(idx);
                break;
            }
            case 'H': {
                this.handleTabSet(idx);
                break;
            }
            case 'M': {
                idx = this.handleRI(idx);
                break;
            }
            case 'N': {
                this.handleSS2();
                break;
            }
            case 'O': {
                this.handleSS3();
                break;
            }
            case 'V': {
                this.handleSPA();
                break;
            }
            case 'W': {
                this.handleEPA();
                break;
            }
            case 'Z': {
                this.sendDeviceAttributes(0);
                break;
            }
            case 'c': {
                this.reset();
                idx = this.getFirstAbsoluteIndex();
                break;
            }
            case 'n': {
                this.m_graphicSetState.setGL(2);
                break;
            }
            case 'o': {
                this.m_graphicSetState.setGL(3);
                break;
            }
            case '|': {
                this.m_graphicSetState.setGR(3);
                break;
            }
            case '}': {
                this.m_graphicSetState.setGR(2);
                break;
            }
            case '~': {
                this.m_graphicSetState.setGR(1);
                break;
            }
            case '7': {
                this.saveCursor(idx);
                break;
            }
            case '8': {
                idx = this.restoreCursor();
                break;
            }
            case ' ': {
                char arg = (char)parameters[0];
                switch (arg) {
                    case 'F': {
                        this.set8bitMode(false);
                        break block0;
                    }
                    case 'G': {
                        this.set8bitMode(true);
                        break block0;
                    }
                    case 'L': 
                    case 'M': 
                    case 'N': {
                        break block0;
                    }
                }
                LOG.warn("Unhandled argument for ESC sp: {}", (Object)Character.valueOf(arg));
                break;
            }
            case '#': {
                char arg = (char)parameters[0];
                switch (arg) {
                    case '8': {
                        int last = this.getLastAbsoluteIndex();
                        for (int j = this.getFirstAbsoluteIndex(); j <= last; ++j) {
                            this.writeChar(j, 'E');
                        }
                        break block0;
                    }
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': {
                        break;
                    }
                    default: {
                        LOG.warn("Unhandled argument for ESC sp: {}", (Object)Character.valueOf(arg));
                        break;
                    }
                }
                break;
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': {
                CharacterSets.GraphicSet gs = this.m_graphicSetState.getGraphicSet(designator - 40);
                this.m_graphicSetState.designateGraphicSet(gs, (char)parameters[0]);
                break;
            }
            case '=': {
                this.setApplicationCursorKeys(true);
                break;
            }
            case '>': {
                this.setApplicationCursorKeys(false);
                break;
            }
            default: {
                LOG.warn("Unhandled ESC designator: {}", (Object)Character.valueOf(designator));
            }
        }
        this.updateCursorByAbsoluteIndex(idx);
        this.resetWrapped();
    }

    @Override
    public void reset() {
        this.softReset();
        this.clearScreen(2);
    }

    @Override
    public void setDimensions(int width, int height) {
        if (width <= 0 || height <= 0) {
            Dimension maximumSize = null;
            if (this.getFrontend() != null) {
                maximumSize = this.getFrontend().getMaximumTerminalSize();
            }
            if (width <= 0) {
                int n = width = maximumSize != null ? maximumSize.width : this.getWidth();
            }
            if (height <= 0) {
                height = maximumSize != null ? maximumSize.height : this.getHeight();
            }
        }
        super.setDimensions(width, height);
    }

    @Override
    public void setLogLevel(int aLogLevel) {
        super.setLogLevel(aLogLevel);
        this.m_vt220parser.setLogLevel(aLogLevel);
    }

    @Override
    protected ITerminal.IKeyMapper createKeyMapper() {
        return new VT220KeyMapper();
    }

    @Override
    protected int doReadInput(CharSequence text) throws IOException {
        return this.m_vt220parser.parse(text, this);
    }

    protected final boolean is132ColumnMode() {
        return this.m_options.get(5);
    }

    protected final boolean is8bitMode() {
        return this.m_options.get(7);
    }

    protected final boolean isApplicationCursorKeys() {
        return this.m_options.get(10);
    }

    protected final boolean isEnable132ColumnMode() {
        return this.m_options.get(6);
    }

    protected final boolean isErasureMode() {
        return this.m_options.get(8);
    }

    protected final boolean isReverseWrapAround() {
        return this.m_options.get(9);
    }

    protected final boolean isVT52mode() {
        return this.m_vt220parser.isVT52mode();
    }

    protected final void set132ColumnMode(boolean enable) {
        this.m_options.set(5, enable);
        if (enable) {
            this.setDimensions(132, this.getHeight());
        } else {
            this.setDimensions(80, this.getHeight());
        }
    }

    protected final void set8bitMode(boolean enable) {
        this.m_options.set(7, enable);
    }

    protected final void setApplicationCursorKeys(boolean enable) {
        this.m_options.set(10, enable);
    }

    protected final void setEnable132ColumnMode(boolean enable) {
        this.m_options.set(6, enable);
    }

    protected final void setErasureMode(boolean enable) {
        this.m_options.set(8, enable);
    }

    protected final void setReverseWrapAround(boolean enable) {
        this.m_options.set(9, enable);
    }

    private String createResponse(ResponseType type, String content) {
        StringBuilder sb = new StringBuilder();
        switch (type) {
            case ESC: {
                sb.append("\u001b");
                break;
            }
            case OSC: {
                sb.append(this.is8bitMode() ? Character.valueOf('\u009d') : "\u001b]");
                break;
            }
            case CSI: {
                sb.append(this.is8bitMode() ? Character.valueOf('\u009b') : "\u001b[");
                break;
            }
            case SS3: {
                sb.append(this.is8bitMode() ? Character.valueOf('\u008f') : "\u001bO");
                break;
            }
            default: {
                throw new RuntimeException("Unhandled response type: " + (Object)((Object)type));
            }
        }
        sb.append(content);
        return sb.toString();
    }

    private void handleEPA() {
        this.m_textAttributes.setProtected(false);
    }

    private void handleGraphicsRendering(int[] parameters) {
        boolean containsHiddenAttr = false;
        for (int p : parameters) {
            if (p != 8) continue;
            containsHiddenAttr = true;
            break;
        }
        if (this.m_textAttributes.isHidden() && !containsHiddenAttr) {
            this.m_textAttributes.setHidden(false);
            this.m_textAttributes.setReverse(false);
        }
        for (int p : parameters) {
            this.handleGraphicsRendering(this.m_textAttributes, p);
        }
    }

    private void handleGraphicsRendering(TextAttributes attributes, int parameter) {
        if (parameter == 0 || parameter == 39 || parameter == 49) {
            if (parameter == 0) {
                attributes.resetAll();
            } else {
                attributes.reset();
            }
        }
        if (parameter == 1) {
            attributes.setBold(true);
        } else if (parameter == 4) {
            attributes.setUnderline(true);
        } else if (parameter == 5) {
            attributes.setItalic(true);
        } else if (parameter == 7) {
            attributes.setReverse(true);
        } else if (parameter == 8) {
            attributes.setHidden(true);
        } else if (parameter == 21 || parameter == 22) {
            attributes.setBold(false);
        } else if (parameter == 24) {
            attributes.setUnderline(false);
        } else if (parameter == 25) {
            attributes.setItalic(false);
        } else if (parameter == 27) {
            attributes.setReverse(false);
        } else if (parameter == 28) {
            attributes.setHidden(false);
        } else if (parameter >= 30 && parameter <= 37) {
            attributes.setForeground(parameter - 29);
        } else if (parameter == 39) {
            attributes.setForeground(0);
        } else if (parameter >= 40 && parameter <= 47) {
            attributes.setBackground(parameter - 39);
        } else if (parameter == 49) {
            attributes.setBackground(0);
        } else if (parameter > 0) {
            LOG.warn("Unhandled attribute: {}", (Object)parameter);
        }
    }

    private int handleIND(int index) {
        int col = index % this.getWidth();
        int row = index / this.getWidth() + 1;
        if (row > this.getLastScrollLine()) {
            row = this.getLastScrollLine();
            this.scrollUp(1);
        }
        return this.getAbsoluteIndex(col, row);
    }

    private int handleNEL(int index) {
        int col = 0;
        int row = index / this.getWidth() + 1;
        if (row > this.getLastScrollLine()) {
            row = this.getLastScrollLine();
            this.scrollUp(1);
        }
        return this.getAbsoluteIndex(col, row);
    }

    private int handleRI(int index) {
        int col = index % this.getWidth();
        int row = index / this.getWidth() - 1;
        if (row < this.getFirstScrollLine()) {
            row = this.getFirstScrollLine();
            this.scrollDown(1);
        }
        return this.getAbsoluteIndex(col, row);
    }

    private void handleSPA() {
        this.m_textAttributes.setProtected(true);
    }

    private void handleSS2() {
        this.m_graphicSetState.overrideGL(2);
    }

    private void handleSS3() {
        this.m_graphicSetState.overrideGL(3);
    }

    private void handleTabSet(int index) {
        this.getTabulator().set(index % this.getWidth());
    }

    private int restoreCursor() {
        return this.m_savedState.restore(this);
    }

    private void saveCursor(int aIndex) {
        this.m_savedState.store(this);
    }

    private void sendDeviceAttributes(int arg) throws IOException {
        if (arg != 0) {
            LOG.warn("Unknown DA: {}", (Object)arg);
        } else if (this.isVT52mode()) {
            this.writeResponse(ResponseType.ESC, "/Z");
        } else {
            this.writeResponse(ResponseType.CSI, "?62;1;2;4;6;8;9;15c");
        }
    }

    private void setConformanceLevel(int level, boolean eightBitMode) {
        if (level <= 1) {
            this.softReset();
            this.set8bitMode(false);
        } else if (level >= 2) {
            this.softReset();
            this.set8bitMode(eightBitMode);
        }
    }

    private void setDimensionsInPixels(int width, int height) {
        ITerminalFrontend frontend = this.getFrontend();
        if (frontend != null) {
            frontend.setSize(width, height);
        }
    }

    private void softReset() {
        this.getCursor().setVisible(true);
        this.setInsertMode(false);
        this.setOriginMode(false);
        this.setScrollRegion(this.getFirstScrollLine(), this.getLastScrollLine());
        this.setAutoWrap(true);
        this.setReverseWrapAround(true);
        this.setApplicationCursorKeys(false);
        this.set8bitMode(false);
        this.set132ColumnMode(false);
        this.setEnable132ColumnMode(true);
        this.setReverse(false);
        this.setErasureMode(true);
        this.m_graphicSetState.resetState();
        this.m_textAttributes.resetAll();
        this.saveCursor(this.getFirstAbsoluteIndex());
    }

    private void writeResponse(ResponseType type, String content) throws IOException {
        this.write(this.createResponse(type, content));
    }

    public void setAlarmSounded(boolean alarmSounded) {
        this.alarmSounded = alarmSounded;
    }

    public boolean isAlarmSounded() {
        return this.alarmSounded;
    }

    final class VT220KeyMapper
    implements ITerminal.IKeyMapper {
        VT220KeyMapper() {
        }

        @Override
        public String map(int keyCode, int modifiers) {
            switch (keyCode) {
                case 38: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return VT220Terminal.this.createResponse(ResponseType.ESC, "A");
                    }
                    return VT220Terminal.this.createResponse(VT220Terminal.this.isApplicationCursorKeys() ? ResponseType.SS3 : ResponseType.CSI, "A");
                }
                case 40: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return VT220Terminal.this.createResponse(ResponseType.ESC, "B");
                    }
                    return VT220Terminal.this.createResponse(VT220Terminal.this.isApplicationCursorKeys() ? ResponseType.SS3 : ResponseType.CSI, "B");
                }
                case 39: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return VT220Terminal.this.createResponse(ResponseType.ESC, "C");
                    }
                    return VT220Terminal.this.createResponse(VT220Terminal.this.isApplicationCursorKeys() ? ResponseType.SS3 : ResponseType.CSI, "C");
                }
                case 37: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return VT220Terminal.this.createResponse(ResponseType.ESC, "D");
                    }
                    return VT220Terminal.this.createResponse(VT220Terminal.this.isApplicationCursorKeys() ? ResponseType.SS3 : ResponseType.CSI, "D");
                }
                case 34: {
                    return this.map("\u001b[6~", null);
                }
                case 33: {
                    return this.map("\u001b[5~", null);
                }
                case 36: {
                    return this.map("\u001b[H", "H");
                }
                case 35: {
                    return this.map("\u001b[F", "F");
                }
                case 96: {
                    return this.map("0", "p", "0", "?p");
                }
                case 97: {
                    return this.map("1", "q", "1", "?q");
                }
                case 98: {
                    return this.map("2", "r", "2", "?r");
                }
                case 99: {
                    return this.map("3", "s", "3", "?s");
                }
                case 100: {
                    return this.map("3", "t", "4", "?t");
                }
                case 101: {
                    return this.map("5", "u", "5", "?u");
                }
                case 102: {
                    return this.map("6", "v", "6", "?v");
                }
                case 103: {
                    return this.map("7", "w", "7", "?w");
                }
                case 104: {
                    return this.map("8", "x", "8", "?x");
                }
                case 105: {
                    return this.map("9", "y", "9", "?y");
                }
                case 45: {
                    return this.map("-", "m", "-", "?m");
                }
                case 44: {
                    return this.map(",", "l", ",", "?l");
                }
                case 46: {
                    return this.map(".", "n", ".", "?n");
                }
                case 10: {
                    return this.map("\r", "M", "\r", "?M");
                }
                case 112: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return VT220Terminal.this.createResponse(ResponseType.ESC, "P");
                    }
                    if ((modifiers & 0x200) != 0) {
                        return VT220Terminal.this.createResponse(ResponseType.SS3, "P");
                    }
                    return VT220Terminal.this.createResponse(ResponseType.CSI, "11~");
                }
                case 113: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return VT220Terminal.this.createResponse(ResponseType.ESC, "Q");
                    }
                    if ((modifiers & 0x200) != 0) {
                        return VT220Terminal.this.createResponse(ResponseType.SS3, "Q");
                    }
                    return VT220Terminal.this.createResponse(ResponseType.CSI, "12~");
                }
                case 114: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return VT220Terminal.this.createResponse(ResponseType.ESC, "R");
                    }
                    if ((modifiers & 0x200) != 0) {
                        return VT220Terminal.this.createResponse(ResponseType.SS3, "R");
                    }
                    return VT220Terminal.this.createResponse(ResponseType.CSI, "13~");
                }
                case 115: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return VT220Terminal.this.createResponse(ResponseType.ESC, "S");
                    }
                    if ((modifiers & 0x200) != 0) {
                        return VT220Terminal.this.createResponse(ResponseType.SS3, "S");
                    }
                    return VT220Terminal.this.createResponse(ResponseType.CSI, "14~");
                }
                case 116: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return null;
                    }
                    return VT220Terminal.this.createResponse(ResponseType.CSI, "15~");
                }
                case 117: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return null;
                    }
                    return VT220Terminal.this.createResponse(ResponseType.CSI, "17~");
                }
                case 118: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return null;
                    }
                    return VT220Terminal.this.createResponse(ResponseType.CSI, "18~");
                }
                case 119: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return null;
                    }
                    return VT220Terminal.this.createResponse(ResponseType.CSI, "19~");
                }
                case 120: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return null;
                    }
                    return VT220Terminal.this.createResponse(ResponseType.CSI, "20~");
                }
                case 121: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return null;
                    }
                    return VT220Terminal.this.createResponse(ResponseType.CSI, "21~");
                }
                case 122: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return VT220Terminal.this.createResponse(ResponseType.ESC, "");
                    }
                    return VT220Terminal.this.createResponse(ResponseType.CSI, "23~");
                }
                case 123: {
                    if (VT220Terminal.this.isVT52mode()) {
                        return "\b";
                    }
                    return VT220Terminal.this.createResponse(ResponseType.CSI, "24~");
                }
            }
            return null;
        }

        private String map(String vt100normal, String vt100application) {
            return this.map(vt100normal, vt100application, null, null);
        }

        private String map(String vt100normal, String vt100application, String vt52normal, String vt52application) {
            if (VT220Terminal.this.isVT52mode()) {
                return VT220Terminal.this.isApplicationCursorKeys() ? VT220Terminal.this.createResponse(ResponseType.ESC, vt52application) : vt52normal;
            }
            return VT220Terminal.this.isApplicationCursorKeys() ? VT220Terminal.this.createResponse(ResponseType.SS3, vt100application) : vt100normal;
        }
    }

    static class StateHolder {
        private final CharacterSets.CharacterSet[] m_graphicSetDesignations = new CharacterSets.CharacterSet[4];
        private int m_cursorIndex = 0;
        private short m_attrs;
        private boolean m_autoWrap = true;
        private boolean m_originMode = false;
        private int m_glIndex = 0;
        private int m_grIndex = 1;
        private int m_glOverrideIndex = -1;

        public int restore(VT220Terminal terminal) {
            terminal.m_textAttributes.setAttributes(this.m_attrs);
            terminal.setAutoWrap(this.m_autoWrap);
            terminal.setOriginMode(this.m_originMode);
            GraphicSetState gss = terminal.m_graphicSetState;
            for (int i = 0; i < gss.m_graphicSets.length; ++i) {
                gss.m_graphicSets[i].setDesignation(this.m_graphicSetDesignations[i]);
            }
            gss.setGL(this.m_glIndex);
            gss.setGR(this.m_grIndex);
            if (this.m_glOverrideIndex >= 0) {
                gss.overrideGL(this.m_glOverrideIndex);
            }
            return this.m_cursorIndex;
        }

        public void store(VT220Terminal terminal) {
            this.m_cursorIndex = terminal.getAbsoluteCursorIndex();
            this.m_attrs = terminal.m_textAttributes.getAttributes();
            this.m_autoWrap = terminal.isAutoWrapMode();
            this.m_originMode = terminal.isOriginMode();
            GraphicSetState gss = terminal.m_graphicSetState;
            this.m_glIndex = gss.m_gl.getIndex();
            this.m_grIndex = gss.m_gr.getIndex();
            this.m_glOverrideIndex = -1;
            if (gss.m_glOverride != null) {
                this.m_glOverrideIndex = gss.m_glOverride.getIndex();
            }
            for (int i = 0; i < gss.m_graphicSets.length; ++i) {
                this.m_graphicSetDesignations[i] = gss.m_graphicSets[i].getDesignation();
            }
        }
    }

    static enum ResponseType {
        ESC,
        CSI,
        OSC,
        SS3;

    }

    static class GraphicSetState {
        private final CharacterSets.GraphicSet[] m_graphicSets = new CharacterSets.GraphicSet[4];
        private CharacterSets.GraphicSet m_gl;
        private CharacterSets.GraphicSet m_gr;
        private CharacterSets.GraphicSet m_glOverride;

        public GraphicSetState() {
            for (int i = 0; i < this.m_graphicSets.length; ++i) {
                this.m_graphicSets[i] = new CharacterSets.GraphicSet(i);
            }
            this.resetState();
        }

        public void designateGraphicSet(CharacterSets.GraphicSet graphicSet, char designator) {
            graphicSet.setDesignation(CharacterSets.CharacterSet.valueOf(designator));
        }

        public CharacterSets.GraphicSet getGL() {
            CharacterSets.GraphicSet result = this.m_gl;
            if (this.m_glOverride != null) {
                result = this.m_glOverride;
                this.m_glOverride = null;
            }
            return result;
        }

        public CharacterSets.GraphicSet getGR() {
            return this.m_gr;
        }

        public CharacterSets.GraphicSet getGraphicSet(int index) {
            return this.m_graphicSets[index % 4];
        }

        public char map(char ch) {
            return CharacterSets.getChar(ch, this.getGL(), this.getGR());
        }

        public void overrideGL(int index) {
            this.m_glOverride = this.getGraphicSet(index);
        }

        public void resetState() {
            for (int i = 0; i < this.m_graphicSets.length; ++i) {
                this.m_graphicSets[i].setDesignation(CharacterSets.CharacterSet.valueOf(i == 1 ? (char)'0' : 'B'));
            }
            this.m_gl = this.m_graphicSets[0];
            this.m_gr = this.m_graphicSets[1];
            this.m_glOverride = null;
        }

        public void setGL(int index) {
            this.m_gl = this.getGraphicSet(index);
        }

        public void setGR(int index) {
            this.m_gr = this.getGraphicSet(index);
        }
    }
}

