/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.jvt220.terminal.vt220;

import java.awt.Toolkit;
import java.util.concurrent.atomic.AtomicBoolean;
import nl.lxtreme.jvt220.terminal.vt220.AbstractTerminal;
import nl.lxtreme.jvt220.terminal.vt220.CharacterSets;

public class PlainTerminal
extends AbstractTerminal {
    private final AtomicBoolean m_rawMode = new AtomicBoolean();

    public PlainTerminal(int aColumns, int aLines) {
        super(aColumns, aLines);
    }

    public boolean isRawMode() {
        return this.m_rawMode.get();
    }

    public void setRawMode(boolean aRawMode) {
        boolean old;
        while (!this.m_rawMode.compareAndSet(old = this.m_rawMode.get(), aRawMode)) {
        }
    }

    @Override
    protected int doReadInput(CharSequence aChars) {
        if (aChars == null) {
            throw new IllegalArgumentException("Chars cannot be null!");
        }
        int idx = this.getAbsoluteCursorIndex();
        block6: for (int i = 0; i < aChars.length(); ++i) {
            char c = aChars.charAt(i);
            switch (c) {
                case '\b': {
                    --idx;
                    idx = this.removeChar(idx, false);
                    continue block6;
                }
                case '\u0007': {
                    Toolkit.getDefaultToolkit().beep();
                    continue block6;
                }
                case '\n': {
                    idx += this.getWidth();
                    continue block6;
                }
                case '\r': {
                    idx -= idx % this.getWidth();
                    continue block6;
                }
                default: {
                    if (!this.isRawMode() && c < CharacterSets.ASCII_NAMES.length) {
                        String name = CharacterSets.ASCII_NAMES[c];
                        for (int j = 0; j < name.length(); ++j) {
                            idx = this.writeChar(idx, name.charAt(j));
                        }
                        continue block6;
                    }
                    idx = this.writeChar(idx, c);
                }
            }
        }
        this.updateCursorByAbsoluteIndex(idx);
        return aChars.length();
    }
}

