/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.jvt220.terminal.vt220;

public final class CharacterSets {
    private static final int C0_START = 0;
    private static final int C0_END = 31;
    private static final int C1_START = 128;
    private static final int C1_END = 159;
    private static final int GL_START = 32;
    private static final int GL_END = 127;
    private static final int GR_START = 160;
    private static final int GR_END = 255;
    public static final String[] ASCII_NAMES = new String[]{"<nul>", "<soh>", "<stx>", "<etx>", "<eot>", "<enq>", "<ack>", "<bell>", "\b", "\t", "\n", "<vt>", "<ff>", "\r", "<so>", "<si>", "<dle>", "<dc1>", "<dc2>", "<dc3>", "<dc4>", "<nak>", "<syn>", "<etb>", "<can>", "<em>", "<sub>", "<esc>", "<fs>", "<gs>", "<rs>", "<us>", " ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\\", "]", "^", "_", "`", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "{", "|", "}", "~", "<del>"};
    private static Object[][] C0_CHARS = new Object[][]{{0, "nul"}, {0, "soh"}, {0, "stx"}, {0, "etx"}, {0, "eot"}, {0, "enq"}, {0, "ack"}, {0, "bel"}, {Character.valueOf('\b'), "bs"}, {Character.valueOf('\t'), "ht"}, {Character.valueOf('\n'), "lf"}, {0, "vt"}, {0, "ff"}, {Character.valueOf('\r'), "cr"}, {0, "so"}, {0, "si"}, {0, "dle"}, {0, "dc1"}, {0, "dc2"}, {0, "dc3"}, {0, "dc4"}, {0, "nak"}, {0, "syn"}, {0, "etb"}, {0, "can"}, {0, "em"}, {0, "sub"}, {0, "esq"}, {0, "fs"}, {0, "gs"}, {0, "rs"}, {0, "us"}};
    private static Object[][] C1_CHARS = new Object[][]{{0, null}, {0, null}, {0, null}, {0, null}, {0, "ind"}, {0, "nel"}, {0, "ssa"}, {0, "esa"}, {0, "hts"}, {0, "htj"}, {0, "vts"}, {0, "pld"}, {0, "plu"}, {0, "ri"}, {0, "ss2"}, {0, "ss3"}, {0, "dcs"}, {0, "pu1"}, {0, "pu2"}, {0, "sts"}, {0, "cch"}, {0, "mw"}, {0, "spa"}, {0, "epa"}, {0, null}, {0, null}, {0, null}, {0, "csi"}, {0, "st"}, {0, "osc"}, {0, "pm"}, {0, "apc"}};
    private static Object[][] DEC_SPECIAL_CHARS = new Object[][]{{Character.valueOf('\u25c6'), null}, {Character.valueOf('\u2592'), null}, {Character.valueOf('\u2409'), null}, {Character.valueOf('\u240c'), null}, {Character.valueOf('\u240d'), null}, {Character.valueOf('\u240a'), null}, {Character.valueOf('\u00b0'), null}, {Character.valueOf('\u00b1'), null}, {Character.valueOf('\u2424'), null}, {Character.valueOf('\u240b'), null}, {Character.valueOf('\u2518'), null}, {Character.valueOf('\u2510'), null}, {Character.valueOf('\u250c'), null}, {Character.valueOf('\u2514'), null}, {Character.valueOf('\u253c'), null}, {Character.valueOf('\u23ba'), null}, {Character.valueOf('\u23bb'), null}, {Character.valueOf('\u2500'), null}, {Character.valueOf('\u23bc'), null}, {Character.valueOf('\u23bd'), null}, {Character.valueOf('\u251c'), null}, {Character.valueOf('\u2524'), null}, {Character.valueOf('\u2534'), null}, {Character.valueOf('\u252c'), null}, {Character.valueOf('\u2502'), null}, {Character.valueOf('\u2264'), null}, {Character.valueOf('\u2265'), null}, {Character.valueOf('\u03c0'), null}, {Character.valueOf('\u2260'), null}, {Character.valueOf('\u00a3'), null}, {Character.valueOf('\u00b7'), null}, {Character.valueOf(' '), null}};

    private CharacterSets() {
    }

    public static char getChar(char original, GraphicSet gl, GraphicSet gr) {
        Object[] mapping = CharacterSets.getMapping(original, gl, gr);
        int ch = (Integer)mapping[0];
        if (ch > 0) {
            return (char)ch;
        }
        return ' ';
    }

    public static String getCharName(char original, GraphicSet gl, GraphicSet gr) {
        Object[] mapping = CharacterSets.getMapping(original, gl, gr);
        String name = (String)mapping[1];
        if (name == null) {
            name = String.format("<%d>", original);
        }
        return name;
    }

    private static Object[] getMapping(char original, GraphicSet gl, GraphicSet gr) {
        int mappedChar = original;
        if (original >= 0 && original <= 31) {
            int idx = original - '\u0000';
            return C0_CHARS[idx];
        }
        if (original >= 128 && original <= 159) {
            int idx = original - 128;
            return C1_CHARS[idx];
        }
        if (original >= 32 && original <= 127) {
            int idx = original - 32;
            mappedChar = gl.map((char)original, idx);
        } else if (original >= 160 && original <= 255) {
            int idx = original - 160;
            mappedChar = gr.map((char)original, idx);
        }
        return new Object[]{mappedChar, null};
    }

    static class GraphicSet {
        private final int m_index;
        private CharacterSet m_designation;

        public GraphicSet(int index) {
            if (index < 0 || index > 3) {
                throw new IllegalArgumentException("Invalid index!");
            }
            this.m_index = index;
            this.m_designation = CharacterSet.valueOf(index == 1 ? (char)'0' : 'B');
        }

        public CharacterSet getDesignation() {
            return this.m_designation;
        }

        public int getIndex() {
            return this.m_index;
        }

        public int map(char original, int index) {
            int result = this.m_designation.map(index);
            if (result < 0) {
                result = original;
            }
            return result;
        }

        public void setDesignation(CharacterSet designation) {
            if (designation == null) {
                throw new IllegalArgumentException("Designation cannot be null!");
            }
            this.m_designation = designation;
        }
    }

    static enum CharacterSet {
        ASCII(new int[]{66}){

            @Override
            public int map(int index) {
                return -1;
            }
        }
        ,
        BRITISH(new int[]{65}){

            @Override
            public int map(int index) {
                if (index == 3) {
                    return 163;
                }
                return -1;
            }
        }
        ,
        DANISH(new int[]{69, 54}){

            @Override
            public int map(int index) {
                switch (index) {
                    case 32: {
                        return 196;
                    }
                    case 59: {
                        return 198;
                    }
                    case 60: {
                        return 216;
                    }
                    case 61: {
                        return 197;
                    }
                    case 62: {
                        return 220;
                    }
                    case 64: {
                        return 228;
                    }
                    case 91: {
                        return 230;
                    }
                    case 92: {
                        return 248;
                    }
                    case 93: {
                        return 229;
                    }
                    case 94: {
                        return 252;
                    }
                }
                return -1;
            }
        }
        ,
        DEC_SPECIAL_GRAPHICS(new int[]{48, 50}){

            @Override
            public int map(int index) {
                if (index >= 64 && index < 96) {
                    return ((Character)DEC_SPECIAL_CHARS[index - 64][0]).charValue();
                }
                return -1;
            }
        }
        ,
        DEC_SUPPLEMENTAL(new int[]{85, 60}){

            @Override
            public int map(int index) {
                if (index >= 0 && index < 64) {
                    return index + 160;
                }
                return -1;
            }
        }
        ,
        DUTCH(new int[]{52}){

            @Override
            public int map(int index) {
                switch (index) {
                    case 3: {
                        return 163;
                    }
                    case 32: {
                        return 190;
                    }
                    case 59: {
                        return 307;
                    }
                    case 60: {
                        return 189;
                    }
                    case 61: {
                        return 124;
                    }
                    case 91: {
                        return 168;
                    }
                    case 92: {
                        return 402;
                    }
                    case 93: {
                        return 188;
                    }
                    case 94: {
                        return 180;
                    }
                }
                return -1;
            }
        }
        ,
        FINNISH(new int[]{67, 53}){

            @Override
            public int map(int index) {
                switch (index) {
                    case 59: {
                        return 196;
                    }
                    case 60: {
                        return 212;
                    }
                    case 61: {
                        return 197;
                    }
                    case 62: {
                        return 220;
                    }
                    case 64: {
                        return 233;
                    }
                    case 91: {
                        return 228;
                    }
                    case 92: {
                        return 246;
                    }
                    case 93: {
                        return 229;
                    }
                    case 94: {
                        return 252;
                    }
                }
                return -1;
            }
        }
        ,
        FRENCH(new int[]{82}){

            @Override
            public int map(int index) {
                switch (index) {
                    case 3: {
                        return 163;
                    }
                    case 32: {
                        return 224;
                    }
                    case 59: {
                        return 176;
                    }
                    case 60: {
                        return 231;
                    }
                    case 61: {
                        return 166;
                    }
                    case 91: {
                        return 233;
                    }
                    case 92: {
                        return 249;
                    }
                    case 93: {
                        return 232;
                    }
                    case 94: {
                        return 168;
                    }
                }
                return -1;
            }
        }
        ,
        FRENCH_CANADIAN(new int[]{81}){

            @Override
            public int map(int index) {
                switch (index) {
                    case 32: {
                        return 224;
                    }
                    case 59: {
                        return 226;
                    }
                    case 60: {
                        return 231;
                    }
                    case 61: {
                        return 234;
                    }
                    case 62: {
                        return 238;
                    }
                    case 91: {
                        return 233;
                    }
                    case 92: {
                        return 249;
                    }
                    case 93: {
                        return 232;
                    }
                    case 94: {
                        return 251;
                    }
                }
                return -1;
            }
        }
        ,
        GERMAN(new int[]{75}){

            @Override
            public int map(int index) {
                switch (index) {
                    case 32: {
                        return 167;
                    }
                    case 59: {
                        return 196;
                    }
                    case 60: {
                        return 214;
                    }
                    case 61: {
                        return 220;
                    }
                    case 91: {
                        return 228;
                    }
                    case 92: {
                        return 246;
                    }
                    case 93: {
                        return 252;
                    }
                    case 94: {
                        return 223;
                    }
                }
                return -1;
            }
        }
        ,
        ITALIAN(new int[]{89}){

            @Override
            public int map(int index) {
                switch (index) {
                    case 3: {
                        return 163;
                    }
                    case 32: {
                        return 167;
                    }
                    case 59: {
                        return 186;
                    }
                    case 60: {
                        return 231;
                    }
                    case 61: {
                        return 233;
                    }
                    case 91: {
                        return 224;
                    }
                    case 92: {
                        return 242;
                    }
                    case 93: {
                        return 232;
                    }
                    case 94: {
                        return 236;
                    }
                }
                return -1;
            }
        }
        ,
        SPANISH(new int[]{90}){

            @Override
            public int map(int index) {
                switch (index) {
                    case 3: {
                        return 163;
                    }
                    case 32: {
                        return 167;
                    }
                    case 59: {
                        return 161;
                    }
                    case 60: {
                        return 209;
                    }
                    case 61: {
                        return 191;
                    }
                    case 91: {
                        return 176;
                    }
                    case 92: {
                        return 241;
                    }
                    case 93: {
                        return 231;
                    }
                }
                return -1;
            }
        }
        ,
        SWEDISH(new int[]{72, 55}){

            @Override
            public int map(int index) {
                switch (index) {
                    case 32: {
                        return 201;
                    }
                    case 59: {
                        return 196;
                    }
                    case 60: {
                        return 214;
                    }
                    case 61: {
                        return 197;
                    }
                    case 62: {
                        return 220;
                    }
                    case 64: {
                        return 233;
                    }
                    case 91: {
                        return 228;
                    }
                    case 92: {
                        return 246;
                    }
                    case 93: {
                        return 229;
                    }
                    case 94: {
                        return 252;
                    }
                }
                return -1;
            }
        }
        ,
        SWISS(new int[]{61}){

            @Override
            public int map(int index) {
                switch (index) {
                    case 3: {
                        return 249;
                    }
                    case 32: {
                        return 224;
                    }
                    case 59: {
                        return 233;
                    }
                    case 60: {
                        return 231;
                    }
                    case 61: {
                        return 234;
                    }
                    case 62: {
                        return 238;
                    }
                    case 63: {
                        return 232;
                    }
                    case 64: {
                        return 244;
                    }
                    case 91: {
                        return 228;
                    }
                    case 92: {
                        return 246;
                    }
                    case 93: {
                        return 252;
                    }
                    case 94: {
                        return 251;
                    }
                }
                return -1;
            }
        };

        private final int[] m_designations;

        private CharacterSet(int ... designations) {
            this.m_designations = designations;
        }

        public static CharacterSet valueOf(char designation) {
            for (CharacterSet csn : CharacterSet.values()) {
                if (!csn.isDesignation(designation)) continue;
                return csn;
            }
            return ASCII;
        }

        public abstract int map(int var1);

        private boolean isDesignation(char designation) {
            for (int i = 0; i < this.m_designations.length; ++i) {
                if (this.m_designations[i] != designation) continue;
                return true;
            }
            return false;
        }
    }
}

