/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.jvt220.terminal.swing;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicBoolean;
import nl.lxtreme.jvt220.terminal.ITerminalColorScheme;

public final class XtermColorScheme
implements ITerminalColorScheme {
    private static final Color PLAIN_TEXT_COLOR = new Color(230, 230, 230);
    private static final Color BACKGROUND_COLOR = new Color(30, 33, 38);
    private static final Color[] XTERM_COLORS = new Color[]{BACKGROUND_COLOR, new Color(205, 0, 0), new Color(0, 205, 0), new Color(205, 205, 0), new Color(0, 0, 238), new Color(205, 0, 205), new Color(0, 205, 205), new Color(229, 229, 229)};
    private final AtomicBoolean inverted = new AtomicBoolean(false);

    @Override
    public Color getBackgroundColor() {
        return this.isInverted() ? PLAIN_TEXT_COLOR : BACKGROUND_COLOR;
    }

    @Override
    public Color getColorByIndex(int aIndex) {
        return XTERM_COLORS[aIndex % XTERM_COLORS.length];
    }

    @Override
    public Color getTextColor() {
        return this.isInverted() ? BACKGROUND_COLOR : PLAIN_TEXT_COLOR;
    }

    public boolean isInverted() {
        return this.inverted.get();
    }

    @Override
    public void setInverted(boolean aInverted) {
        this.inverted.set(aInverted);
    }
}

