/*
 * Decompiled with CFR 0.152.
 */
package nl.lxtreme.jvt220.terminal;

import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.util.Optional;
import javax.net.SocketFactory;
import nl.lxtreme.jvt220.shaded.telnetInvalidTelnetOptionException;
import nl.lxtreme.jvt220.shaded.telnetVT420Client;
import nl.lxtreme.jvt220.terminal.ConnectionException;
import nl.lxtreme.jvt220.terminal.ConnectionListener;
import nl.lxtreme.jvt220.terminal.ConnectionListenerBroadcast;
import nl.lxtreme.jvt220.terminal.ICursor;
import nl.lxtreme.jvt220.terminal.ScreenChangeListener;
import nl.lxtreme.jvt220.terminal.SwingFrontendProxy;
import nl.lxtreme.jvt220.terminal.vt220.VT220Terminal;

public class TerminalClient {
    private final telnetVT420Client client;
    private final VT220Terminal terminal;
    private final SwingFrontendProxy swingFrontendProxy;
    private final ConnectionListenerBroadcast connectionListenerBroadcast;

    public TerminalClient(Dimension screenSize, String terminalType) {
        this.terminal = new VT220Terminal(screenSize.width, screenSize.height);
        this.client = new telnetVT420Client(terminalType);
        this.connectionListenerBroadcast = new ConnectionListenerBroadcast();
        this.swingFrontendProxy = new SwingFrontendProxy();
        this.swingFrontendProxy.setTerminal(this.terminal);
        this.swingFrontendProxy.setConnectionListener(this.connectionListenerBroadcast);
        this.terminal.setFrontend(this.swingFrontendProxy);
    }

    public void connect(String address, int port, int timeout) throws ConnectionException {
        try {
            this.client.setupOptionHandlers();
            this.client.setConnectTimeout(timeout);
            this.client.connect(address, port);
            this.connectionListenerBroadcast.onConnection();
            this.terminal.getFrontend().connect(this.client.getInputStream(), this.client.getOutputStream());
        }
        catch (IOException | telnetInvalidTelnetOptionException e) {
            throw new ConnectionException(e, String.format("%s:%s", address, port));
        }
    }

    public void disconnect() throws IOException {
        this.client.disconnect();
        this.swingFrontendProxy.disconnect();
    }

    public void sendTextByCurrentCursorPosition(String text) throws IOException {
        this.terminal.write(text);
    }

    public String getScreen() {
        return this.terminal.toString();
    }

    public void addScreenChangeListener(ScreenChangeListener listener) {
        this.swingFrontendProxy.addScreenChangeListener(listener);
    }

    public void removeScreenChangeListener(ScreenChangeListener listener) {
        this.swingFrontendProxy.removeScreenChangeListener(listener);
    }

    public Optional<Point> getCursorPosition() {
        ICursor cursor = this.terminal.getCursor();
        return cursor.isVisible() ? Optional.of(new Point(cursor.getX(), cursor.getY())) : Optional.empty();
    }

    public Dimension getScreenSize() {
        return new Dimension(this.terminal.getWidth(), this.terminal.getHeight());
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListenerBroadcast.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListenerBroadcast.remove(listener);
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.client.setSocketFactory(socketFactory);
    }

    public boolean isAlarmOn() {
        return this.terminal.isAlarmSounded();
    }

    public boolean resetAlarm() {
        boolean ret = this.terminal.isAlarmSounded();
        this.terminal.setAlarmSounded(false);
        return ret;
    }
}

