/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.structuredfields;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.structuredfields.StructuredField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Outbound3270DS
extends StructuredField {
    private static final Logger LOG = LoggerFactory.getLogger(Outbound3270DS.class);
    private final byte partitionID;
    private final Command command;

    public Outbound3270DS(byte[] buffer, int offset, int length, Charset charset) {
        super(buffer, offset, length, charset);
        assert (this.data[0] == 64);
        this.partitionID = this.data[1];
        assert ((this.partitionID & 0xFFFFFF80) == 0);
        this.command = Command.getCommand(buffer, offset + 2, length - 2, charset);
    }

    @Override
    public void process(Screen screen) {
        this.command.process(screen);
        if (this.command.getReply().isPresent()) {
            LOG.debug("Non-null reply: {}, {}", (Object)this.command, (Object)this.command.getReply().get());
        }
    }

    @Override
    public String toString() {
        return String.format("Struct Field : %02X Outbound3270DS\n", this.type) + String.format("   partition : %02X%n", this.partitionID) + this.command;
    }
}

