/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.streams;

import com.bytezone.dm3270.streams.BufferListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetSocket
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TelnetSocket.class);
    private static final boolean GENUINE = true;
    private final String name;
    private final Source source;
    private Socket socket;
    private InputStream inputStream;
    private final byte[] buffer = new byte[4096];
    private final BufferListener telnetListener;
    private volatile boolean running;

    public TelnetSocket(Source source, Socket socket, BufferListener listener) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Source cannot be null");
        }
        if (socket == null) {
            throw new IllegalArgumentException("Socket cannot be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.name = source == Source.CLIENT ? "Client" : "Server";
        this.source = source;
        this.socket = socket;
        this.telnetListener = listener;
        this.inputStream = socket.getInputStream();
    }

    @Override
    public void run() {
        this.running = true;
        while (this.running) {
            if (Thread.interrupted()) {
                LOG.debug("TelnetSocket interrupted");
                break;
            }
            try {
                int bytesRead = this.inputStream.read(this.buffer);
                if (bytesRead == -1) {
                    LOG.debug("{} has no data on input stream", (Object)this.name);
                    this.close();
                    return;
                }
                byte[] message = new byte[bytesRead];
                System.arraycopy(this.buffer, 0, message, 0, message.length);
                this.telnetListener.listen(this.source, message, LocalDateTime.now(), true);
            }
            catch (IOException e) {
                if (this.running) {
                    LOG.error("{} closing due to IOException", (Object)this.name, (Object)e);
                } else {
                    LOG.debug("{} quitting", (Object)this.name, (Object)e);
                }
                this.close();
                return;
            }
        }
        LOG.debug("{} closing - bye everyone", (Object)this.name);
        this.close();
    }

    private void close() {
        this.running = false;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.socket = null;
        this.inputStream = null;
    }

    public String toString() {
        return String.format("TelnetSocket: Source=%s, name=%s", new Object[]{this.source, this.name});
    }

    public static enum Source {
        CLIENT,
        SERVER;

    }
}

