/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.replyfield;

import com.bytezone.dm3270.replyfield.QueryReplyField;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class Summary
extends QueryReplyField {
    public Summary(byte[] buffer) {
        super(buffer);
        assert (this.data[1] == -128);
    }

    public Summary(List<QueryReplyField> replyFields) {
        super((byte)-128);
        this.replies = replyFields;
        ByteBuffer buffer = this.createReplyBuffer(replyFields.size() + 1);
        buffer.put((byte)-128);
        replyFields.forEach(r -> buffer.put(r.replyType.type));
    }

    protected boolean isListed(byte type) {
        for (int i = 2; i < this.data.length; ++i) {
            if (this.data[i] != type) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder(super.toString());
        for (int i = 2; i < this.data.length; ++i) {
            text.append(String.format("%n  %-30s  %s", QueryReplyField.ReplyType.fromId(this.data[i]), this.isProvided(this.data[i]) ? "" : "** missing **"));
        }
        ArrayList<QueryReplyField> missingFields = new ArrayList<QueryReplyField>(4);
        for (QueryReplyField reply : this.replies) {
            if (this.isListed(reply.replyType.type)) continue;
            missingFields.add(reply);
        }
        if (missingFields.size() > 0) {
            text.append("\n\nNot listed in Summary:");
            for (QueryReplyField qrf : missingFields) {
                text.append(String.format("%n  %s", qrf.replyType));
            }
        }
        return text.toString();
    }
}

