/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.replyfield;

import com.bytezone.dm3270.buffers.Buffer;
import com.bytezone.dm3270.replyfield.QueryReplyField;
import java.util.ArrayList;
import java.util.List;

public class CharacterSets
extends QueryReplyField {
    private static final int GRAPHIC_ESCAPE_SUPPORT_FLAG = 128;
    private static final int CGCSGID_PRESENT_FLAG = 2;
    private static final int DEFAULT_CHARACTER_SLOT_WIDTH = 7;
    private static final int DEFAULT_CHARACTER_SLOT_HEIGHT = 12;
    private static final int[] FORM_TYPES = new int[]{0, 0, 0, 0};
    private static final int DESCRIPTOR_LENGTH = 7;
    private static final byte[][] CHARSETS = new byte[][]{{0, 0, 0, 2, -71, 4, 23}, {1, 0, -15, 3, -61, 1, 54}};
    private byte flags1;
    private byte flags2;
    private int defaultSlotWidth;
    private int defaultSlotHeight;
    private int loadTypes;
    private int descriptorLength;
    private final List<Descriptor> descriptors = new ArrayList<Descriptor>();

    public CharacterSets() {
        super((byte)-123);
        int ptr = this.createReply(4 + FORM_TYPES.length + 1 + CHARSETS.length * 7);
        this.reply[ptr++] = -126;
        this.reply[ptr++] = 0;
        this.reply[ptr++] = 7;
        this.reply[ptr++] = 12;
        for (int formType : FORM_TYPES) {
            this.reply[ptr++] = (byte)formType;
        }
        this.reply[ptr++] = 7;
        for (byte[] charset : CHARSETS) {
            System.arraycopy(charset, 0, this.reply, ptr, 7);
            ptr += 7;
        }
        this.checkDataLength(ptr);
    }

    public CharacterSets(byte[] buffer) {
        super(buffer);
        assert (this.data[1] == -123);
        this.flags1 = this.data[2];
        this.flags2 = this.data[3];
        this.defaultSlotWidth = this.data[4] & 0xFF;
        this.defaultSlotHeight = this.data[5] & 0xFF;
        for (int i = 0; i < 4; ++i) {
            this.loadTypes = this.loadTypes << 8 | this.data[i + 6] & 0xFF;
        }
        this.descriptorLength = this.data[10] & 0xFF;
        for (int ptr = 11; ptr < this.data.length; ptr += this.descriptorLength) {
            this.descriptors.add(new Descriptor(this.data, ptr, this.descriptorLength));
        }
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder(super.toString());
        text.append(String.format("%n  flags1     : %02X", this.flags1));
        text.append(String.format("%n  flags2     : %02X", this.flags2));
        text.append(String.format("%n  SDW        : %d", this.defaultSlotWidth));
        text.append(String.format("%n  SDH        : %d", this.defaultSlotHeight));
        text.append(String.format("%n  load types : %08X", this.loadTypes));
        text.append(String.format("%n  desc len   : %d", this.descriptorLength));
        for (Descriptor descriptor : this.descriptors) {
            text.append(String.format("%n  Descriptor : %n%s", descriptor));
        }
        return text.toString();
    }

    public static class Descriptor {
        private final int set;
        private final byte flags;
        private final int localCharsetID;
        private final int slotWidth;
        private final int slotHeight;
        private final int startSubsection;
        private final int endSubsection;
        private int cgcsID;

        private Descriptor(byte[] buffer, int offset, int length) {
            this.set = buffer[offset] & 0xFF;
            this.flags = buffer[offset + 1];
            this.localCharsetID = buffer[offset + 2] & 0xFF;
            this.slotWidth = buffer[offset + 3] & 0xFF;
            this.slotHeight = buffer[offset + 4] & 0xFF;
            this.startSubsection = buffer[offset + 5] & 0xFF;
            this.endSubsection = buffer[offset + 6] & 0xFF;
            if (length > 7) {
                this.cgcsID = Buffer.unsignedLong(buffer, 7);
            }
        }

        public String toString() {
            return String.format("    Set : %d", this.set) + String.format("%n    flags    : %02X", this.flags) + String.format("%n    charset  : %02X", this.localCharsetID) + String.format("%n    slot w   : %02X", this.slotWidth) + String.format("%n    slot h   : %02X", this.slotHeight) + String.format("%n    start    : %02X", this.startSubsection) + String.format("%n    end      : %02X", this.endSubsection) + String.format("%n    graphics : %d", this.cgcsID);
        }
    }
}

