/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.commands;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.buffers.Buffer;
import com.bytezone.dm3270.buffers.MultiBuffer;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.structuredfields.DefaultStructuredField;
import com.bytezone.dm3270.structuredfields.EraseResetSF;
import com.bytezone.dm3270.structuredfields.Outbound3270DS;
import com.bytezone.dm3270.structuredfields.ReadPartitionSF;
import com.bytezone.dm3270.structuredfields.SetReplyModeSF;
import com.bytezone.dm3270.structuredfields.StructuredField;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteStructuredFieldCommand
extends Command {
    private static final Logger LOG = LoggerFactory.getLogger(WriteStructuredFieldCommand.class);
    private static final String LINE = "\n-------------------------------------------------------------------------";
    private final List<StructuredField> structuredFields = new ArrayList<StructuredField>();
    private final List<Buffer> replies = new ArrayList<Buffer>();
    private final Charset charset;

    public WriteStructuredFieldCommand(byte[] buffer, int offset, int length, Charset charset) {
        super(buffer, offset, length);
        int size;
        this.charset = charset;
        assert (buffer[offset] == 17 || buffer[offset] == -13);
        int max = offset + length;
        block8: for (int ptr = offset + 1; ptr < max; ptr += size) {
            size = Buffer.unsignedShort(buffer, ptr) - 2;
            switch (buffer[ptr += 2]) {
                case 64: {
                    this.structuredFields.add(new Outbound3270DS(buffer, ptr, size, charset));
                    continue block8;
                }
                case 1: {
                    this.structuredFields.add(new ReadPartitionSF(buffer, ptr, size, charset));
                    continue block8;
                }
                case 0: {
                    LOG.warn("SF_RESET_PARTITION (00) not written yet");
                    this.structuredFields.add(new DefaultStructuredField(buffer, ptr, size, charset));
                    continue block8;
                }
                case 9: {
                    this.structuredFields.add(new SetReplyModeSF(buffer, ptr, size, charset));
                    continue block8;
                }
                case 14: {
                    LOG.warn("SF_ACTIVATE_PARTITION (0E) not written yet");
                    this.structuredFields.add(new DefaultStructuredField(buffer, ptr, size, charset));
                    continue block8;
                }
                case 3: {
                    this.structuredFields.add(new EraseResetSF(buffer, ptr, size, charset));
                    continue block8;
                }
                default: {
                    this.structuredFields.add(new DefaultStructuredField(buffer, ptr, size, charset));
                }
            }
        }
    }

    @Override
    public void process(Screen screen) {
        this.replies.clear();
        for (StructuredField structuredField : this.structuredFields) {
            structuredField.process(screen);
            Optional<Buffer> reply = structuredField.getReply();
            reply.ifPresent(this.replies::add);
        }
    }

    @Override
    public Optional<Buffer> getReply() {
        if (this.replies.size() == 0) {
            return Optional.empty();
        }
        if (this.replies.size() == 1) {
            return Optional.of(this.replies.get(0));
        }
        MultiBuffer multiBuffer = new MultiBuffer(this.charset);
        for (Buffer reply : this.replies) {
            multiBuffer.addBuffer(reply);
        }
        return Optional.of(multiBuffer);
    }

    @Override
    public String getName() {
        return "Write SF";
    }

    public String toString() {
        StringBuilder text = new StringBuilder(String.format("WSF (%d):", this.structuredFields.size()));
        for (StructuredField sf : this.structuredFields) {
            text.append(LINE);
            text.append("\n");
            text.append(sf);
        }
        if (this.structuredFields.size() > 0) {
            text.append(LINE);
        }
        return text.toString();
    }
}

