/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.commands;

import com.bytezone.dm3270.display.Screen;

public class WriteControlCharacter {
    private final byte value;
    private final boolean resetPartition;
    private final boolean startPrinter;
    private final boolean soundAlarm;
    private final boolean restoreKeyboard;
    private final boolean resetModified;

    public WriteControlCharacter(byte value) {
        this.value = value;
        this.resetPartition = (value & 0x40) > 0;
        this.startPrinter = (value & 8) > 0;
        this.soundAlarm = (value & 4) > 0;
        this.restoreKeyboard = (value & 2) > 0;
        this.resetModified = (value & 1) > 0;
    }

    byte getValue() {
        return this.value;
    }

    boolean isResetModified() {
        return this.resetModified;
    }

    void process(Screen screen) {
        screen.resetInsertMode();
        if (this.soundAlarm) {
            screen.soundAlarm();
        }
        if (this.resetModified) {
            screen.resetModified();
        }
        if (this.restoreKeyboard) {
            screen.restoreKeyboard();
        }
    }

    public String toString() {
        return String.format("reset MDT=%s", this.resetModified ? "yes" : "no ") + String.format(", keyboard=%s", this.restoreKeyboard ? "yes" : "no ") + String.format(", alarm=%s", this.soundAlarm ? "yes" : "no ") + String.format(", printer=%s", this.startPrinter ? "yes" : "no ") + String.format(", partition=%s", this.resetPartition ? "yes" : "no");
    }
}

