/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.commands;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.commands.WriteControlCharacter;
import com.bytezone.dm3270.display.Cursor;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.orders.Order;
import com.bytezone.dm3270.orders.TextOrder;
import java.util.ArrayList;
import java.util.List;

public class WriteCommand
extends Command {
    private final boolean eraseWrite;
    private final boolean alternate;
    private final WriteControlCharacter writeControlCharacter;
    private final List<Order> orders = new ArrayList<Order>();

    public WriteCommand(byte[] buffer, int offset, int length, Charset charset) {
        super(buffer, offset, length);
        Order order;
        assert (buffer[offset] == 1 || buffer[offset] == -15 || buffer[offset] == 5 || buffer[offset] == -11 || buffer[offset] == 13 || buffer[offset] == 126);
        this.eraseWrite = buffer[offset] != -15 && buffer[offset] != 1;
        this.alternate = buffer[offset] == 13 || buffer[offset] == 126;
        this.writeControlCharacter = length > 1 ? new WriteControlCharacter(buffer[offset + 1]) : null;
        Order previousOrder = null;
        int max = offset + length;
        for (int ptr = offset + 2; ptr < max; ptr += order.size()) {
            order = Order.getOrder(buffer, ptr, max, charset);
            if (order.matchesPreviousOrder(previousOrder)) {
                previousOrder.incrementDuplicates();
                continue;
            }
            this.orders.add(order);
            previousOrder = order;
        }
    }

    @Override
    public void process(Screen screen) {
        Cursor cursor = screen.getScreenCursor();
        int cursorLocation = cursor.getLocation();
        boolean screenDrawRequired = false;
        if (this.eraseWrite) {
            Screen.ScreenOption requestedScreenOption = this.alternate ? Screen.ScreenOption.ALTERNATE : Screen.ScreenOption.DEFAULT;
            screen.clearScreen(requestedScreenOption);
            screen.setCurrentScreen(this.alternate ? Screen.ScreenOption.ALTERNATE : Screen.ScreenOption.DEFAULT);
            screen.lockKeyboard("Erase Write");
        } else {
            screen.lockKeyboard("Write");
        }
        if (this.orders.size() > 0) {
            for (Order order : this.orders) {
                order.process(screen);
            }
            cursor.moveTo(cursorLocation);
            screen.buildFields();
            screenDrawRequired = true;
        }
        if (this.writeControlCharacter != null) {
            this.writeControlCharacter.process(screen);
            if (screen.getFieldManager().size() > 0 && !screen.isKeyboardLocked()) {
                screen.checkRecording();
            }
        }
        if (!(screen.isKeyboardLocked() || screen.getFieldManager().size() <= 0 || this.orders.size() <= 0 && this.writeControlCharacter.isResetModified())) {
            this.setReply(null);
        }
        if (screenDrawRequired) {
            screen.draw();
        }
    }

    @Override
    public String getName() {
        return this.eraseWrite ? (this.alternate ? "Erase Write Alternate" : "Erase Write") : "Write";
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(this.getName());
        text.append("\nWCC : ").append(this.writeControlCharacter);
        if (this.orders.size() > 0 && this.orders.get(0) instanceof TextOrder) {
            text.append(String.format("%40s", ""));
        }
        for (Order order : this.orders) {
            String fmt = order.isText() ? "%s" : "%n%-40s";
            text.append(String.format(fmt, order));
        }
        return text.toString();
    }
}

