/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.commands;

import com.bytezone.dm3270.Charset;
import com.bytezone.dm3270.commands.Command;
import com.bytezone.dm3270.display.Cursor;
import com.bytezone.dm3270.display.Field;
import com.bytezone.dm3270.display.FieldManager;
import com.bytezone.dm3270.display.Screen;
import com.bytezone.dm3270.orders.BufferAddress;
import com.bytezone.dm3270.orders.BufferAddressSource;
import com.bytezone.dm3270.orders.Order;
import com.bytezone.dm3270.orders.SetBufferAddressOrder;
import com.bytezone.dm3270.orders.TextOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class AIDCommand
extends Command
implements BufferAddressSource,
Iterable<Order> {
    public static final byte NO_AID_SPECIFIED = 96;
    public static final byte AID_STRUCTURED_FIELD = -120;
    public static final byte AID_PA3 = 107;
    public static final byte AID_PA1 = 108;
    public static final byte AID_CLEAR = 109;
    public static final byte AID_PA2 = 110;
    public static final byte AID_ENTER = 125;
    public static final byte AID_PF1 = -15;
    public static final byte AID_PF2 = -14;
    public static final byte AID_PF3 = -13;
    public static final byte AID_PF4 = -12;
    public static final byte AID_PF5 = -11;
    public static final byte AID_PF6 = -10;
    public static final byte AID_PF7 = -9;
    public static final byte AID_PF8 = -8;
    public static final byte AID_PF9 = -7;
    public static final byte AID_PF10 = 122;
    public static final byte AID_PF11 = 123;
    public static final byte AID_PF12 = 124;
    public static final byte AID_PF13 = -63;
    public static final byte AID_PF14 = -62;
    public static final byte AID_PF15 = -61;
    public static final byte AID_PF16 = -60;
    public static final byte AID_PF17 = -59;
    public static final byte AID_PF18 = -58;
    public static final byte AID_PF19 = -57;
    public static final byte AID_PF20 = -56;
    public static final byte AID_PF21 = -55;
    public static final byte AID_PF22 = 74;
    public static final byte AID_PF23 = 75;
    public static final byte AID_PF24 = 76;
    public static final byte AID_SYSREQ = -16;
    private static final byte AID_READ_PARTITION = 97;
    private static final byte AID_CLEAR_PARTITION = 106;
    private static byte[] keys = new byte[]{0, 96, 125, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 123, 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, 74, 75, 76, 108, 110, 107, 109, 106, 97, -16};
    private static String[] keyNames = new String[]{"Not found", "No AID", "ENTR", "PF1", "PF2", "PF3", "PF4", "PF5", "PF6", "PF7", "PF8", "PF9", "PF10", "PF11", "PF12", "PF13", "PF14", "PF15", "PF16", "PF17", "PF18", "PF19", "PF20", "PF21", "PF22", "PF23", "PF24", "PA1", "PA2", "PA3", "CLR", "CLR Partition", "Read Partition", "System Request"};
    private int key;
    private byte keyCommand;
    private BufferAddress cursorAddress;
    private final List<ModifiedField> modifiedFields = new ArrayList<ModifiedField>();
    private final List<Order> orders = new ArrayList<Order>();
    private final List<Order> textOrders = new ArrayList<Order>();

    public AIDCommand(byte[] buffer, int offset, int length, Charset charset) {
        super(buffer, offset, length);
        Order order;
        this.keyCommand = this.data[0];
        this.key = this.findKey(this.keyCommand);
        if (length <= 1) {
            this.cursorAddress = null;
            return;
        }
        this.cursorAddress = new BufferAddress(this.data[1], this.data[2]);
        Order previousOrder = null;
        ModifiedField currentAIDField = null;
        for (int ptr = 3; ptr < length; ptr += order.size()) {
            order = Order.getOrder(this.data, ptr, length, charset);
            if (previousOrder != null && previousOrder.matchesPreviousOrder(order)) {
                previousOrder.incrementDuplicates();
            } else {
                this.orders.add(order);
                previousOrder = order;
            }
            if (order instanceof SetBufferAddressOrder) {
                currentAIDField = new ModifiedField((SetBufferAddressOrder)order);
                this.modifiedFields.add(currentAIDField);
            } else if (currentAIDField != null) {
                currentAIDField.addOrder(order);
            }
            if (!(order instanceof TextOrder)) continue;
            this.textOrders.add(order);
        }
    }

    private int findKey(byte keyCommand) {
        for (int i = 1; i < keys.length; ++i) {
            if (keys[i] != keyCommand) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void process(Screen screen) {
        if (!this.prettyMoveHandled(screen)) {
            FieldManager fieldManager = screen.getFieldManager();
            for (ModifiedField aidField : this.modifiedFields) {
                Optional<Field> optField = fieldManager.getFieldAt(aidField.getLocation());
                if (!optField.isPresent()) continue;
                Field field = optField.get();
                if (aidField.hasData()) {
                    field.setText(aidField.getBuffer());
                    continue;
                }
                field.erase();
            }
        }
        if (this.cursorAddress != null) {
            screen.getScreenCursor().moveTo(this.cursorAddress.getLocation());
        }
        screen.lockKeyboard(keyNames[this.key]);
    }

    private boolean prettyMoveHandled(Screen screen) {
        int cursorOldLocation;
        Cursor cursor;
        Field currentField;
        if (this.modifiedFields.size() == 1 && (currentField = (cursor = screen.getScreenCursor()).getCurrentField()) != null && (cursorOldLocation = cursor.getLocation()) != currentField.getFirstLocation() && currentField.contains(cursorOldLocation)) {
            int cursorDistance = this.cursorAddress.getLocation() - cursorOldLocation;
            byte[] buffer = this.modifiedFields.get(0).getBuffer();
            if (buffer.length == cursorDistance) {
                for (byte b : buffer) {
                    cursor.typeChar(b);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public BufferAddress getBufferAddress() {
        return this.cursorAddress;
    }

    @Override
    public String getName() {
        return "AID : " + keyNames[this.key];
    }

    public String toString() {
        StringBuilder text;
        block5: {
            block4: {
                text = new StringBuilder();
                text.append(String.format("AID     : %-12s : %02X%n", keyNames[this.key], this.keyCommand));
                if (this.cursorAddress != null) {
                    text.append(String.format("Cursor  : %s%n", this.cursorAddress));
                }
                if (this.modifiedFields.size() <= 0) break block4;
                text.append(String.format("%nModified fields  : %d", this.modifiedFields.size()));
                for (ModifiedField aidField : this.modifiedFields) {
                    text.append("\nField   : ");
                    text.append(aidField);
                }
                break block5;
            }
            if (this.orders.size() <= 0) break block5;
            text.append(String.format("%nOrders  : %d%n", this.orders.size() - this.textOrders.size()));
            text.append(String.format("Text    : %d%n", this.textOrders.size()));
            if (this.orders.size() > 0 && this.orders.get(0) instanceof TextOrder) {
                text.append(String.format("%40s", ""));
            }
            for (Order order : this.orders) {
                String fmt = order instanceof TextOrder ? "%s" : "%n%-40s";
                text.append(String.format(fmt, order));
            }
        }
        return text.toString();
    }

    @Override
    public Iterator<Order> iterator() {
        return this.orders.iterator();
    }

    private class ModifiedField {
        private SetBufferAddressOrder sbaOrder;
        private List<Order> orders = new ArrayList<Order>();

        private ModifiedField(SetBufferAddressOrder sbaOrder) {
            this.sbaOrder = sbaOrder;
        }

        private void addOrder(Order order) {
            this.orders.add(order);
        }

        private int getLocation() {
            return this.sbaOrder.getBufferAddress().getLocation();
        }

        private boolean hasData() {
            return this.getBuffer().length > 0;
        }

        public byte[] getBuffer() {
            for (Order order : this.orders) {
                if (!(order instanceof TextOrder)) continue;
                return order.getBuffer();
            }
            return new byte[0];
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("%-40s", this.sbaOrder));
            for (Order order : this.orders) {
                if (!(order instanceof TextOrder)) {
                    text.append(String.format("\n        : %-40s", order));
                    continue;
                }
                text.append(order);
            }
            return text.toString();
        }
    }
}

