/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.attributes;

import com.bytezone.dm3270.attributes.Attribute;
import java.awt.Color;

public abstract class ColorAttribute
extends Attribute {
    public static final byte COLOR_NEUTRAL1 = 0;
    public static final byte COLOR_BLUE = -15;
    public static final byte COLOR_RED = -14;
    public static final byte COLOR_PINK = -13;
    public static final byte COLOR_GREEN = -12;
    public static final byte COLOR_TURQUOISE = -11;
    public static final byte COLOR_YELLOW = -10;
    public static final byte COLOR_NEUTRAL2 = -9;
    public static final byte COLOR_BLACK = -8;
    public static final byte COLOR_DEEP_BLUE = -7;
    public static final byte COLOR_ORANGE = -6;
    public static final byte COLOR_PURPLE = -5;
    public static final byte COLOR_PALE_GREEN = -4;
    public static final byte COLOR_PALE_TURQUOISE = -3;
    public static final byte COLOR_GREY = -2;
    public static final byte COLOR_WHITE = -1;
    public static final Color[] COLORS = new Color[]{new Color(0.9607843f, 0.9607843f, 0.9607843f), new Color(0.11764706f, 0.5647059f, 1.0f), Color.RED, Color.PINK, new Color(0.0f, 1.0f, 0.0f), new Color(0.28235295f, 0.81960785f, 0.8f), Color.YELLOW, new Color(0.9607843f, 0.9607843f, 0.9607843f), Color.BLACK, new Color(0.0f, 0.0f, 0.54509807f), Color.ORANGE, new Color(0.5019608f, 0.0f, 0.5019608f), new Color(0.59607846f, 0.9843137f, 0.59607846f), new Color(0.6862745f, 0.93333334f, 0.93333334f), Color.GRAY, new Color(0.9607843f, 0.9607843f, 0.9607843f)};
    private static final String[] COLOR_NAMES = new String[]{"Neutral1", "Blue", "Red", "Pink", "Green", "Turquoise", "Yellow", "Neutral2", "Black", "Deep blue", "Orange", "Purple", "Pale green", "Pale turquoise", "Grey", "White"};
    protected final Color color;

    public ColorAttribute(Attribute.AttributeType type, byte byteType, byte value) {
        super(type, byteType, value);
        this.color = COLORS[value & 0xF];
    }

    public static String getName(Color searchColor) {
        int count = 0;
        for (Color color : COLORS) {
            if (color == searchColor) {
                return COLOR_NAMES[count];
            }
            ++count;
        }
        return searchColor.toString();
    }

    public static String colorName(byte value) {
        return COLOR_NAMES[value & 0xF];
    }

    @Override
    public String toString() {
        return String.format("%-12s : %02X %-12s", this.name(), this.attributeValue, ColorAttribute.colorName(this.attributeValue));
    }
}

