/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.dm3270.attributes;

import com.bytezone.dm3270.attributes.BackgroundColor;
import com.bytezone.dm3270.attributes.Charset;
import com.bytezone.dm3270.attributes.ExtendedHighlight;
import com.bytezone.dm3270.attributes.ForegroundColor;
import com.bytezone.dm3270.attributes.ResetAttribute;
import com.bytezone.dm3270.attributes.StartFieldAttribute;
import com.bytezone.dm3270.display.ScreenContext;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Attribute {
    public static final byte XA_RESET = 0;
    public static final byte XA_HIGHLIGHTING = 65;
    public static final byte XA_FGCOLOR = 66;
    public static final byte XA_CHARSET = 67;
    public static final byte XA_BGCOLOR = 69;
    public static final byte XA_TRANSPARENCY = 70;
    public static final byte XA_START_FIELD = -64;
    private static final Logger LOG = LoggerFactory.getLogger(Attribute.class);
    private static final byte XA_VALIDATION = -63;
    private static final byte XA_OUTLINING = -62;
    protected final byte attributeValue;
    private final AttributeType attributeType;
    private final byte attributeCode;

    public Attribute(AttributeType attributeType, byte attributeCode, byte attributeValue) {
        this.attributeType = attributeType;
        this.attributeCode = attributeCode;
        this.attributeValue = attributeValue;
    }

    public boolean matches(byte ... types) {
        for (byte type : types) {
            if (this.attributeCode != type) continue;
            return true;
        }
        return false;
    }

    public int pack(byte[] buffer, int offset) {
        buffer[offset++] = this.attributeCode;
        buffer[offset++] = this.attributeValue;
        return offset;
    }

    public abstract ScreenContext process(ScreenContext var1, ScreenContext var2);

    public byte getAttributeValue() {
        return this.attributeValue;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public static Optional<Attribute> getAttribute(byte attributeCode, byte attributeValue) {
        switch (attributeCode) {
            case 0: {
                return Optional.of(new ResetAttribute(attributeValue));
            }
            case -64: {
                return Optional.of(new StartFieldAttribute(attributeValue));
            }
            case 65: {
                return Optional.of(new ExtendedHighlight(attributeValue));
            }
            case 69: {
                return Optional.of(new BackgroundColor(attributeValue));
            }
            case 66: {
                return Optional.of(new ForegroundColor(attributeValue));
            }
            case 67: {
                return Optional.of(new Charset(attributeValue));
            }
            case -63: {
                LOG.warn("Validation not written");
                return Optional.empty();
            }
            case -62: {
                LOG.warn("Outlining not written");
                return Optional.empty();
            }
            case 70: {
                LOG.warn("Transparency not written");
                return Optional.empty();
            }
        }
        LOG.warn("Unknown attribute: {}", (Object)String.format("%02X", attributeCode));
        return Optional.empty();
    }

    protected String name() {
        return Attribute.getTypeName(this.attributeCode);
    }

    public static String getTypeName(byte type) {
        switch (type) {
            case 0: {
                return "Reset";
            }
            case 65: {
                return "Highlight";
            }
            case 66: {
                return "Foreground";
            }
            case 69: {
                return "Background";
            }
            case 70: {
                return "Transparency";
            }
            case -64: {
                return "Start Field";
            }
            case -63: {
                return "Validation";
            }
            case -62: {
                return "Outlining";
            }
            case 67: {
                return "Charset";
            }
        }
        return "Unknown";
    }

    public String toString() {
        return String.format("%-12s : %02X", this.name(), this.attributeValue);
    }

    public static enum AttributeType {
        START_FIELD,
        HIGHLIGHT,
        FOREGROUND_COLOR,
        BACKGROUND_COLOR,
        RESET,
        CHARSET;

    }
}

