/*
 * Decompiled with CFR 0.152.
 */
package com.tomash.androidcontacts.contactgetter.main.contactsSaver;

import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.ContactsContract;
import com.tomash.androidcontacts.contactgetter.entity.Address;
import com.tomash.androidcontacts.contactgetter.entity.ContactData;
import com.tomash.androidcontacts.contactgetter.entity.Email;
import com.tomash.androidcontacts.contactgetter.entity.IMAddress;
import com.tomash.androidcontacts.contactgetter.entity.NameData;
import com.tomash.androidcontacts.contactgetter.entity.Organization;
import com.tomash.androidcontacts.contactgetter.entity.PhoneNumber;
import com.tomash.androidcontacts.contactgetter.entity.Relation;
import com.tomash.androidcontacts.contactgetter.entity.SpecialDate;
import com.tomash.androidcontacts.contactgetter.interfaces.WithLabel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

class ContactsSaver {
    private ContentResolver mResolver;

    public ContactsSaver(ContentResolver resolver) {
        this.mResolver = resolver;
    }

    public int[] insertContacts(List<ContactData> contactDataList) {
        ArrayList<ContentValues> cvList = new ArrayList<ContentValues>(100);
        ContentProviderResult[] results = this.createContacts(contactDataList);
        int[] ids = new int[results.length];
        for (int i = 0; i < results.length; ++i) {
            int id = Integer.parseInt(results[i].uri.getLastPathSegment());
            this.generateInsertOperations(cvList, contactDataList.get(i), id);
            ids[i] = id;
        }
        this.mResolver.bulkInsert(ContactsContract.Data.CONTENT_URI, cvList.toArray(new ContentValues[cvList.size()]));
        return ids;
    }

    private void generateInsertOperations(List<ContentValues> contentValuesList, ContactData contactData, int id) {
        for (PhoneNumber number : contactData.getPhoneList()) {
            contentValuesList.add(this.getWithLabelCV("vnd.android.cursor.item/phone_v2", number, id));
        }
        for (Address address : contactData.getAddressesList()) {
            contentValuesList.add(this.getWithLabelCV("vnd.android.cursor.item/postal-address_v2", address, id));
        }
        for (Email email : contactData.getEmailList()) {
            contentValuesList.add(this.getWithLabelCV("vnd.android.cursor.item/email_v2", email, id));
        }
        for (SpecialDate specialDate : contactData.getSpecialDatesList()) {
            contentValuesList.add(this.getWithLabelCV("vnd.android.cursor.item/contact_event", specialDate, id));
        }
        for (Relation relation : contactData.getRelationsList()) {
            contentValuesList.add(this.getWithLabelCV("vnd.android.cursor.item/relation", relation, id));
        }
        for (String webSite : contactData.getWebsitesList()) {
            contentValuesList.add(this.getStringTypeCV("vnd.android.cursor.item/website", webSite, id));
        }
        for (IMAddress imAddress : contactData.getImAddressesList()) {
            contentValuesList.add(this.getImAddressCV(imAddress, id));
        }
        if (!contactData.getNote().isEmpty()) {
            contentValuesList.add(this.getStringTypeCV("vnd.android.cursor.item/note", contactData.getNote(), id));
        }
        if (!contactData.getNickName().isEmpty()) {
            contentValuesList.add(this.getStringTypeCV("vnd.android.cursor.item/nickname", contactData.getNickName(), id));
        }
        if (!contactData.getSipAddress().isEmpty()) {
            contentValuesList.add(this.getStringTypeCV("vnd.android.cursor.item/sip_address", contactData.getSipAddress(), id));
        }
        contentValuesList.add(this.getNameDataCV(contactData, id));
        Organization currentOrganization = contactData.getOrganization();
        if (!currentOrganization.getName().isEmpty() || !currentOrganization.getTitle().isEmpty()) {
            contentValuesList.add(this.getOrganizationTypeCV(currentOrganization, id));
        }
        this.saveUpdatedPhoto(id, contactData);
    }

    private void saveUpdatedPhoto(long rawContactId, ContactData contactData) {
        try {
            int length;
            InputStream inputStream;
            if (contactData.getUpdatedPhotoUri() != null) {
                inputStream = this.mResolver.openInputStream(contactData.getUpdatedPhotoUri());
                contactData.setUpdatedPhotoUri(null);
            } else if (contactData.getUpdatedBitmap() != null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                contactData.getUpdatedBitmap().compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)bos);
                byte[] bitmapdata = bos.toByteArray();
                inputStream = new ByteArrayInputStream(bitmapdata);
                contactData.setUpdatedBitmap(null);
            } else {
                return;
            }
            Uri outputUri = Uri.withAppendedPath((Uri)ContentUris.withAppendedId((Uri)ContactsContract.RawContacts.CONTENT_URI, (long)rawContactId), (String)"display_photo");
            FileOutputStream outputStream = this.mResolver.openAssetFileDescriptor(outputUri, "rw").createOutputStream();
            byte[] buffer = new byte[16384];
            while ((length = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, length);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ContentValues getWithLabelCV(String contentType, WithLabel withLabel, int id) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("raw_contact_id", Integer.valueOf(id));
        contentValues.put("mimetype", contentType);
        contentValues.put("data1", withLabel.getMainData());
        contentValues.put("data2", Integer.valueOf(withLabel.getLabelId()));
        if (withLabel.getLabelId() == withLabel.getCustomLabelId()) {
            contentValues.put("data3", withLabel.getLabelName());
        }
        return contentValues;
    }

    private ContentValues getNameDataCV(ContactData contactData, int id) {
        NameData current = contactData.getNameData();
        ContentValues contentValues = new ContentValues();
        contentValues.put("raw_contact_id", Integer.valueOf(id));
        contentValues.put("mimetype", "vnd.android.cursor.item/name");
        contentValues.put("data1", current.getFullName().isEmpty() ? contactData.getCompositeName() : current.getFullName());
        if (!current.getFirstName().isEmpty()) {
            contentValues.put("data2", current.getFirstName());
        }
        if (!current.getSurname().isEmpty()) {
            contentValues.put("data3", current.getSurname());
        }
        if (!current.getNamePrefix().isEmpty()) {
            contentValues.put("data4", current.getNamePrefix());
        }
        if (!current.getNameSuffix().isEmpty()) {
            contentValues.put("data6", current.getNameSuffix());
        }
        if (!current.getMiddleName().isEmpty()) {
            contentValues.put("data5", current.getMiddleName());
        }
        if (!current.getPhoneticFirst().isEmpty()) {
            contentValues.put("data7", current.getPhoneticFirst());
        }
        if (!current.getPhoneticMiddle().isEmpty()) {
            contentValues.put("data8", current.getPhoneticMiddle());
        }
        if (!current.getPhoneticLast().isEmpty()) {
            contentValues.put("data9", current.getPhoneticLast());
        }
        return contentValues;
    }

    private ContentValues getImAddressCV(IMAddress imAddress, int id) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("raw_contact_id", Integer.valueOf(id));
        contentValues.put("mimetype", "vnd.android.cursor.item/im");
        contentValues.put("data1", imAddress.getMainData());
        contentValues.put("data2", Integer.valueOf(1));
        contentValues.put("data5", Integer.valueOf(imAddress.getLabelId()));
        if (imAddress.getLabelId() == imAddress.getCustomLabelId()) {
            contentValues.put("data6", imAddress.getLabelName());
        }
        return contentValues;
    }

    private ContentValues getStringTypeCV(String contentType, String data, int id) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("raw_contact_id", Integer.valueOf(id));
        contentValues.put("mimetype", contentType);
        contentValues.put("data1", data);
        return contentValues;
    }

    private ContentValues getOrganizationTypeCV(Organization organization, int id) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("raw_contact_id", Integer.valueOf(id));
        contentValues.put("mimetype", "vnd.android.cursor.item/organization");
        contentValues.put("data1", organization.getName());
        contentValues.put("data4", organization.getTitle());
        return contentValues;
    }

    private ContentProviderResult[] createContacts(List<ContactData> contacts) {
        ContentProviderResult[] results = null;
        ArrayList<ContentProviderOperation> op_list = new ArrayList<ContentProviderOperation>();
        for (int i = 0; i < contacts.size(); ++i) {
            ContactData contactData = contacts.get(i);
            op_list.add(ContentProviderOperation.newInsert((Uri)ContactsContract.RawContacts.CONTENT_URI).withValue("account_type", (Object)contactData.getAccountType()).withValue("account_name", (Object)contactData.getAccountName()).withValue("starred", (Object)(contactData.isFavorite() ? 1 : 0)).build());
        }
        try {
            results = this.mResolver.applyBatch("com.android.contacts", op_list);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return results;
    }
}

