/*
 * Decompiled with CFR 0.152.
 */
package com.github.blagerweij.sessionlock;

import com.github.blagerweij.sessionlock.SessionLockService;
import com.github.blagerweij.sessionlock.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.LockException;
import liquibase.lockservice.DatabaseChangeLogLock;

public class MSSQLLockService
extends SessionLockService {
    static final String SQL_GET_LOCK = "DECLARE @lockResult int; EXEC @lockResult = sp_getapplock    @Resource = ?,    @LockMode = 'Exclusive',    @LockOwner = 'Session',    @LockTimeout = ?; SELECT @lockResult;";
    static final String SQL_RELEASE_LOCK = "DECLARE @releaseLockResult int;EXEC @releaseLockResult = sp_releaseapplock    @Resource = ?,    @LockOwner = 'Session';select @releaseLockResult;";
    static final String SQL_LOCK_INFO = "SELECT SP.hostname, SP.login_time, SP.status    FROM sys.dm_tran_locks DTL INNER JOIN sys.sysprocesses SP       ON DTL.request_session_id = SP.spid    WHERE DTL.resource_description like ?";

    @Override
    public boolean supports(Database database) {
        return database instanceof MSSQLDatabase;
    }

    private String getChangeLogLockName() {
        return StringUtils.toUpperCase(this.database.getDefaultSchemaName() + "." + this.database.getDatabaseChangeLogLockTableName());
    }

    private static Integer getIntegerResult(PreparedStatement stmt) throws SQLException {
        try (ResultSet rs = stmt.executeQuery();){
            rs.next();
            Number locked = (Number)rs.getObject(1);
            Integer n = locked == null ? null : Integer.valueOf(locked.intValue());
            return n;
        }
    }

    @Override
    protected boolean acquireLock(Connection con) throws SQLException, LockException {
        try (PreparedStatement stmt = con.prepareStatement(SQL_GET_LOCK);){
            stmt.setString(1, this.getChangeLogLockName());
            int timeoutMillis = 5000;
            stmt.setInt(2, 5000);
            Integer locked = MSSQLLockService.getIntegerResult(stmt);
            if (locked == null) {
                throw new LockException("GET_LOCK() returned NULL");
            }
            if (locked == -999) {
                throw new LockException("GET_LOCK() returned " + locked + ". Indicates a parameter validation or other call error.");
            }
            if (locked == -1 || locked == -2 || locked == -3) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    protected void releaseLock(Connection con) throws SQLException, LockException {
        try (PreparedStatement stmt = con.prepareStatement(SQL_RELEASE_LOCK);){
            stmt.setString(1, this.getChangeLogLockName());
            Integer unlocked = MSSQLLockService.getIntegerResult(stmt);
            if (!Integer.valueOf(0).equals(unlocked)) {
                throw new LockException("RELEASE_LOCK() returned " + StringUtils.toUpperCase(String.valueOf(unlocked)));
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected DatabaseChangeLogLock usedLock(Connection con) throws SQLException, LockException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String lockedBy(ResultSet rs) throws SQLException {
        String host = rs.getString("hostname");
        if (host == null) {
            return "system_process_id#" + rs.getString("spid");
        }
        return host + " (" + rs.getString("status") + ")";
    }
}

