/*
 * Decompiled with CFR 0.152.
 */
package com.github.blagerweij.sessionlock;

import com.github.blagerweij.sessionlock.SessionLockService;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Locale;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.LockException;
import liquibase.lockservice.DatabaseChangeLogLock;

public class OracleLockService
extends SessionLockService {
    static final String SQL_ALLOCATE_LOCK = "{ call dbms_lock.allocate_unique(?, ?) }";
    static final String SQL_GET_LOCK = "{ ? = call dbms_lock.request(?, ?, ?) }";
    static final String SQL_RELEASE_LOCK = "{ ? = call dbms_lock.release(?) }";
    static final String SQL_LOCK_INFO = "select l.sid, current_timestamp - numToDSInterval(l.ctime,'second'), s.USERNAME, s.OSUSER, s.MACHINE from v$lock l join v$session s on l.sid = s.SID where l.type = 'UL'   and l.id1 = ?";

    @Override
    public boolean supports(Database database) {
        return database instanceof OracleDatabase;
    }

    private String getChangeLogLockName() {
        return (this.database.getDefaultSchemaName() + "." + this.database.getDatabaseChangeLogLockTableName()).toUpperCase(Locale.ROOT);
    }

    private String allocateLock(Connection con) throws SQLException {
        try (CallableStatement stmt = con.prepareCall(SQL_ALLOCATE_LOCK);){
            stmt.setString(1, this.getChangeLogLockName());
            stmt.registerOutParameter(2, 12);
            stmt.executeQuery();
            String string = stmt.getString(2);
            return string;
        }
    }

    @Override
    protected boolean acquireLock(Connection con) throws SQLException, LockException {
        String lockHandle = this.allocateLock(con);
        try (CallableStatement stmt = con.prepareCall(SQL_GET_LOCK);){
            stmt.registerOutParameter(1, 4);
            stmt.setString(2, lockHandle);
            stmt.setInt(3, 6);
            int timeoutSeconds = 5;
            stmt.setInt(4, 5);
            stmt.executeQuery();
            int rc = stmt.getInt(1);
            switch (rc) {
                case 0: {
                    boolean bl = true;
                    return bl;
                }
                case 1: {
                    boolean bl = false;
                    return bl;
                }
                case 2: {
                    throw new LockException("deadlock");
                }
                case 3: {
                    throw new LockException("parameter error");
                }
                case 4: {
                    throw new LockException("already own lock");
                }
                case 5: {
                    throw new LockException("illegal lock handle");
                }
            }
            throw new LockException("uknown error: " + rc);
        }
    }

    @Override
    protected void releaseLock(Connection con) throws SQLException, LockException {
        String lockHandle = this.allocateLock(con);
        try (CallableStatement stmt = con.prepareCall(SQL_RELEASE_LOCK);){
            stmt.registerOutParameter(1, 4);
            stmt.setString(2, lockHandle);
            stmt.executeQuery();
            int rc = stmt.getInt(1);
            switch (rc) {
                case 0: {
                    return;
                }
                case 3: {
                    throw new LockException("parameter error");
                }
                case 4: {
                    throw new LockException("does not own lock");
                }
                case 5: {
                    throw new LockException("illegal lock handle");
                }
            }
            throw new LockException("uknown error: " + rc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected DatabaseChangeLogLock usedLock(Connection con) throws SQLException {
        String lockHandle = this.allocateLock(con);
        if (lockHandle.length() < 10) return null;
        try {
            int lockId = Integer.parseInt(lockHandle.substring(0, 10));
            try (PreparedStatement stmt = con.prepareStatement(SQL_LOCK_INFO);){
                stmt.setInt(1, lockId);
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next()) return null;
                    DatabaseChangeLogLock databaseChangeLogLock = new DatabaseChangeLogLock(lockId, (Date)rs.getTimestamp(2), this.lockedBy(rs));
                    return databaseChangeLogLock;
                }
            }
        }
        catch (NumberFormatException e) {
            OracleLockService.getLog(((Object)((Object)this)).getClass()).warning("could not parse lock handle " + lockHandle, (Throwable)e);
        }
        return null;
    }

    private String lockedBy(ResultSet rs) throws SQLException {
        return String.format("(session_id=%d)(current_user=%s)(os_user=%s)(host=%s)", rs.getInt(1), rs.getString(3), rs.getString(4), rs.getString(5));
    }
}

