/*
 * Decompiled with CFR 0.152.
 */
package com.github.bjornvester.xjc;

import com.github.bjornvester.xjc.XjcExtension;
import com.github.bjornvester.xjc.XjcTask;
import com.github.bjornvester.xjc.XjcWorker;
import com.github.bjornvester.xjc.XjcWorkerParams;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020%H\u0002J\b\u00107\u001a\u000205H\u0007J\b\u00108\u001a\u000205H\u0002J\b\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u000205H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u00020\u000e8GX\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00130\u00130\u00178GX\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R$\u0010\u001e\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00130\u00130\u00178GX\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u0019\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u00128G\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u00178G\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001aR\u0013\u0010$\u001a\u00020%8G\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010(\u001a\u00020%8G\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010'R\u0013\u0010*\u001a\u00020%8G\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010,\u001a\u00020\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0010R\u0013\u0010.\u001a\u00020\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u0010R\u0013\u00100\u001a\u00020\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0010R\u0013\u00102\u001a\u00020%8G\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010'\u00a8\u0006<"}, d2={"Lcom/github/bjornvester/xjc/XjcTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "fileSystemOperations", "Lorg/gradle/api/file/FileSystemOperations;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/file/ArchiveOperations;Lorg/gradle/api/file/FileSystemOperations;Lorg/gradle/api/file/ProjectLayout;)V", "bindingFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getBindingFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "defaultPackage", "Lorg/gradle/api/provider/Property;", "", "getDefaultPackage", "()Lorg/gradle/api/provider/Property;", "excludes", "Lorg/gradle/api/provider/ListProperty;", "kotlin.jvm.PlatformType", "getExcludes", "()Lorg/gradle/api/provider/ListProperty;", "generateEpisode", "", "getGenerateEpisode", "includes", "getIncludes", "markGenerated", "getMarkGenerated", "options", "getOptions", "outputJavaDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputJavaDir", "()Lorg/gradle/api/file/DirectoryProperty;", "outputResourcesDir", "getOutputResourcesDir", "tmpBindFilesDir", "getTmpBindFilesDir", "xjcBindConfiguration", "getXjcBindConfiguration", "xjcConfiguration", "getXjcConfiguration", "xjcPluginsConfiguration", "getXjcPluginsConfiguration", "xsdDir", "getXsdDir", "delete", "", "dir", "doCodeGeneration", "extractBindFilesFromJars", "getXjcExtension", "Lcom/github/bjornvester/xjc/XjcExtension;", "validateOptions", "xjc-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nXjcTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XjcTask.kt\ncom/github/bjornvester/xjc/XjcTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1855#2,2:213\n1855#2,2:215\n*S KotlinDebug\n*F\n+ 1 XjcTask.kt\ncom/github/bjornvester/xjc/XjcTask\n*L\n177#1:213,2\n191#1:215,2\n*E\n"})
public class XjcTask
extends DefaultTask {
    @NotNull
    private final WorkerExecutor workerExecutor;
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private final ArchiveOperations archiveOperations;
    @NotNull
    private final FileSystemOperations fileSystemOperations;
    @NotNull
    private final Property<String> defaultPackage;
    @NotNull
    private final DirectoryProperty xsdDir;
    @Optional
    @NotNull
    private final ListProperty<String> includes;
    @Optional
    @NotNull
    private final ListProperty<String> excludes;
    @NotNull
    private final ConfigurableFileCollection xjcConfiguration;
    @NotNull
    private final ConfigurableFileCollection xjcPluginsConfiguration;
    @NotNull
    private final ConfigurableFileCollection xjcBindConfiguration;
    @Optional
    @Input
    @NotNull
    private final Property<Boolean> generateEpisode;
    @Optional
    @NotNull
    private final ConfigurableFileCollection bindingFiles;
    @NotNull
    private final ListProperty<String> options;
    @NotNull
    private final Property<Boolean> markGenerated;
    @NotNull
    private final DirectoryProperty outputJavaDir;
    @NotNull
    private final DirectoryProperty outputResourcesDir;
    @NotNull
    private final DirectoryProperty tmpBindFilesDir;

    @Inject
    public XjcTask(@NotNull WorkerExecutor workerExecutor, @NotNull ObjectFactory objectFactory, @NotNull ArchiveOperations archiveOperations, @NotNull FileSystemOperations fileSystemOperations, @NotNull ProjectLayout projectLayout) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)archiveOperations, (String)"archiveOperations");
        Intrinsics.checkNotNullParameter((Object)fileSystemOperations, (String)"fileSystemOperations");
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        this.workerExecutor = workerExecutor;
        this.objectFactory = objectFactory;
        this.archiveOperations = archiveOperations;
        this.fileSystemOperations = fileSystemOperations;
        Property property = this.objectFactory.property(String.class).convention((Provider)this.getXjcExtension().getDefaultPackage());
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"objectFactory.property(S\u2026tension().defaultPackage)");
        this.defaultPackage = property;
        DirectoryProperty directoryProperty = this.objectFactory.directoryProperty().convention((Provider)this.getXjcExtension().getXsdDir());
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objectFactory.directoryP\u2026getXjcExtension().xsdDir)");
        this.xsdDir = directoryProperty;
        ListProperty listProperty = this.objectFactory.listProperty(String.class).convention((Provider)this.getXjcExtension().getIncludes());
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"objectFactory.listProper\u2026tXjcExtension().includes)");
        this.includes = listProperty;
        ListProperty listProperty2 = this.objectFactory.listProperty(String.class).convention((Provider)this.getXjcExtension().getExcludes());
        Intrinsics.checkNotNullExpressionValue((Object)listProperty2, (String)"objectFactory.listProper\u2026tXjcExtension().excludes)");
        this.excludes = listProperty2;
        ConfigurableFileCollection configurableFileCollection = this.objectFactory.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"objectFactory.fileCollection()");
        this.xjcConfiguration = configurableFileCollection;
        ConfigurableFileCollection configurableFileCollection2 = this.objectFactory.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"objectFactory.fileCollection()");
        this.xjcPluginsConfiguration = configurableFileCollection2;
        ConfigurableFileCollection configurableFileCollection3 = this.objectFactory.fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection3, (String)"objectFactory.fileCollection()");
        this.xjcBindConfiguration = configurableFileCollection3;
        Property property2 = this.objectFactory.property(Boolean.TYPE).convention((Provider)this.getXjcExtension().getGenerateEpisode());
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"objectFactory.property(B\u2026ension().generateEpisode)");
        this.generateEpisode = property2;
        this.bindingFiles = this.getXjcExtension().getBindingFiles();
        ListProperty listProperty3 = this.objectFactory.listProperty(String.class).convention((Provider)this.getXjcExtension().getOptions());
        Intrinsics.checkNotNullExpressionValue((Object)listProperty3, (String)"objectFactory.listProper\u2026etXjcExtension().options)");
        this.options = listProperty3;
        Property property3 = this.objectFactory.property(Boolean.TYPE).convention((Provider)this.getXjcExtension().getMarkGenerated());
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"objectFactory.property(B\u2026xtension().markGenerated)");
        this.markGenerated = property3;
        DirectoryProperty directoryProperty2 = this.objectFactory.directoryProperty().convention((Provider)this.getXjcExtension().getOutputJavaDir());
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty2, (String)"objectFactory.directoryP\u2026xtension().outputJavaDir)");
        this.outputJavaDir = directoryProperty2;
        DirectoryProperty directoryProperty3 = this.objectFactory.directoryProperty().convention((Provider)this.getXjcExtension().getOutputResourcesDir());
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty3, (String)"objectFactory.directoryP\u2026ion().outputResourcesDir)");
        this.outputResourcesDir = directoryProperty3;
        DirectoryProperty directoryProperty4 = this.objectFactory.directoryProperty().convention(projectLayout.getBuildDirectory().dir("xjc/extracted-bind-files"));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty4, (String)"objectFactory.directoryP\u2026c/extracted-bind-files\"))");
        this.tmpBindFilesDir = directoryProperty4;
        this.setGroup("build");
        this.setDescription("Generates Java classes from XSD files.");
    }

    @Optional
    @Input
    @NotNull
    public final Property<String> getDefaultPackage() {
        return this.defaultPackage;
    }

    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final DirectoryProperty getXsdDir() {
        return this.xsdDir;
    }

    @Input
    @NotNull
    public final ListProperty<String> getIncludes() {
        return this.includes;
    }

    @Input
    @NotNull
    public final ListProperty<String> getExcludes() {
        return this.excludes;
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getXjcConfiguration() {
        return this.xjcConfiguration;
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getXjcPluginsConfiguration() {
        return this.xjcPluginsConfiguration;
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getXjcBindConfiguration() {
        return this.xjcBindConfiguration;
    }

    @NotNull
    public final Property<Boolean> getGenerateEpisode() {
        return this.generateEpisode;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final ConfigurableFileCollection getBindingFiles() {
        return this.bindingFiles;
    }

    @Input
    @NotNull
    public final ListProperty<String> getOptions() {
        return this.options;
    }

    @Input
    @NotNull
    public final Property<Boolean> getMarkGenerated() {
        return this.markGenerated;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputJavaDir() {
        return this.outputJavaDir;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputResourcesDir() {
        return this.outputResourcesDir;
    }

    @Internal
    @NotNull
    public final DirectoryProperty getTmpBindFilesDir() {
        return this.tmpBindFilesDir;
    }

    @TaskAction
    public final void doCodeGeneration() {
        this.delete(this.outputJavaDir);
        this.delete(this.outputResourcesDir);
        this.delete(this.tmpBindFilesDir);
        ((Directory)this.outputJavaDir.get()).getAsFile().mkdirs();
        ((Directory)this.outputResourcesDir.get()).getAsFile().mkdirs();
        this.validateOptions();
        FileTree fileTree = this.xsdDir.getAsFileTree().matching(new Action(this){
            final /* synthetic */ XjcTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull PatternFilterable $this$matching) {
                Intrinsics.checkNotNullParameter((Object)$this$matching, (String)"$this$matching");
                $this$matching.include((Iterable)this.this$0.getIncludes().getOrElse((Object)CollectionsKt.emptyList()));
                $this$matching.exclude((Iterable)this.this$0.getExcludes().getOrElse((Object)CollectionsKt.emptyList()));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"@TaskAction\n    fun doCo\u2026ted.get()\n        }\n    }");
        FileTree xsdFilesAsFilteredFileTree2 = fileTree;
        this.getLogger().info("Loading XSD files " + xsdFilesAsFilteredFileTree2.getFiles());
        this.getLogger().debug("XSD files are loaded from {}", this.xsdDir.get());
        FileCollection fileCollection = this.xjcConfiguration.plus((FileCollection)this.xjcPluginsConfiguration);
        Intrinsics.checkNotNullExpressionValue((Object)fileCollection, (String)"xjcConfiguration + xjcPluginsConfiguration");
        FileCollection xjcClasspath = fileCollection;
        this.getLogger().debug("Loading JAR files for XJC: {}", (Object)xjcClasspath);
        this.extractBindFilesFromJars();
        Set set = this.tmpBindFilesDir.getAsFileTree().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"tmpBindFilesDir.asFileTree.files");
        Set set2 = this.bindingFiles.getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"bindingFiles.files");
        Set allBindingFiles = SetsKt.plus((Set)set, (Iterable)set2);
        if (!((Collection)allBindingFiles).isEmpty()) {
            this.getLogger().info("Loading binding files: " + allBindingFiles);
        }
        Ref.ObjectRef episodeFilepathArg = new Ref.ObjectRef();
        episodeFilepathArg.element = "";
        Object object = this.generateEpisode.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"generateEpisode.get()");
        if (((Boolean)object).booleanValue()) {
            Provider provider = this.outputResourcesDir.dir("META-INF");
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"outputResourcesDir.dir(\"META-INF\")");
            Provider episodeDir = provider;
            ((Directory)episodeDir.get()).getAsFile().mkdirs();
            String string = ((Directory)episodeDir.get()).file("sun-jaxb.episode").getAsFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"episodeDir.get().file(\"s\u2026ode\").asFile.absolutePath");
            episodeFilepathArg.element = string;
            this.getLogger().info("Generating episode file in " + (String)episodeFilepathArg.element);
        }
        WorkQueue workQueue2 = this.workerExecutor.processIsolation(new Action(this, xjcClasspath){
            final /* synthetic */ XjcTask this$0;
            final /* synthetic */ FileCollection $xjcClasspath;
            {
                this.this$0 = $receiver;
                this.$xjcClasspath = $xjcClasspath;
            }

            public final void execute(@NotNull ProcessWorkerSpec $this$processIsolation) {
                Intrinsics.checkNotNullParameter((Object)$this$processIsolation, (String)"$this$processIsolation");
                Object[] objectArray = new Pair[]{TuplesKt.to((Object)"javax.xml.parsers.DocumentBuilderFactory", (Object)"com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl"), TuplesKt.to((Object)"javax.xml.parsers.SAXParserFactory", (Object)"com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl"), TuplesKt.to((Object)"javax.xml.validation.SchemaFactory:http://www.w3.org/2001/XMLSchema", (Object)"org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory"), TuplesKt.to((Object)"javax.xml.accessExternalSchema", (Object)"all")};
                $this$processIsolation.getForkOptions().setSystemProperties(MapsKt.mapOf((Pair[])objectArray));
                if (this.this$0.getLogger().isDebugEnabled()) {
                    Map map = $this$processIsolation.getForkOptions().getSystemProperties();
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"forkOptions.systemProperties");
                    objectArray = map;
                    String string = "com.sun.tools.xjc.Options.findServices";
                    String string2 = "";
                    objectArray.put(string, string2);
                }
                JavaForkOptions javaForkOptions = $this$processIsolation.getForkOptions();
                String string = System.getenv("LANG");
                if (string == null) {
                    string = "C.UTF-8";
                }
                javaForkOptions.environment("LANG", (Object)string);
                objectArray = new Object[]{this.$xjcClasspath};
                $this$processIsolation.getClasspath().from(objectArray);
            }
        });
        System.setProperty("com.sun.tools.xjc.Options.findServices", "true");
        workQueue2.submit(XjcWorker.class, new Action(this, xsdFilesAsFilteredFileTree2, (Ref.ObjectRef<String>)episodeFilepathArg, allBindingFiles){
            final /* synthetic */ XjcTask this$0;
            final /* synthetic */ FileTree $xsdFilesAsFilteredFileTree;
            final /* synthetic */ Ref.ObjectRef<String> $episodeFilepathArg;
            final /* synthetic */ Set<File> $allBindingFiles;
            {
                this.this$0 = $receiver;
                this.$xsdFilesAsFilteredFileTree = $xsdFilesAsFilteredFileTree;
                this.$episodeFilepathArg = $episodeFilepathArg;
                this.$allBindingFiles = $allBindingFiles;
            }

            public final void execute(@NotNull XjcWorkerParams $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$this$submit");
                XjcTask task2 = this.this$0;
                Set set = this.$xsdFilesAsFilteredFileTree.getFiles();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"xsdFilesAsFilteredFileTree.files");
                $this$submit.setXsdFiles(set);
                File file = ((Directory)task2.getOutputJavaDir().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"task.outputJavaDir.get().asFile");
                $this$submit.setOutputJavaDir(file);
                File file2 = ((Directory)task2.getOutputResourcesDir().get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"task.outputResourcesDir.get().asFile");
                $this$submit.setOutputResourceDir(file2);
                $this$submit.setDefaultPackage(task2.getDefaultPackage());
                $this$submit.setEpisodeFilepath((String)this.$episodeFilepathArg.element);
                $this$submit.setBindFiles(this.$allBindingFiles);
                $this$submit.setVerbose(task2.getLogger().isDebugEnabled());
                Object object = task2.getOptions().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"task.options.get()");
                $this$submit.setOptions((List)object);
                Object object2 = task2.getMarkGenerated().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"task.markGenerated.get()");
                $this$submit.setMarkGenerated((Boolean)object2);
            }
        });
    }

    private final void delete(DirectoryProperty dir) {
        if (((Directory)dir.get()).getAsFile().exists()) {
            this.fileSystemOperations.delete(new Action(dir){
                final /* synthetic */ DirectoryProperty $dir;
                {
                    this.$dir = $dir;
                }

                public final void execute(@NotNull DeleteSpec $this$delete) {
                    Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"$this$delete");
                    Object[] objectArray = new Object[]{this.$dir};
                    $this$delete.delete(objectArray);
                }
            });
        }
    }

    private final void validateOptions() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"-classpath", (Object)"Leads to resource leaks. Use the 'xjc', 'xjcBindings' or 'xjcPlugins' configuration instead"), TuplesKt.to((Object)"-d", (Object)"Configured through the 'outputJavaDir' property"), TuplesKt.to((Object)"-b", (Object)"Configured through the 'bindingFiles' property"), TuplesKt.to((Object)"-p", (Object)"Configured through the 'defaultPackage' property"), TuplesKt.to((Object)"-episode", (Object)"Configured through the 'generateEpisode' property"), TuplesKt.to((Object)"-mark-generated", (Object)"Configured through the 'markGenerated' property")};
        Map prohibitedOptions = MapsKt.mapOf((Pair[])pairArray);
        Object object = this.options.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"options.get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String option = (String)element$iv;
            boolean bl = false;
            if (!prohibitedOptions.containsKey(option)) continue;
            throw new GradleException("the option '" + option + "' is not allowed in this plugin. Reason: " + (String)prohibitedOptions.get(option));
        }
    }

    private final void extractBindFilesFromJars() {
        this.getLogger().debug("Loading binding JAR files: {}", (Object)this.xjcBindConfiguration);
        Iterable $this$forEach$iv = (Iterable)this.xjcBindConfiguration;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File bindJarFile = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)bindJarFile, (String)"bindJarFile");
            if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)bindJarFile), (Object)"jar")) {
                Set episodeFiles2;
                Intrinsics.checkNotNullExpressionValue((Object)this.archiveOperations.zipTree((Object)bindJarFile).matching((Action)extractBindFilesFromJars.1.episodeFiles.1.INSTANCE).getFiles(), (String)"archiveOperations.zipTre\u2026un-jaxb.episode\") }.files");
                if (episodeFiles2.isEmpty()) {
                    this.getLogger().warn("No episodes (sun-jaxb.episode) found in bind jar file " + bindJarFile.getName());
                    continue;
                }
                Object object = CollectionsKt.first((Iterable)episodeFiles2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"episodeFiles.first()");
                File file = (File)object;
                StringBuilder stringBuilder = new StringBuilder();
                String string = bindJarFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bindJarFile.name");
                File file2 = ((RegularFile)this.tmpBindFilesDir.file(stringBuilder.append(StringsKt.removeSuffix((String)string, (CharSequence)".jar")).append(".episode").toString()).get()).getAsFile();
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"tmpBindFilesDir\n        \u2026                  .asFile");
                FilesKt.copyTo$default((File)file, (File)file2, (boolean)false, (int)0, (int)6, null);
                continue;
            }
            this.getLogger().warn("Unknown binding file configuration type for " + bindJarFile.getName());
        }
    }

    private final XjcExtension getXjcExtension() {
        Object object = this.getProject().getExtensions().getByName("xjc");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.github.bjornvester.xjc.XjcExtension");
        return (XjcExtension)object;
    }
}

