/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.berndpruenster.netlayer.tor.HiddenServiceSocketAddress;
import org.berndpruenster.netlayer.tor.Tor;
import org.berndpruenster.netlayer.tor.TorSocketsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001f\u0018\u00002\u00020\u0001B1\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB9\b\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\b\u0010 \u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u001dH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0007H\u0016J\b\u0010%\u001a\u00020\u0007H\u0016J\b\u0010&\u001a\u00020\u0012H\u0016J\b\u0010'\u001a\u00020\u001dH\u0016J\b\u0010(\u001a\u00020\u0007H\u0016J\b\u0010)\u001a\u00020\u0007H\u0016J\b\u0010*\u001a\u00020\u0007H\u0016J\b\u0010+\u001a\u00020\u001dH\u0016J\b\u0010,\u001a\u00020\u0007H\u0016J\b\u0010-\u001a\u00020\u001dH\u0016J\b\u0010.\u001a\u00020\u001dH\u0016J\b\u0010/\u001a\u00020\u001dH\u0016J\b\u00100\u001a\u00020\u001dH\u0016J\b\u00101\u001a\u00020\u001dH\u0016J\u0010\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0007H\u0016J\u0010\u00104\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u001dH\u0016J\u0010\u00105\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u001dH\u0016J \u00106\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0007H\u0016J\u0010\u00109\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0007H\u0016J\u0010\u0010:\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u001dH\u0016J\u0010\u0010;\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0007H\u0016J\u0018\u0010<\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\u0007H\u0016J\u0010\u0010=\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0007H\u0016J\u0010\u0010>\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u001dH\u0016J\u0010\u0010?\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0007H\u0016J\b\u0010@\u001a\u00020\u0010H\u0016J\b\u0010A\u001a\u00020\u0010H\u0016J\b\u0010B\u001a\u00020\u0005H\u0016R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/berndpruenster/netlayer/tor/TorSocket;", "Ljava/net/Socket;", "socketAddress", "Lorg/berndpruenster/netlayer/tor/HiddenServiceSocketAddress;", "streamId", "", "numTries", "", "tor", "Lorg/berndpruenster/netlayer/tor/Tor;", "(Lorg/berndpruenster/netlayer/tor/HiddenServiceSocketAddress;Ljava/lang/String;ILorg/berndpruenster/netlayer/tor/Tor;)V", "destination", "port", "(Ljava/lang/String;ILjava/lang/String;ILorg/berndpruenster/netlayer/tor/Tor;)V", "socket", "bind", "", "addr", "Ljava/net/SocketAddress;", "close", "connect", "", "getChannel", "Ljava/nio/channels/SocketChannel;", "getInetAddress", "Ljava/net/InetAddress;", "getInputStream", "Ljava/io/InputStream;", "getKeepAlive", "", "getLocalAddress", "getLocalPort", "getLocalSocketAddress", "getOOBInline", "getOutputStream", "Ljava/io/OutputStream;", "getPort", "getReceiveBufferSize", "getRemoteSocketAddress", "getReuseAddress", "getSendBufferSize", "getSoLinger", "getSoTimeout", "getTcpNoDelay", "getTrafficClass", "isBound", "isClosed", "isConnected", "isInputShutdown", "isOutputShutdown", "sendUrgentData", "arg0", "setKeepAlive", "setOOBInline", "setPerformancePreferences", "arg1", "arg2", "setReceiveBufferSize", "setReuseAddress", "setSendBufferSize", "setSoLinger", "setSoTimeout", "setTcpNoDelay", "setTrafficClass", "shutdownInput", "shutdownOutput", "toString"})
public final class TorSocket
extends Socket {
    private final Socket socket;
    private final String destination;

    @NotNull
    public Void connect(@NotNull SocketAddress addr) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)addr, (String)"addr");
        throw (Throwable)new IOException("DONT!");
    }

    @NotNull
    public Void connect(@NotNull SocketAddress addr, int port) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)addr, (String)"addr");
        throw (Throwable)new IOException("DONT!");
    }

    @Override
    public void bind(@NotNull SocketAddress addr) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)addr, (String)"addr");
        this.socket.bind(addr);
    }

    @Override
    @NotNull
    public InetAddress getInetAddress() {
        InetAddress inetAddress = this.socket.getInetAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"socket.inetAddress");
        return inetAddress;
    }

    @Override
    @NotNull
    public InetAddress getLocalAddress() {
        InetAddress inetAddress = this.socket.getLocalAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress, (String)"socket.localAddress");
        return inetAddress;
    }

    @Override
    public int getPort() {
        return this.socket.getPort();
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    @NotNull
    public SocketAddress getRemoteSocketAddress() {
        return new HiddenServiceSocketAddress(this.destination, this.getPort());
    }

    @Override
    @NotNull
    public SocketAddress getLocalSocketAddress() {
        SocketAddress socketAddress = this.socket.getLocalSocketAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)socketAddress, (String)"socket.localSocketAddress");
        return socketAddress;
    }

    @Override
    @NotNull
    public SocketChannel getChannel() {
        SocketChannel socketChannel = this.socket.getChannel();
        Intrinsics.checkExpressionValueIsNotNull((Object)socketChannel, (String)"socket.channel");
        return socketChannel;
    }

    @Override
    @NotNull
    public String toString() {
        return "TorSocket[addr=" + this.destination + ",port=" + this.getPort() + ", localPort=" + this.getLocalPort() + ']';
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.socket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    @Override
    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.socket.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"socket.getInputStream()");
        return inputStream;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = this.socket.getOutputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"socket.getOutputStream()");
        return outputStream;
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    @Override
    public void setTcpNoDelay(boolean arg0) throws SocketException {
        this.socket.setTcpNoDelay(arg0);
    }

    @Override
    public void setSoLinger(boolean arg0, int arg1) throws SocketException {
        this.socket.setSoLinger(arg0, arg1);
    }

    @Override
    public void sendUrgentData(int arg0) throws IOException {
        this.socket.sendUrgentData(arg0);
    }

    @Override
    public void setOOBInline(boolean arg0) throws SocketException {
        this.socket.setOOBInline(arg0);
    }

    @Override
    public void setSoTimeout(int arg0) throws SocketException {
        this.socket.setSoTimeout(arg0);
    }

    @Override
    public void setSendBufferSize(int arg0) throws SocketException {
        this.socket.setSendBufferSize(arg0);
    }

    @Override
    public void setReceiveBufferSize(int arg0) throws SocketException {
        this.socket.setReceiveBufferSize(arg0);
    }

    @Override
    public void setKeepAlive(boolean arg0) throws SocketException {
        this.socket.setKeepAlive(arg0);
    }

    @Override
    public void setTrafficClass(int arg0) throws SocketException {
        this.socket.setTrafficClass(arg0);
    }

    @Override
    public void setReuseAddress(boolean arg0) throws SocketException {
        this.socket.setReuseAddress(arg0);
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    @Override
    public void setPerformancePreferences(int arg0, int arg1, int arg2) {
        this.socket.setPerformancePreferences(arg0, arg1, arg2);
    }

    @JvmOverloads
    public TorSocket(@NotNull String destination, int port, @Nullable String streamId, int numTries, @Nullable Tor tor) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        this.destination = destination;
        this.socket = TorSocketsKt.access$setup(this.destination, port, numTries, streamId, tor);
    }

    public /* synthetic */ TorSocket(String string, int n, String string2, int n2, Tor tor, int n3, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n3 & 4) != 0) {
            string2 = null;
        }
        if ((n3 & 8) != 0) {
            n2 = 5;
        }
        if ((n3 & 0x10) != 0) {
            tor = null;
        }
        this(string, n, string2, n2, tor);
    }

    @JvmOverloads
    public TorSocket(@NotNull String destination, int port, @Nullable String streamId, int numTries) throws IOException {
        this(destination, port, streamId, numTries, null, 16, null);
    }

    @JvmOverloads
    public TorSocket(@NotNull String destination, int port, @Nullable String streamId) throws IOException {
        this(destination, port, streamId, 0, null, 24, null);
    }

    @JvmOverloads
    public TorSocket(@NotNull String destination, int port) throws IOException {
        this(destination, port, null, 0, null, 28, null);
    }

    @JvmOverloads
    public TorSocket(@NotNull HiddenServiceSocketAddress socketAddress, @Nullable String streamId, int numTries, @Nullable Tor tor) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)socketAddress, (String)"socketAddress");
        this(socketAddress.getServiceName(), socketAddress.getHiddenServicePort(), streamId, numTries, tor);
    }

    public /* synthetic */ TorSocket(HiddenServiceSocketAddress hiddenServiceSocketAddress, String string, int n, Tor tor, int n2, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            n = 5;
        }
        if ((n2 & 8) != 0) {
            tor = null;
        }
        this(hiddenServiceSocketAddress, string, n, tor);
    }

    @JvmOverloads
    public TorSocket(@NotNull HiddenServiceSocketAddress socketAddress, @Nullable String streamId, int numTries) throws IOException {
        this(socketAddress, streamId, numTries, null, 8, null);
    }

    @JvmOverloads
    public TorSocket(@NotNull HiddenServiceSocketAddress socketAddress, @Nullable String streamId) throws IOException {
        this(socketAddress, streamId, 0, null, 12, null);
    }

    @JvmOverloads
    public TorSocket(@NotNull HiddenServiceSocketAddress socketAddress) throws IOException {
        this(socketAddress, null, 0, null, 14, null);
    }
}

