/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import com.runjva.sourceforge.jsocks.protocol.Authentication;
import com.runjva.sourceforge.jsocks.protocol.Socks5Proxy;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import mu.KLogger;
import net.freehaven.tor.control.TorControlConnection;
import org.berndpruenster.netlayer.tor.Control;
import org.berndpruenster.netlayer.tor.HsContainer;
import org.berndpruenster.netlayer.tor.OsType;
import org.berndpruenster.netlayer.tor.TorController;
import org.berndpruenster.netlayer.tor.TorCtlException;
import org.berndpruenster.netlayer.tor.TorEventHandler;
import org.berndpruenster.netlayer.tor.TorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 02\u00020\u0001:\u00010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u000bH\u0007J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u000bJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000bH&J\u001e\u0010(\u001a\u00020)2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004J\b\u0010,\u001a\u00020-H&J\u000e\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R$\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u00061"}, d2={"Lorg/berndpruenster/netlayer/tor/Tor;", "", "()V", "TOTAL_SEC_PER_STARTUP", "", "getTOTAL_SEC_PER_STARTUP", "()I", "TRIES_PER_STARTUP", "getTRIES_PER_STARTUP", "activeHiddenServices", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getActiveHiddenServices", "()Ljava/util/ArrayList;", "control", "Lorg/berndpruenster/netlayer/tor/Control;", "getControl", "()Lorg/berndpruenster/netlayer/tor/Control;", "setControl", "(Lorg/berndpruenster/netlayer/tor/Control;)V", "eventHandler", "Lorg/berndpruenster/netlayer/tor/TorEventHandler;", "getEventHandler", "()Lorg/berndpruenster/netlayer/tor/TorEventHandler;", "torController", "Lorg/berndpruenster/netlayer/tor/TorController;", "getTorController", "()Lorg/berndpruenster/netlayer/tor/TorController;", "setTorController", "(Lorg/berndpruenster/netlayer/tor/TorController;)V", "getProxy", "Lcom/runjva/sourceforge/jsocks/protocol/Socks5Proxy;", "streamID", "isHiddenServiceAvailable", "", "onionUrl", "preprocessHsDirName", "Ljava/io/File;", "hsDirName", "publishHiddenService", "Lorg/berndpruenster/netlayer/tor/HsContainer;", "hiddenServicePort", "localPort", "shutdown", "", "unpublishHiddenService", "serviceName", "Companion", "tor"})
public abstract class Tor {
    private final int TOTAL_SEC_PER_STARTUP = 240;
    private final int TRIES_PER_STARTUP = 5;
    @NotNull
    private final TorEventHandler eventHandler = new TorEventHandler();
    @NotNull
    public Control control;
    @NotNull
    protected TorController torController;
    @NotNull
    private final ArrayList<String> activeHiddenServices = new ArrayList();
    @Nullable
    private static Tor default;
    public static final Companion Companion;

    protected final int getTOTAL_SEC_PER_STARTUP() {
        return this.TOTAL_SEC_PER_STARTUP;
    }

    protected final int getTRIES_PER_STARTUP() {
        return this.TRIES_PER_STARTUP;
    }

    @NotNull
    protected final TorEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @NotNull
    public final Control getControl() {
        Control control = this.control;
        if (control == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"control");
        }
        return control;
    }

    public final void setControl(@NotNull Control control) {
        Intrinsics.checkParameterIsNotNull((Object)control, (String)"<set-?>");
        this.control = control;
    }

    @NotNull
    protected final TorController getTorController() {
        TorController torController = this.torController;
        if (torController == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"torController");
        }
        return torController;
    }

    protected final void setTorController(@NotNull TorController torController) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)torController), (String)"<set-?>");
        this.torController = torController;
    }

    @NotNull
    protected final ArrayList<String> getActiveHiddenServices() {
        return this.activeHiddenServices;
    }

    @JvmOverloads
    @NotNull
    public final Socks5Proxy getProxy(@Nullable String streamID) throws TorCtlException {
        Control control = this.control;
        if (control == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"control");
        }
        return Companion.getProxy(control.getProxyPort$tor(), streamID);
    }

    public static /* synthetic */ Socks5Proxy getProxy$default(Tor tor, String string, int n, Object object) throws TorCtlException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getProxy");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return tor.getProxy(string);
    }

    @JvmOverloads
    @NotNull
    public final Socks5Proxy getProxy() throws TorCtlException {
        return Tor.getProxy$default(this, null, 1, null);
    }

    @NotNull
    public abstract File preprocessHsDirName(@NotNull String var1);

    @NotNull
    public final HsContainer publishHiddenService(@NotNull String hsDirName, int hiddenServicePort, int localPort) throws IOException, TorCtlException {
        Intrinsics.checkParameterIsNotNull((Object)hsDirName, (String)"hsDirName");
        File hostnameFile = new File(this.preprocessHsDirName(hsDirName), "hostname");
        File keyFile = new File(this.preprocessHsDirName(hsDirName), "private_key");
        TorControlConnection.CreateHiddenServiceResult result = null;
        Control control = this.control;
        if (control == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"control");
        }
        control.enableHiddenServiceEvents();
        if (keyFile.exists()) {
            TorController torController = this.torController;
            if (torController == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"torController");
            }
            TorControlConnection.CreateHiddenServiceResult createHiddenServiceResult = torController.createHiddenService(hiddenServicePort, localPort, FilesKt.readText$default((File)keyFile, null, (int)1, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)createHiddenServiceResult, (String)"torController.createHidd\u2026Port, keyFile.readText())");
            result = createHiddenServiceResult;
        } else {
            block11: {
                TorController torController = this.torController;
                if (torController == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"torController");
                }
                TorControlConnection.CreateHiddenServiceResult createHiddenServiceResult = torController.createHiddenService(hiddenServicePort, localPort);
                Intrinsics.checkExpressionValueIsNotNull((Object)createHiddenServiceResult, (String)"torController.createHidd\u2026enServicePort, localPort)");
                result = createHiddenServiceResult;
                if (!hostnameFile.getParentFile().exists() && !hostnameFile.getParentFile().mkdirs()) {
                    throw (Throwable)new TorCtlException("Could not create hostnameFile parent directory", null, 2, null);
                }
                if (!hostnameFile.exists() && !hostnameFile.createNewFile()) {
                    throw (Throwable)new TorCtlException("Could not create hostnameFile", null, 2, null);
                }
                if (!keyFile.exists() && !keyFile.createNewFile()) {
                    throw (Throwable)new TorCtlException("Could not create keyFile", null, 2, null);
                }
                try {
                    if (OsType.Companion.getCurrent().isUnixoid()) {
                        Set perms = SetsKt.mutableSetOf((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE});
                        Files.setPosixFilePermissions(hostnameFile.getParentFile().toPath(), perms);
                    }
                }
                catch (Exception e) {
                    KLogger kLogger = TorKt.getLogger();
                    if (kLogger == null) break block11;
                    kLogger.error("could not set permissions, hidden service " + hsDirName + " will most probably not work", (Throwable)e);
                }
            }
            FilesKt.appendText$default((File)hostnameFile, (String)(result.serviceID + ".onion"), null, (int)2, null);
            String string = result.privateKey;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result.privateKey");
            FilesKt.appendText$default((File)keyFile, (String)string, null, (int)2, null);
        }
        String hostname = result.serviceID + ".onion";
        this.activeHiddenServices.add(hostname);
        return new HsContainer(hostname, this.eventHandler);
    }

    public final void unpublishHiddenService(@NotNull String serviceName) throws TorCtlException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
        TorController torController = this.torController;
        if (torController == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"torController");
        }
        CharSequence charSequence = serviceName;
        Regex regex = new Regex("\\.onion$");
        String string = "";
        TorController torController2 = torController;
        boolean bl = false;
        String string2 = regex.replace(charSequence, string);
        torController2.destroyHiddenService(string2);
        this.activeHiddenServices.remove(serviceName);
    }

    public final boolean isHiddenServiceAvailable(@NotNull String onionUrl) {
        Intrinsics.checkParameterIsNotNull((Object)onionUrl, (String)"onionUrl");
        Control control = this.control;
        if (control == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"control");
        }
        return control.hsAvailable(onionUrl);
    }

    public abstract void shutdown();

    protected Tor() throws TorCtlException {
    }

    static {
        Companion = new Companion(null);
    }

    @Nullable
    public static final Tor getDefault() {
        Companion companion = Companion;
        return default;
    }

    public static final void setDefault(@Nullable Tor tor) {
        Companion companion = Companion;
        default = tor;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Socks5Proxy getProxy(int proxyPort, @Nullable String streamID) throws TorCtlException {
        return Companion.getProxy(proxyPort, streamID);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Socks5Proxy getProxy(int proxyPort) throws TorCtlException {
        return org.berndpruenster.netlayer.tor.Tor$Companion.getProxy$default(Companion, proxyPort, null, 2, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007R&\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/berndpruenster/netlayer/tor/Tor$Companion;", "", "()V", "default", "Lorg/berndpruenster/netlayer/tor/Tor;", "default$annotations", "getDefault", "()Lorg/berndpruenster/netlayer/tor/Tor;", "setDefault", "(Lorg/berndpruenster/netlayer/tor/Tor;)V", "clear", "", "clear$tor", "getProxy", "Lcom/runjva/sourceforge/jsocks/protocol/Socks5Proxy;", "proxyPort", "", "streamID", "", "tor"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void default$annotations() {
        }

        @Nullable
        public final Tor getDefault() {
            return default;
        }

        public final void setDefault(@Nullable Tor tor) {
            default = tor;
        }

        public final void clear$tor() {
            this.setDefault(null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Socks5Proxy getProxy(int proxyPort, @Nullable String streamID) throws TorCtlException {
            Socks5Proxy proxy;
            block3: {
                String authValue;
                proxy = null;
                try {
                    proxy = new Socks5Proxy("127.0.0.1", proxyPort);
                }
                catch (IOException e) {
                    throw (Throwable)new TorCtlException(null, (Throwable)e, 1, null);
                }
                proxy.resolveAddrLocally(false);
                String string = streamID;
                if (string == null) break block3;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                byte[] hash = null;
                String string3 = streamID;
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                Charset charset = Charsets.UTF_8;
                boolean bl4 = false;
                byte[] byArray = string3.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                byte[] byArray3 = messageDigest.digest(byArray2);
                String string4 = authValue = new BigInteger(byArray3).toString(26);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"authValue");
                string3 = string4;
                charset = Charsets.UTF_8;
                bl4 = false;
                String string5 = string3;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray4 = string5.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"(this as java.lang.String).getBytes(charset)");
                hash = byArray4;
                proxy.setAuthenticationMethod(2, new Authentication(authValue, hash){
                    final /* synthetic */ String $authValue;
                    final /* synthetic */ byte[] $hash;

                    @NotNull
                    public final Closeable[] doSocksAuthentication(int $noName_0, Socket proxySocket) {
                        KLogger kLogger = TorKt.getLogger();
                        if (kLogger != null) {
                            kLogger.debug("using Stream " + this.$authValue);
                        }
                        OutputStream out = proxySocket.getOutputStream();
                        out.write(new byte[]{(byte)1, (byte)this.$hash.length});
                        out.write(this.$hash);
                        out.write(new byte[]{(byte)1, (byte)0});
                        out.flush();
                        byte[] status = new byte[2];
                        proxySocket.getInputStream().read(status);
                        if (status[1] != (byte)0) {
                            throw (Throwable)new IOException("auth error: " + status[1]);
                        }
                        return new Closeable[]{proxySocket.getInputStream(), out};
                    }
                    {
                        this.$authValue = string;
                        this.$hash = byArray;
                    }
                });
            }
            return proxy;
        }

        public static /* synthetic */ Socks5Proxy getProxy$default(Companion companion, int n, String string, int n2, Object object) throws TorCtlException {
            if ((n2 & 2) != 0) {
                string = null;
            }
            return companion.getProxy(n, string);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Socks5Proxy getProxy(int proxyPort) throws TorCtlException {
            return org.berndpruenster.netlayer.tor.Tor$Companion.getProxy$default(this, proxyPort, null, 2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

