/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.berndpruenster.netlayer.tor.HiddenServiceSocketAddress;
import org.berndpruenster.netlayer.tor.HsContainer;
import org.berndpruenster.netlayer.tor.Tor;
import org.berndpruenster.netlayer.tor.TorCtlException;
import org.berndpruenster.netlayer.tor.TorEventHandler;
import org.berndpruenster.netlayer.tor.TorSocketsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ)\u0010\u001b\u001a\u00020\u00122!\u0010\u001c\u001a\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000eJ\b\u0010\u001d\u001a\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR/\u0010\f\u001a#\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u0007"}, d2={"Lorg/berndpruenster/netlayer/tor/HiddenServiceSocket;", "Ljava/net/ServerSocket;", "internalPort", "", "hiddenServiceDir", "", "hiddenServicePort", "tor", "Lorg/berndpruenster/netlayer/tor/Tor;", "(ILjava/lang/String;ILorg/berndpruenster/netlayer/tor/Tor;)V", "getHiddenServicePort", "()I", "listeners", "", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "socket", "", "mgr", "serviceName", "getServiceName", "()Ljava/lang/String;", "socketAddress", "Lorg/berndpruenster/netlayer/tor/HiddenServiceSocketAddress;", "getSocketAddress", "()Lorg/berndpruenster/netlayer/tor/HiddenServiceSocketAddress;", "addReadyListener", "listener", "close", "toString"})
public final class HiddenServiceSocket
extends ServerSocket {
    private final Tor mgr;
    private final List<Function1<HiddenServiceSocket, Unit>> listeners;
    @NotNull
    private final HiddenServiceSocketAddress socketAddress;
    @NotNull
    private final String serviceName;
    private final String hiddenServiceDir;
    private final int hiddenServicePort;

    @NotNull
    public final HiddenServiceSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    @NotNull
    public final String getServiceName() {
        return this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReadyListener(@NotNull Function1<? super HiddenServiceSocket, Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        List<Function1<HiddenServiceSocket, Unit>> list = this.listeners;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (list) {
            boolean bl3 = false;
            bl2 = this.listeners.add(listener);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return this.socketAddress.toString();
    }

    @Override
    public void close() {
        super.close();
        try {
            this.mgr.unpublishHiddenService(this.serviceName);
        }
        catch (TorCtlException e) {
            throw (Throwable)new IOException(e);
        }
    }

    public final int getHiddenServicePort() {
        return this.hiddenServicePort;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public HiddenServiceSocket(int internalPort, @NotNull String hiddenServiceDir, int hiddenServicePort, @Nullable Tor tor) {
        void name;
        List list;
        Intrinsics.checkParameterIsNotNull((Object)hiddenServiceDir, (String)"hiddenServiceDir");
        this.hiddenServiceDir = hiddenServiceDir;
        this.hiddenServicePort = hiddenServicePort;
        this.mgr = TorSocketsKt.access$getTorInstance(tor);
        HiddenServiceSocket hiddenServiceSocket = this;
        boolean bl = false;
        hiddenServiceSocket.listeners = list = (List)new ArrayList();
        HsContainer hsContainer = this.mgr.publishHiddenService(this.hiddenServiceDir, this.hiddenServicePort, internalPort);
        String string = hsContainer.component1();
        TorEventHandler handler = hsContainer.component2();
        this.serviceName = name;
        this.socketAddress = new HiddenServiceSocketAddress((String)name, this.hiddenServicePort);
        this.bind(new InetSocketAddress("127.0.0.1", internalPort));
        handler.attachReadyListeners(this, this.listeners);
    }

    public /* synthetic */ HiddenServiceSocket(int n, String string, int n2, Tor tor, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            string = "ephemeral hidden service";
        }
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        if ((n3 & 8) != 0) {
            tor = null;
        }
        this(n, string, n2, tor);
    }

    @JvmOverloads
    public HiddenServiceSocket(int internalPort, @NotNull String hiddenServiceDir, int hiddenServicePort) {
        this(internalPort, hiddenServiceDir, hiddenServicePort, null, 8, null);
    }

    @JvmOverloads
    public HiddenServiceSocket(int internalPort, @NotNull String hiddenServiceDir) {
        this(internalPort, hiddenServiceDir, 0, null, 12, null);
    }

    @JvmOverloads
    public HiddenServiceSocket(int internalPort) {
        this(internalPort, null, 0, null, 14, null);
    }
}

