/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import net.freehaven.tor.control.EventHandler;
import net.freehaven.tor.control.TorControlConnection;
import org.berndpruenster.netlayer.tor.FileUtilitiesKt;
import org.berndpruenster.netlayer.tor.OsType;
import org.berndpruenster.netlayer.tor.TorContext;
import org.berndpruenster.netlayer.tor.TorContext$WhenMappings;
import org.berndpruenster.netlayer.tor.TorController;
import org.berndpruenster.netlayer.tor.TorEventHandler;
import org.berndpruenster.netlayer.tor.TorKt;
import org.berndpruenster.netlayer.tor.Torrc;
import org.berndpruenster.netlayer.tor.WriteObserver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 82\u00020\u0001:\u00018B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0003H&J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000fH&J\u000e\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u000fJ\u0015\u0010*\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b+J\u0016\u0010,\u001a\u00020 2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0.H\u0004J\u001c\u0010/\u001a\u0002002\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0.2\u0006\u00101\u001a\u000202J\b\u00103\u001a\u00020 H\u0016J\u0015\u00104\u001a\u00020 2\u0006\u00105\u001a\u000206H\u0000\u00a2\u0006\u0002\b7R\u0014\u0010\u0007\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\tR\u0012\u0010\u0016\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0014\u0010\u0018\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\tR\u0012\u0010\u001a\u001a\u00020\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u0014\u0010\u001c\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\t\u00a8\u00069"}, d2={"Lorg/berndpruenster/netlayer/tor/TorContext;", "", "workingDirectory", "Ljava/io/File;", "overrides", "Lorg/berndpruenster/netlayer/tor/Torrc;", "(Ljava/io/File;Lorg/berndpruenster/netlayer/tor/Torrc;)V", "cookieFile", "getCookieFile$tor_native", "()Ljava/io/File;", "geoIpFile", "getGeoIpFile$tor_native", "geoIpv6File", "getGeoIpv6File$tor_native", "pathToRC", "", "getPathToRC", "()Ljava/lang/String;", "pathToTorExecutable", "getPathToTorExecutable", "pidFile", "getPidFile$tor_native", "processId", "getProcessId", "torExecutableFile", "getTorExecutableFile$tor_native", "torExecutableFileName", "getTorExecutableFileName", "torrcFile", "getTorrcFile$tor_native", "getWorkingDirectory", "deleteAllFilesButHS", "", "deleteAllFilesButHS$tor_native", "generateWriteObserver", "Lorg/berndpruenster/netlayer/tor/WriteObserver;", "file", "getByName", "Ljava/io/InputStream;", "fileName", "getHiddenServiceDirectory", "hsDir", "getHostNameFile", "getHostNameFile$tor_native", "installAndConfigureFiles", "bridgeConfig", "", "installAndStartTorOp", "Lorg/berndpruenster/netlayer/tor/TorController;", "eventHandler", "Lorg/berndpruenster/netlayer/tor/TorEventHandler;", "installFiles", "setEnvAndWD", "processBuilder", "Ljava/lang/ProcessBuilder;", "setEnvAndWD$tor_native", "Companion", "tor.native"})
public abstract class TorContext {
    @NotNull
    private final File pidFile;
    @NotNull
    private final File geoIpFile;
    @NotNull
    private final File geoIpv6File;
    @NotNull
    private final File torrcFile;
    @NotNull
    private final File cookieFile;
    @NotNull
    private final File workingDirectory;
    private final Torrc overrides;
    @NotNull
    private static final String FILE_TORRC_NATIVE = "torrc.native";
    private static final List<String> EVENTS;
    public static final Companion Companion;

    @NotNull
    protected abstract String getPathToTorExecutable();

    @NotNull
    public abstract String getPathToRC();

    @NotNull
    protected abstract String getTorExecutableFileName();

    @NotNull
    public abstract String getProcessId();

    @NotNull
    public final File getPidFile$tor_native() {
        return this.pidFile;
    }

    @NotNull
    public final File getGeoIpFile$tor_native() {
        return this.geoIpFile;
    }

    @NotNull
    public final File getGeoIpv6File$tor_native() {
        return this.geoIpv6File;
    }

    @NotNull
    public final File getTorrcFile$tor_native() {
        return this.torrcFile;
    }

    @NotNull
    public final File getTorExecutableFile$tor_native() {
        return new File(this.workingDirectory, this.getTorExecutableFileName());
    }

    @NotNull
    public final File getCookieFile$tor_native() {
        return this.cookieFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void installFiles() throws IOException {
        InputStream str2;
        File dotTorDir;
        Object object;
        int n = 0;
        int n2 = 3;
        while (n <= n2) {
            Process p;
            void i;
            Thread.sleep((long)1000 * ((long)i + 1L), 0);
            Process process = p = Runtime.getRuntime().exec(OsType.Companion.getCurrent().isUnixoid() ? "ps -few" : System.getenv("windir") + "\\system32\\" + "tasklist.exe /fo csv /nh");
            Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"p");
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"p.inputStream");
            Closeable closeable = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable2 = closeable;
            int n3 = 0;
            closeable2 = new InputStreamReader((InputStream)closeable2, charset);
            n3 = 8192;
            boolean bl2 = false;
            closeable = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n3);
            boolean bl3 = false;
            object = null;
            try {
                Object p1 = (BufferedReader)closeable;
                boolean bl4 = false;
                p1 = TextStreamsKt.readText((Reader)((Reader)p1));
            }
            catch (Throwable p1) {
                object = p1;
                throw p1;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            Object allText = p1;
            CharSequence charSequence = (CharSequence)allText;
            String string = this.getTorExecutableFile$tor_native().getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"torExecutableFile.absolutePath");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) break;
            if (2 == i && !OsType.Companion.getCurrent().isUnixoid()) {
                Runtime.getRuntime().exec("TASKKILL /F /IM " + this.getTorExecutableFile$tor_native().getAbsolutePath());
            }
            if (3 == i) {
                throw (Throwable)new IOException("Our tor binary is still in use... giving up");
            }
            ++i;
        }
        File[] fileArray = this.workingDirectory.listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            File[] fileArray2 = $this$forEach$iv;
            int n4 = fileArray2.length;
            for (int i = 0; i < n4; ++i) {
                File element$iv;
                File it = element$iv = fileArray2[i];
                boolean bl = false;
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                String string = file.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.absolutePath");
                String string2 = this.torrcFile.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"torrcFile.absolutePath");
                if (!StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) continue;
                it.delete();
            }
        }
        if ((dotTorDir = new File(this.workingDirectory, ".tor")).exists()) {
            FilesKt.deleteRecursively((File)dotTorDir);
        }
        if (!this.workingDirectory.exists() && !this.workingDirectory.mkdirs()) {
            throw (Throwable)new RuntimeException("Could not create root directory " + this.workingDirectory + '!');
        }
        Closeable closeable = this.getByName("geoip");
        boolean bl = false;
        Throwable throwable = null;
        try {
            str2 = (InputStream)closeable;
            boolean bl5 = false;
            FileUtilitiesKt.cleanInstallFile(str2, this.geoIpFile);
            str2 = Unit.INSTANCE;
        }
        catch (Throwable str2) {
            throwable = str2;
            throw str2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        closeable = this.getByName("geoip6");
        bl = false;
        throwable = null;
        try {
            str2 = (InputStream)closeable;
            boolean bl6 = false;
            FileUtilitiesKt.cleanInstallFile(str2, this.geoIpv6File);
            str2 = Unit.INSTANCE;
        }
        catch (Throwable str3) {
            throwable = str3;
            throw str3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        closeable = this.getByName("torrc");
        bl = false;
        throwable = null;
        try {
            str2 = (InputStream)closeable;
            boolean bl7 = false;
            object = new Torrc(str2, this.overrides).getInputStream$tor_native();
            boolean bl8 = false;
            Throwable throwable2 = null;
            try {
                InputStream rc = (InputStream)object;
                boolean bl9 = false;
                Closeable closeable3 = this.getByName("torrc.defaults");
                boolean bl10 = false;
                Throwable throwable3 = null;
                try {
                    InputStream it = (InputStream)closeable3;
                    boolean bl11 = false;
                    Closeable closeable4 = new Torrc(rc, it).getInputStream$tor_native();
                    boolean bl12 = false;
                    Throwable throwable4 = null;
                    try {
                        InputStream it2 = (InputStream)closeable4;
                        boolean bl13 = false;
                        FileUtilitiesKt.cleanInstallFile(it2, this.torrcFile);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable5) {
                        throwable4 = throwable5;
                        throw throwable5;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable4, (Throwable)throwable4);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable6) {
                    throwable3 = throwable6;
                    throw throwable6;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final void setEnvAndWD$tor_native(@NotNull ProcessBuilder processBuilder) {
        Intrinsics.checkParameterIsNotNull((Object)processBuilder, (String)"processBuilder");
        processBuilder.directory(this.workingDirectory);
        Map<String, String> environment = processBuilder.environment();
        environment.put("HOME", this.workingDirectory.getAbsolutePath());
        switch (TorContext$WhenMappings.$EnumSwitchMapping$0[OsType.Companion.getCurrent().ordinal()]) {
            case 1: 
            case 2: {
                environment.put("LD_LIBRARY_PATH", this.workingDirectory.getAbsolutePath());
            }
        }
    }

    @NotNull
    public final File getHostNameFile$tor_native(@NotNull String hsDir) {
        Intrinsics.checkParameterIsNotNull((Object)hsDir, (String)"hsDir");
        return new File(this.getHiddenServiceDirectory(hsDir).getCanonicalPath() + "/" + "hostname");
    }

    public final void deleteAllFilesButHS$tor_native() {
        Thread.sleep(1000L);
        File[] fileArray = this.workingDirectory.listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            File[] fileArray2 = $this$forEach$iv;
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File it = element$iv = fileArray2[i];
                boolean bl = false;
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                if (file.isDirectory()) {
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"hiddenservice") ^ true)) continue;
                    FilesKt.deleteRecursively((File)it);
                    continue;
                }
                if (it.delete()) continue;
                throw (Throwable)new RuntimeException("Could not delete file " + it.getAbsolutePath());
            }
        }
    }

    @NotNull
    public abstract WriteObserver generateWriteObserver(@NotNull File var1);

    @NotNull
    public abstract InputStream getByName(@NotNull String var1);

    @NotNull
    public final File getHiddenServiceDirectory(@NotNull String hsDir) {
        Intrinsics.checkParameterIsNotNull((Object)hsDir, (String)"hsDir");
        return new File(this.workingDirectory, "/hiddenservice/" + hsDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final TorController installAndStartTorOp(@NotNull List<String> bridgeConfig, @NotNull TorEventHandler eventHandler) throws IOException {
        Intrinsics.checkParameterIsNotNull(bridgeConfig, (String)"bridgeConfig");
        Intrinsics.checkParameterIsNotNull((Object)eventHandler, (String)"eventHandler");
        this.installAndConfigureFiles(bridgeConfig);
        KLogger kLogger = TorKt.getLogger();
        if (kLogger != null) {
            kLogger.info("Starting Tor");
        }
        File cookieFile = this.cookieFile;
        if (!cookieFile.getParentFile().exists() && !cookieFile.getParentFile().mkdirs()) {
            throw (Throwable)new RuntimeException("Could not create cookieFile parent directory");
        }
        if (!cookieFile.exists() && !cookieFile.createNewFile()) {
            throw (Throwable)new RuntimeException("Could not create cookieFile");
        }
        File workingDirectory = this.workingDirectory;
        WriteObserver cookieObserver = this.generateWriteObserver(cookieFile);
        String torPath = this.getTorExecutableFile$tor_native().getAbsolutePath();
        String configPath = this.torrcFile.getAbsolutePath();
        String pid = this.getProcessId();
        Object[] objectArray = new String[5];
        String string = torPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"torPath");
        objectArray[0] = string;
        objectArray[1] = "-f";
        String string2 = configPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"configPath");
        objectArray[2] = string2;
        objectArray[3] = "__OwningControllerProcess";
        objectArray[4] = pid;
        List cmd = CollectionsKt.listOf((Object[])objectArray);
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        this.setEnvAndWD$tor_native(processBuilder);
        Process torProcess = null;
        TorControlConnection ctrlCon = null;
        try {
            torProcess = processBuilder.start();
            CountDownLatch controlPortCountDownLatch = new CountDownLatch(1);
            AtomicReference port = new AtomicReference();
            Process process = torProcess;
            Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"torProcess");
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"torProcess.inputStream");
            TorContext.Companion.parseBootstrap(inputStream, controlPortCountDownLatch, port);
            InputStream inputStream2 = torProcess.getErrorStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream2, (String)"torProcess.errorStream");
            TorContext.Companion.forwardErr(inputStream2);
            if (OsType.Companion.getCurrent() != OsType.WIN) {
                int exit = torProcess.waitFor();
                torProcess = null;
                if (exit != 0) {
                    throw (Throwable)new IOException("Tor exited with value " + exit);
                }
            }
            if (!cookieObserver.poll(10000, TimeUnit.MILLISECONDS)) {
                FileUtilitiesKt.log(workingDirectory);
                throw (Throwable)new IOException("Auth cookie not created");
            }
            controlPortCountDownLatch.await();
            Object v = port.get();
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"port.get()");
            Socket sock = new Socket("127.0.0.1", ((Number)v).intValue());
            ctrlCon = (TorControlConnection)new TorController(sock);
            byte[] cookie = null;
            while (true) {
                try {
                    cookie = FilesKt.readBytes((File)cookieFile);
                }
                catch (Exception e) {
                    Thread.sleep(50L);
                    Thread.yield();
                    continue;
                }
                break;
            }
            ctrlCon.authenticate(cookie);
            ctrlCon.takeOwnership();
            ctrlCon.resetConf((Collection)CollectionsKt.listOf((Object)"__OwningControllerProcess"));
            ctrlCon.setEventHandler((EventHandler)eventHandler);
            ctrlCon.setEvents(EVENTS);
            TorController torController = (TorController)ctrlCon;
            return torController;
        }
        catch (Exception e) {
            try {
                throw (Throwable)new IOException(e);
            }
            catch (Throwable throwable) {
                block14: {
                    if (ctrlCon != null) break block14;
                    Process process = torProcess;
                    if (process != null) {
                        process.destroy();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void installAndConfigureFiles(@NotNull List<String> bridgeConfig) throws IOException, InterruptedException {
        Intrinsics.checkParameterIsNotNull(bridgeConfig, (String)"bridgeConfig");
        this.installFiles();
        Closeable closeable = new FileWriter(this.torrcFile, true);
        int n = 8192;
        boolean bl = false;
        BufferedWriter bufferedWriter = closeable instanceof BufferedWriter ? (BufferedWriter)closeable : new BufferedWriter((Writer)closeable, n);
        Writer writer = bufferedWriter;
        closeable = new PrintWriter(writer);
        n = 0;
        Throwable throwable = null;
        try {
            PrintWriter confWriter = (PrintWriter)closeable;
            boolean bl2 = false;
            confWriter.println();
            confWriter.println("CookieAuthFile " + this.cookieFile.getAbsolutePath());
            confWriter.println("DataDirectory " + this.workingDirectory.getAbsolutePath());
            confWriter.println("GeoIPFile " + this.geoIpFile.getAbsolutePath());
            confWriter.println("PidFile " + this.pidFile.getAbsolutePath());
            confWriter.println("GeoIPv6File " + this.geoIpv6File.getAbsolutePath());
            Closeable closeable2 = this.getByName(this.getPathToRC());
            Charset charset = Charsets.UTF_8;
            boolean bl3 = false;
            closeable2 = new InputStreamReader((InputStream)closeable2, charset);
            int n2 = 8192;
            bl3 = false;
            closeable2 = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n2);
            n2 = 0;
            Object object = null;
            try {
                BufferedReader reader = (BufferedReader)closeable2;
                boolean bl4 = false;
                confWriter.println();
                TextStreamsKt.forEachLine((Reader)reader, (Function1)((Function1)new Function1<String, Unit>(confWriter){
                    final /* synthetic */ PrintWriter $confWriter$inlined;
                    {
                        this.$confWriter$inlined = printWriter;
                        super(1);
                    }

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$confWriter$inlined.println(it);
                    }
                }));
                reader = Unit.INSTANCE;
            }
            catch (Throwable reader) {
                object = reader;
                throw reader;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
            }
            if (!bridgeConfig.isEmpty()) {
                confWriter.println();
                confWriter.println("UseBridges 1");
            }
            Iterable $this$forEach$iv = bridgeConfig;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl5 = false;
                confWriter.print("Bridge ");
                confWriter.println(it);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public final File getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected TorContext(@NotNull File workingDirectory, @Nullable Torrc overrides) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)workingDirectory, (String)"workingDirectory");
        this.workingDirectory = workingDirectory;
        this.overrides = overrides;
        this.pidFile = new File(this.workingDirectory, "pid");
        this.geoIpFile = new File(this.workingDirectory, "geoip");
        this.geoIpv6File = new File(this.workingDirectory, "geoip6");
        this.torrcFile = new File(this.workingDirectory, "torrc");
        this.cookieFile = new File(this.workingDirectory, ".tor/control_auth_cookie");
    }

    static {
        Companion = new Companion(null);
        FILE_TORRC_NATIVE = FILE_TORRC_NATIVE;
        EVENTS = CollectionsKt.listOf((Object[])new String[]{"CIRC", "WARN", "ERR"});
    }

    @NotNull
    protected static final String getFILE_TORRC_NATIVE() {
        Companion companion = Companion;
        return FILE_TORRC_NATIVE;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u001c\u0010\u0007\u001a\u00020\u00058\u0004X\u0085D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/berndpruenster/netlayer/tor/TorContext$Companion;", "", "()V", "EVENTS", "", "", "EVENTS$annotations", "FILE_TORRC_NATIVE", "FILE_TORRC_NATIVE$annotations", "getFILE_TORRC_NATIVE", "()Ljava/lang/String;", "forwardErr", "", "inputStream", "Ljava/io/InputStream;", "parseBootstrap", "latch", "Ljava/util/concurrent/CountDownLatch;", "port", "Ljava/util/concurrent/atomic/AtomicReference;", "", "tor.native"})
    public static final class Companion {
        @JvmStatic
        protected static /* synthetic */ void FILE_TORRC_NATIVE$annotations() {
        }

        @NotNull
        protected final String getFILE_TORRC_NATIVE() {
            return FILE_TORRC_NATIVE;
        }

        @JvmStatic
        private static /* synthetic */ void EVENTS$annotations() {
        }

        private final void parseBootstrap(InputStream inputStream, CountDownLatch latch, AtomicReference<Integer> port) {
            new Thread(new Runnable(inputStream, port, latch){
                final /* synthetic */ InputStream $inputStream;
                final /* synthetic */ AtomicReference $port;
                final /* synthetic */ CountDownLatch $latch;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    Thread thread = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                    thread.setName("NFO");
                    Closeable closeable = this.$inputStream;
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)closeable, charset);
                    Reader reader = inputStreamReader;
                    closeable = new BufferedReader(reader);
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        BufferedReader reader2 = (BufferedReader)closeable;
                        boolean bl3 = false;
                        TextStreamsKt.forEachLine((Reader)reader2, (Function1)((Function1)new Function1<String, Unit>(this){
                            final /* synthetic */ parseBootstrap.1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull String it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                KLogger kLogger = TorKt.getLogger();
                                if (kLogger != null) {
                                    kLogger.debug((Function0)new Function0<String>(it){
                                        final /* synthetic */ String $it;
                                        {
                                            this.$it = string;
                                            super(0);
                                        }

                                        @NotNull
                                        public final String invoke() {
                                            return this.$it;
                                        }
                                    });
                                }
                                if (StringsKt.contains$default((CharSequence)it, (CharSequence)"Control listener listening on port ", (boolean)false, (int)2, null)) {
                                    String string = it;
                                    int n = StringsKt.lastIndexOf$default((CharSequence)it, (String)" ", (int)0, (boolean)false, (int)6, null) + 1;
                                    int n2 = it.length() - 1;
                                    AtomicReference atomicReference = this.this$0.$port;
                                    boolean bl = false;
                                    String string2 = string.substring(n, n2);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    String string3 = string2;
                                    atomicReference.set(Integer.parseInt(string3));
                                    this.this$0.$latch.countDown();
                                }
                            }
                        }));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                {
                    this.$inputStream = inputStream;
                    this.$port = atomicReference;
                    this.$latch = countDownLatch;
                }
            }).start();
        }

        private final void forwardErr(InputStream inputStream) {
            new Thread(new Runnable(inputStream){
                final /* synthetic */ InputStream $inputStream;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    Thread thread = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                    thread.setName("ERR");
                    Closeable closeable = this.$inputStream;
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)closeable, charset);
                    Reader reader = inputStreamReader;
                    closeable = new BufferedReader(reader);
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        BufferedReader reader2 = (BufferedReader)closeable;
                        boolean bl3 = false;
                        TextStreamsKt.forEachLine((Reader)reader2, (Function1)forwardErr.1.1.INSTANCE);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                {
                    this.$inputStream = inputStream;
                }
            }).start();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

