/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.berndpruenster.netlayer.tor.OsType;
import org.berndpruenster.netlayer.tor.TorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0003\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\u0005H\u0000\u00a8\u0006\n"}, d2={"cleanInstallFile", "", "src", "Ljava/io/InputStream;", "dst", "Ljava/io/File;", "extractContentFromArchive", "destinationDirectory", "archiveInputStream", "log", "tor.native"})
public final class FileUtilitiesKt {
    public static final void log(@NotNull File $this$log) {
        block2: {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)$this$log, (String)"$this$log");
                if (!$this$log.isDirectory()) break block1;
                File[] fileArray = $this$log.listFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"listFiles()");
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                File[] fileArray2 = $this$forEach$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File it = element$iv = fileArray2[i];
                    boolean bl = false;
                    File file = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                    FileUtilitiesKt.log(file);
                }
                break block2;
            }
            KLogger kLogger = TorKt.getLogger();
            if (kLogger == null) break block2;
            kLogger.info($this$log.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void cleanInstallFile(@NotNull InputStream src, @NotNull File dst) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        try {
            if (dst.exists() && !dst.delete()) {
                throw (Throwable)new IOException("Could not remove existing file " + dst.getName());
            }
            Object object = dst;
            int n = 0;
            object = new FileOutputStream((File)object);
            n = 8192;
            boolean bl = false;
            object = object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n);
            n = 0;
            Throwable throwable = null;
            try {
                BufferedOutputStream out = (BufferedOutputStream)object;
                boolean bl2 = false;
                long l = ByteStreamsKt.copyTo$default((InputStream)src, (OutputStream)out, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw (Throwable)new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void extractContentFromArchive(@NotNull File destinationDirectory, @NotNull InputStream archiveInputStream) {
        Intrinsics.checkParameterIsNotNull((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkParameterIsNotNull((Object)archiveInputStream, (String)"archiveInputStream");
        Closeable closeable = (Closeable)new TarArchiveInputStream((InputStream)new XZCompressorInputStream(archiveInputStream));
        boolean bl = false;
        Throwable throwable = null;
        try {
            TarArchiveInputStream tarIn = (TarArchiveInputStream)closeable;
            boolean bl2 = false;
            ArchiveEntry entry = tarIn.getNextEntry();
            while (entry != null) {
                StringBuilder stringBuilder = new StringBuilder().append(destinationDirectory.getCanonicalPath()).append(File.separator);
                String string = entry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.name");
                File f = new File(stringBuilder.append(StringsKt.replace$default((String)string, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null)).toString());
                if (entry.isDirectory()) {
                    if (!f.exists() && !f.mkdirs()) {
                        throw (Throwable)new IOException("could not create directory " + f);
                    }
                } else {
                    if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
                        throw (Throwable)new IOException("could not create directory  " + f.getParentFile());
                    }
                    if (f.exists() && !f.delete()) {
                        throw (Throwable)new RuntimeException("Could not delete file " + f.getAbsolutePath() + " in preparation for overwriting it");
                    }
                    if (!f.createNewFile()) {
                        throw (Throwable)new RuntimeException("Could not create file " + f);
                    }
                    Closeable closeable2 = new FileOutputStream(f);
                    boolean bl3 = false;
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream outStream = (FileOutputStream)closeable2;
                        boolean bl4 = false;
                        ByteStreamsKt.copyTo$default((InputStream)((InputStream)tarIn), (OutputStream)outStream, (int)0, (int)2, null);
                        ArchiveEntry archiveEntry = entry;
                        if (archiveEntry == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.apache.commons.compress.archivers.tar.TarArchiveEntry");
                        }
                        int mode = ((TarArchiveEntry)archiveEntry).getMode();
                        if ((mode & 0x41) > 0) {
                            f.setExecutable(true, (mode & 1) == 0);
                        }
                        if (OsType.Companion.getCurrent() == OsType.MACOS) {
                            f.setExecutable(true, true);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                entry = (ArchiveEntry)tarIn.getNextTarEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

