/*
 * Decompiled with CFR 0.152.
 */
package net.freehaven.tor.control;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import net.freehaven.tor.control.Bytes;

public class PasswordDigest {
    private final byte[] secret;
    private final String hashedKey;
    private static final int EXPBIAS = 6;

    public static PasswordDigest generateDigest() {
        byte[] secret = new byte[20];
        SecureRandom rng = new SecureRandom();
        rng.nextBytes(secret);
        return new PasswordDigest(secret);
    }

    public PasswordDigest(byte[] secret) {
        this(secret, null);
    }

    public PasswordDigest(byte[] secret, byte[] specifier) {
        this.secret = (byte[])secret.clone();
        if (specifier == null) {
            specifier = new byte[9];
            SecureRandom rng = new SecureRandom();
            rng.nextBytes(specifier);
            specifier[8] = 96;
        }
        this.hashedKey = "16:" + PasswordDigest.encodeBytes(PasswordDigest.secretToKey(secret, specifier));
    }

    public byte[] getSecret() {
        return (byte[])this.secret.clone();
    }

    public String getHashedPassword() {
        return this.hashedKey;
    }

    public static byte[] secretToKey(byte[] secret, byte[] specifier) {
        MessageDigest d;
        try {
            d = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("Can't run without sha-1.");
        }
        int c = specifier[8] & 0xFF;
        int count = 16 + (c & 0xF) << (c >> 4) + 6;
        byte[] tmp = new byte[8 + secret.length];
        System.arraycopy(specifier, 0, tmp, 0, 8);
        System.arraycopy(secret, 0, tmp, 8, secret.length);
        while (count > 0) {
            if (count >= tmp.length) {
                d.update(tmp);
                count -= tmp.length;
                continue;
            }
            d.update(tmp, 0, count);
            count = 0;
        }
        byte[] key = new byte[29];
        System.arraycopy(d.digest(), 0, key, 9, 20);
        System.arraycopy(specifier, 0, key, 0, 9);
        return key;
    }

    private static final String encodeBytes(byte[] ba) {
        return Bytes.hex(ba);
    }
}

