/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.qrcode.zxing;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.AttributeSet;
import cn.bingoogolapple.qrcode.core.BGAQRCodeUtil;
import cn.bingoogolapple.qrcode.core.BarcodeType;
import cn.bingoogolapple.qrcode.core.QRCodeView;
import cn.bingoogolapple.qrcode.core.ScanResult;
import cn.bingoogolapple.qrcode.zxing.QRCodeDecoder;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import java.util.Map;

public class ZXingView
extends QRCodeView {
    private MultiFormatReader mMultiFormatReader;
    private Map<DecodeHintType, Object> mHintMap;

    public ZXingView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ZXingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void setupReader() {
        this.mMultiFormatReader = new MultiFormatReader();
        if (this.mBarcodeType == BarcodeType.ONE_DIMENSION) {
            this.mMultiFormatReader.setHints(QRCodeDecoder.ONE_DIMENSION_HINT_MAP);
        } else if (this.mBarcodeType == BarcodeType.TWO_DIMENSION) {
            this.mMultiFormatReader.setHints(QRCodeDecoder.TWO_DIMENSION_HINT_MAP);
        } else if (this.mBarcodeType == BarcodeType.ONLY_QR_CODE) {
            this.mMultiFormatReader.setHints(QRCodeDecoder.QR_CODE_HINT_MAP);
        } else if (this.mBarcodeType == BarcodeType.ONLY_CODE_128) {
            this.mMultiFormatReader.setHints(QRCodeDecoder.CODE_128_HINT_MAP);
        } else if (this.mBarcodeType == BarcodeType.ONLY_EAN_13) {
            this.mMultiFormatReader.setHints(QRCodeDecoder.EAN_13_HINT_MAP);
        } else if (this.mBarcodeType == BarcodeType.HIGH_FREQUENCY) {
            this.mMultiFormatReader.setHints(QRCodeDecoder.HIGH_FREQUENCY_HINT_MAP);
        } else if (this.mBarcodeType == BarcodeType.CUSTOM) {
            this.mMultiFormatReader.setHints(this.mHintMap);
        } else {
            this.mMultiFormatReader.setHints(QRCodeDecoder.ALL_HINT_MAP);
        }
    }

    public void setType(BarcodeType barcodeType, Map<DecodeHintType, Object> hintMap) {
        this.mBarcodeType = barcodeType;
        this.mHintMap = hintMap;
        if (this.mBarcodeType == BarcodeType.CUSTOM && (this.mHintMap == null || this.mHintMap.isEmpty())) {
            throw new RuntimeException("barcodeType \u4e3a BarcodeType.CUSTOM \u65f6 hintMap \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.setupReader();
    }

    protected ScanResult processBitmapData(Bitmap bitmap) {
        return new ScanResult(QRCodeDecoder.syncDecodeQRCode(bitmap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScanResult processData(byte[] data, int width, int height, boolean isRetry) {
        Result rawResult = null;
        Rect scanBoxAreaRect = null;
        try {
            scanBoxAreaRect = this.mScanBoxView.getScanBoxAreaRect(height);
            PlanarYUVLuminanceSource source = scanBoxAreaRect != null ? new PlanarYUVLuminanceSource(data, width, height, scanBoxAreaRect.left, scanBoxAreaRect.top, scanBoxAreaRect.width(), scanBoxAreaRect.height(), false) : new PlanarYUVLuminanceSource(data, width, height, 0, 0, width, height, false);
            rawResult = this.mMultiFormatReader.decodeWithState(new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source)));
            if (rawResult == null && (rawResult = this.mMultiFormatReader.decodeWithState(new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source)))) != null) {
                BGAQRCodeUtil.d((String)"GlobalHistogramBinarizer \u6ca1\u8bc6\u522b\u5230\uff0cHybridBinarizer \u80fd\u8bc6\u522b\u5230");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.mMultiFormatReader.reset();
        }
        if (rawResult == null) {
            return null;
        }
        String result = rawResult.getText();
        if (TextUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        BarcodeFormat barcodeFormat = rawResult.getBarcodeFormat();
        BGAQRCodeUtil.d((String)("\u683c\u5f0f\u4e3a\uff1a" + barcodeFormat.name()));
        boolean isNeedAutoZoom = this.isNeedAutoZoom(barcodeFormat);
        if (this.isShowLocationPoint() || isNeedAutoZoom) {
            ResultPoint[] resultPoints = rawResult.getResultPoints();
            PointF[] pointArr = new PointF[resultPoints.length];
            int pointIndex = 0;
            for (ResultPoint resultPoint : resultPoints) {
                pointArr[pointIndex] = new PointF(resultPoint.getX(), resultPoint.getY());
                ++pointIndex;
            }
            if (this.transformToViewCoordinates(pointArr, scanBoxAreaRect, isNeedAutoZoom, result)) {
                return null;
            }
        }
        return new ScanResult(result);
    }

    private boolean isNeedAutoZoom(BarcodeFormat barcodeFormat) {
        return this.isAutoZoom() && barcodeFormat == BarcodeFormat.QR_CODE;
    }
}

