/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.qrcode.zxing;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class QRCodeEncoder {
    public static final Map<EncodeHintType, Object> HINTS = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);

    private QRCodeEncoder() {
    }

    public static Bitmap syncEncodeQRCode(String content, int size) {
        return QRCodeEncoder.syncEncodeQRCode(content, size, -16777216, -1, null);
    }

    public static Bitmap syncEncodeQRCode(String content, int size, int foregroundColor) {
        return QRCodeEncoder.syncEncodeQRCode(content, size, foregroundColor, -1, null);
    }

    public static Bitmap syncEncodeQRCode(String content, int size, int foregroundColor, Bitmap logo) {
        return QRCodeEncoder.syncEncodeQRCode(content, size, foregroundColor, -1, logo);
    }

    public static Bitmap syncEncodeQRCode(String content, int size, int foregroundColor, int backgroundColor, Bitmap logo) {
        try {
            BitMatrix matrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, size, size, HINTS);
            int[] pixels = new int[size * size];
            for (int y = 0; y < size; ++y) {
                for (int x = 0; x < size; ++x) {
                    pixels[y * size + x] = matrix.get(x, y) ? foregroundColor : backgroundColor;
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, size, 0, 0, size, size);
            return QRCodeEncoder.addLogoToQRCode(bitmap, logo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Bitmap addLogoToQRCode(Bitmap src, Bitmap logo) {
        if (src == null || logo == null) {
            return src;
        }
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int logoWidth = logo.getWidth();
        int logoHeight = logo.getHeight();
        float scaleFactor = (float)srcWidth * 1.0f / 5.0f / (float)logoWidth;
        Bitmap bitmap = Bitmap.createBitmap((int)srcWidth, (int)srcHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        try {
            Canvas canvas = new Canvas(bitmap);
            canvas.drawBitmap(src, 0.0f, 0.0f, null);
            canvas.scale(scaleFactor, scaleFactor, (float)(srcWidth / 2), (float)(srcHeight / 2));
            canvas.drawBitmap(logo, (float)((srcWidth - logoWidth) / 2), (float)((srcHeight - logoHeight) / 2), null);
            canvas.save();
            canvas.restore();
        }
        catch (Exception e) {
            e.printStackTrace();
            bitmap = null;
        }
        return bitmap;
    }

    public static Bitmap syncEncodeBarcode(String content, int width, int height, int textSize) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.MARGIN, 0);
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.CODE_128, width, height, hints);
            int[] pixels = new int[width * height];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    pixels[y * width + x] = bitMatrix.get(x, y) ? -16777216 : -1;
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
            if (textSize > 0) {
                bitmap = QRCodeEncoder.showContent(bitmap, content, textSize);
            }
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Bitmap showContent(Bitmap barcodeBitmap, String content, int textSize) {
        if (TextUtils.isEmpty((CharSequence)content) || null == barcodeBitmap) {
            return null;
        }
        Paint paint = new Paint();
        paint.setColor(-16777216);
        paint.setAntiAlias(true);
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize((float)textSize);
        paint.setTextAlign(Paint.Align.CENTER);
        int textWidth = (int)paint.measureText(content);
        Paint.FontMetrics fm = paint.getFontMetrics();
        int textHeight = (int)(fm.bottom - fm.top);
        float scaleRateX = (float)barcodeBitmap.getWidth() * 1.0f / (float)textWidth;
        if (scaleRateX < 1.0f) {
            paint.setTextScaleX(scaleRateX);
        }
        int baseLine = barcodeBitmap.getHeight() + textHeight;
        Bitmap bitmap = Bitmap.createBitmap((int)barcodeBitmap.getWidth(), (int)(barcodeBitmap.getHeight() + 2 * textHeight), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas();
        canvas.drawColor(-1);
        canvas.setBitmap(bitmap);
        canvas.drawBitmap(barcodeBitmap, 0.0f, 0.0f, null);
        canvas.drawText(content, (float)(barcodeBitmap.getWidth() / 2), (float)baseLine, paint);
        canvas.save();
        canvas.restore();
        return bitmap;
    }

    static {
        HINTS.put(EncodeHintType.CHARACTER_SET, "utf-8");
        HINTS.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        HINTS.put(EncodeHintType.MARGIN, 0);
    }
}

