/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.qrcode.zxing;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.util.EnumMap;
import java.util.Map;

public class QRCodeEncoder {
    public static final Map<EncodeHintType, Object> HINTS = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);

    private QRCodeEncoder() {
    }

    public static Bitmap syncEncodeQRCode(String content, int size) {
        return QRCodeEncoder.syncEncodeQRCode(content, size, -16777216, -1, null);
    }

    public static Bitmap syncEncodeQRCode(String content, int size, int foregroundColor) {
        return QRCodeEncoder.syncEncodeQRCode(content, size, foregroundColor, -1, null);
    }

    public static Bitmap syncEncodeQRCode(String content, int size, int foregroundColor, Bitmap logo) {
        return QRCodeEncoder.syncEncodeQRCode(content, size, foregroundColor, -1, logo);
    }

    public static Bitmap syncEncodeQRCode(String content, int size, int foregroundColor, int backgroundColor, Bitmap logo) {
        try {
            BitMatrix matrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, size, size, HINTS);
            int[] pixels = new int[size * size];
            for (int y = 0; y < size; ++y) {
                for (int x = 0; x < size; ++x) {
                    pixels[y * size + x] = matrix.get(x, y) ? foregroundColor : backgroundColor;
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, size, 0, 0, size, size);
            return QRCodeEncoder.addLogoToQRCode(bitmap, logo);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Bitmap addLogoToQRCode(Bitmap src, Bitmap logo) {
        if (src == null || logo == null) {
            return src;
        }
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        int logoWidth = logo.getWidth();
        int logoHeight = logo.getHeight();
        float scaleFactor = (float)srcWidth * 1.0f / 5.0f / (float)logoWidth;
        Bitmap bitmap = Bitmap.createBitmap((int)srcWidth, (int)srcHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        try {
            Canvas canvas = new Canvas(bitmap);
            canvas.drawBitmap(src, 0.0f, 0.0f, null);
            canvas.scale(scaleFactor, scaleFactor, (float)(srcWidth / 2), (float)(srcHeight / 2));
            canvas.drawBitmap(logo, (float)((srcWidth - logoWidth) / 2), (float)((srcHeight - logoHeight) / 2), null);
            canvas.save(31);
            canvas.restore();
        }
        catch (Exception e) {
            bitmap = null;
        }
        return bitmap;
    }

    static {
        HINTS.put(EncodeHintType.CHARACTER_SET, "utf-8");
        HINTS.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        HINTS.put(EncodeHintType.MARGIN, 0);
    }
}

