/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.qrcode.zbar;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import cn.bingoogolapple.qrcode.core.BarcodeType;
import cn.bingoogolapple.qrcode.core.QRCodeView;
import cn.bingoogolapple.qrcode.core.ScanResult;
import cn.bingoogolapple.qrcode.zbar.BarcodeFormat;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.zbar.Image;
import net.sourceforge.zbar.ImageScanner;
import net.sourceforge.zbar.Symbol;

public class ZBarView
extends QRCodeView {
    private ImageScanner mScanner;
    private List<BarcodeFormat> mFormatList;

    public ZBarView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ZBarView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupReader();
    }

    protected void setupReader() {
        this.mScanner = new ImageScanner();
        this.mScanner.setConfig(0, 256, 3);
        this.mScanner.setConfig(0, 257, 3);
        this.mScanner.setConfig(0, 0, 0);
        for (BarcodeFormat format : this.getFormats()) {
            this.mScanner.setConfig(format.getId(), 0, 1);
        }
    }

    public Collection<BarcodeFormat> getFormats() {
        if (this.mBarcodeType == BarcodeType.ONE_DIMENSION) {
            return BarcodeFormat.ONE_DIMENSION_FORMAT_LIST;
        }
        if (this.mBarcodeType == BarcodeType.TWO_DIMENSION) {
            return BarcodeFormat.TWO_DIMENSION_FORMAT_LIST;
        }
        if (this.mBarcodeType == BarcodeType.ONLY_QR_CODE) {
            return Collections.singletonList(BarcodeFormat.QRCODE);
        }
        if (this.mBarcodeType == BarcodeType.ONLY_CODE_128) {
            return Collections.singletonList(BarcodeFormat.CODE128);
        }
        if (this.mBarcodeType == BarcodeType.ONLY_EAN_13) {
            return Collections.singletonList(BarcodeFormat.EAN13);
        }
        if (this.mBarcodeType == BarcodeType.HIGH_FREQUENCY) {
            return BarcodeFormat.HIGH_FREQUENCY_FORMAT_LIST;
        }
        if (this.mBarcodeType == BarcodeType.CUSTOM) {
            return this.mFormatList;
        }
        return BarcodeFormat.ALL_FORMAT_LIST;
    }

    public void setType(BarcodeType barcodeType, List<BarcodeFormat> formatList) {
        this.mBarcodeType = barcodeType;
        this.mFormatList = formatList;
        if (this.mBarcodeType == BarcodeType.CUSTOM && (this.mFormatList == null || this.mFormatList.isEmpty())) {
            throw new RuntimeException("barcodeType \u4e3a BarcodeType.CUSTOM \u65f6 formatList \u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.setupReader();
    }

    protected ScanResult processData(byte[] data, int width, int height, boolean isRetry) {
        Image barcode = new Image(width, height, "Y800");
        Rect scanBoxAreaRect = this.mScanBoxView.getScanBoxAreaRect(height);
        if (scanBoxAreaRect != null && !isRetry && scanBoxAreaRect.left + scanBoxAreaRect.width() <= width && scanBoxAreaRect.top + scanBoxAreaRect.height() <= height) {
            barcode.setCrop(scanBoxAreaRect.left, scanBoxAreaRect.top, scanBoxAreaRect.width(), scanBoxAreaRect.height());
        }
        barcode.setData(data);
        String result = this.processData(barcode);
        return new ScanResult(result);
    }

    private String processData(Image barcode) {
        if (this.mScanner.scanImage(barcode) == 0) {
            return null;
        }
        for (Symbol symbol : this.mScanner.getResults()) {
            String symData;
            if (symbol.getType() == 0 || TextUtils.isEmpty((CharSequence)(symData = Build.VERSION.SDK_INT >= 19 ? new String(symbol.getDataBytes(), StandardCharsets.UTF_8) : symbol.getData()))) continue;
            boolean isNeedAutoZoom = this.isNeedAutoZoom(symbol);
            if (this.isShowLocationPoint() || isNeedAutoZoom) {
                if (this.transformToViewCoordinates(symbol.getLocationPoints(), null, isNeedAutoZoom, symData)) {
                    return null;
                }
                return symData;
            }
            return symData;
        }
        return null;
    }

    private boolean isNeedAutoZoom(Symbol symbol) {
        return this.isAutoZoom() && symbol.getType() == 64;
    }

    protected ScanResult processBitmapData(Bitmap bitmap) {
        try {
            int picWidth = bitmap.getWidth();
            int picHeight = bitmap.getHeight();
            Image barcode = new Image(picWidth, picHeight, "RGB4");
            int[] pix = new int[picWidth * picHeight];
            bitmap.getPixels(pix, 0, picWidth, 0, 0, picWidth, picHeight);
            barcode.setData(pix);
            String result = this.processData(barcode.convert("Y800"));
            return new ScanResult(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        System.loadLibrary("iconv");
    }
}

