/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.bgabanner.transformer;

import android.view.View;
import androidx.core.view.ViewCompat;
import cn.bingoogolapple.bgabanner.transformer.BGAPageTransformer;

public class DepthPageTransformer
extends BGAPageTransformer {
    private float mMinScale = 0.8f;

    public DepthPageTransformer() {
    }

    public DepthPageTransformer(float minScale) {
        this.setMinScale(minScale);
    }

    @Override
    public void handleInvisiblePage(View view, float position) {
        ViewCompat.setAlpha((View)view, (float)0.0f);
    }

    @Override
    public void handleLeftPage(View view, float position) {
        ViewCompat.setAlpha((View)view, (float)1.0f);
        ViewCompat.setTranslationX((View)view, (float)0.0f);
        ViewCompat.setScaleX((View)view, (float)1.0f);
        ViewCompat.setScaleY((View)view, (float)1.0f);
    }

    @Override
    public void handleRightPage(View view, float position) {
        ViewCompat.setAlpha((View)view, (float)(1.0f - position));
        ViewCompat.setTranslationX((View)view, (float)((float)(-view.getWidth()) * position));
        float scale = this.mMinScale + (1.0f - this.mMinScale) * (1.0f - position);
        ViewCompat.setScaleX((View)view, (float)scale);
        ViewCompat.setScaleY((View)view, (float)scale);
    }

    public void setMinScale(float minScale) {
        if (minScale >= 0.6f && minScale <= 1.0f) {
            this.mMinScale = minScale;
        }
    }
}

