/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.bgabanner.transformer;

import android.view.View;
import androidx.viewpager.widget.ViewPager;
import cn.bingoogolapple.bgabanner.transformer.AccordionPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.AlphaPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.CubePageTransformer;
import cn.bingoogolapple.bgabanner.transformer.DefaultPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.DepthPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.FadePageTransformer;
import cn.bingoogolapple.bgabanner.transformer.FlipPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.RotatePageTransformer;
import cn.bingoogolapple.bgabanner.transformer.StackPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.TransitionEffect;
import cn.bingoogolapple.bgabanner.transformer.ZoomCenterPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.ZoomFadePageTransformer;
import cn.bingoogolapple.bgabanner.transformer.ZoomPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.ZoomStackPageTransformer;

public abstract class BGAPageTransformer
implements ViewPager.PageTransformer {
    public void transformPage(View view, float position) {
        if (position < -1.0f) {
            this.handleInvisiblePage(view, position);
        } else if (position <= 0.0f) {
            this.handleLeftPage(view, position);
        } else if (position <= 1.0f) {
            this.handleRightPage(view, position);
        } else {
            this.handleInvisiblePage(view, position);
        }
    }

    public abstract void handleInvisiblePage(View var1, float var2);

    public abstract void handleLeftPage(View var1, float var2);

    public abstract void handleRightPage(View var1, float var2);

    public static BGAPageTransformer getPageTransformer(TransitionEffect effect) {
        switch (effect) {
            case Default: {
                return new DefaultPageTransformer();
            }
            case Alpha: {
                return new AlphaPageTransformer();
            }
            case Rotate: {
                return new RotatePageTransformer();
            }
            case Cube: {
                return new CubePageTransformer();
            }
            case Flip: {
                return new FlipPageTransformer();
            }
            case Accordion: {
                return new AccordionPageTransformer();
            }
            case ZoomFade: {
                return new ZoomFadePageTransformer();
            }
            case Fade: {
                return new FadePageTransformer();
            }
            case ZoomCenter: {
                return new ZoomCenterPageTransformer();
            }
            case ZoomStack: {
                return new ZoomStackPageTransformer();
            }
            case Stack: {
                return new StackPageTransformer();
            }
            case Depth: {
                return new DepthPageTransformer();
            }
            case Zoom: {
                return new ZoomPageTransformer();
            }
        }
        return new DefaultPageTransformer();
    }
}

