/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.bgabanner.transformer;

import android.view.View;
import androidx.core.view.ViewCompat;
import cn.bingoogolapple.bgabanner.transformer.BGAPageTransformer;

public class AlphaPageTransformer
extends BGAPageTransformer {
    private float mMinScale = 0.4f;

    public AlphaPageTransformer() {
    }

    public AlphaPageTransformer(float minScale) {
        this.setMinScale(minScale);
    }

    @Override
    public void handleInvisiblePage(View view, float position) {
        ViewCompat.setAlpha((View)view, (float)0.0f);
    }

    @Override
    public void handleLeftPage(View view, float position) {
        ViewCompat.setAlpha((View)view, (float)(this.mMinScale + (1.0f - this.mMinScale) * (1.0f + position)));
    }

    @Override
    public void handleRightPage(View view, float position) {
        ViewCompat.setAlpha((View)view, (float)(this.mMinScale + (1.0f - this.mMinScale) * (1.0f - position)));
    }

    public void setMinScale(float minScale) {
        if (minScale >= 0.0f && minScale <= 1.0f) {
            this.mMinScale = minScale;
        }
    }
}

