/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.bgabanner;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import androidx.core.view.VelocityTrackerCompat;
import androidx.core.view.ViewCompat;
import androidx.viewpager.widget.ViewPager;
import cn.bingoogolapple.bgabanner.BGABannerScroller;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BGAViewPager
extends ViewPager {
    private boolean mAllowUserScrollable = true;
    private AutoPlayDelegate mAutoPlayDelegate;

    public BGAViewPager(Context context) {
        super(context);
    }

    public BGAViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setPageChangeDuration(int duration) {
        try {
            Field scrollerField = ViewPager.class.getDeclaredField("mScroller");
            scrollerField.setAccessible(true);
            scrollerField.set((Object)this, (Object)new BGABannerScroller(this.getContext(), duration));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBannerCurrentItemInternal(int position, boolean smoothScroll) {
        Class<ViewPager> viewpagerClass = ViewPager.class;
        try {
            Method setCurrentItemInternalMethod = viewpagerClass.getDeclaredMethod("setCurrentItemInternal", Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            setCurrentItemInternalMethod.setAccessible(true);
            setCurrentItemInternalMethod.invoke((Object)this, position, smoothScroll, true);
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAllowUserScrollable(boolean allowUserScrollable) {
        this.mAllowUserScrollable = allowUserScrollable;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mAllowUserScrollable && this.getAdapter() != null && this.getAdapter().getCount() > 0) {
            return super.onInterceptTouchEvent(ev);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mAllowUserScrollable && this.getAdapter() != null && this.getAdapter().getCount() > 0) {
            if (this.mAutoPlayDelegate != null && (ev.getAction() == 3 || ev.getAction() == 1)) {
                this.mAutoPlayDelegate.handleAutoPlayActionUpOrCancel(this.getXVelocity());
                return false;
            }
            return super.onTouchEvent(ev);
        }
        return false;
    }

    private float getXVelocity() {
        float xVelocity = 0.0f;
        Class<ViewPager> viewpagerClass = ViewPager.class;
        try {
            Field velocityTrackerField = viewpagerClass.getDeclaredField("mVelocityTracker");
            velocityTrackerField.setAccessible(true);
            VelocityTracker velocityTracker = (VelocityTracker)velocityTrackerField.get((Object)this);
            Field activePointerIdField = viewpagerClass.getDeclaredField("mActivePointerId");
            activePointerIdField.setAccessible(true);
            Field maximumVelocityField = viewpagerClass.getDeclaredField("mMaximumVelocity");
            maximumVelocityField.setAccessible(true);
            int maximumVelocity = maximumVelocityField.getInt((Object)this);
            velocityTracker.computeCurrentVelocity(1000, (float)maximumVelocity);
            xVelocity = VelocityTrackerCompat.getXVelocity((VelocityTracker)velocityTracker, (int)activePointerIdField.getInt((Object)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xVelocity;
    }

    public void setAutoPlayDelegate(AutoPlayDelegate autoPlayDelegate) {
        this.mAutoPlayDelegate = autoPlayDelegate;
    }

    public static interface AutoPlayDelegate {
        public void handleAutoPlayActionUpOrCancel(float var1);
    }
}

