/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.bgabanner;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Pair;
import androidx.core.view.ViewCompat;
import cn.bingoogolapple.bgabanner.BGALocalImageSize;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;

public class BGABannerUtil {
    private BGABannerUtil() {
    }

    public static int dp2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static int sp2px(Context context, float spValue) {
        return (int)TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public static ImageView getItemImageView(Context context, @DrawableRes int resId, BGALocalImageSize localImageSize, ImageView.ScaleType scaleType) {
        ImageView imageView = new ImageView(context);
        imageView.setImageBitmap(BGABannerUtil.getScaledImageFromResource(context, resId, localImageSize.getMaxWidth(), localImageSize.getMaxHeight(), localImageSize.getMinWidth(), localImageSize.getMinHeight()));
        imageView.setClickable(true);
        imageView.setScaleType(scaleType);
        return imageView;
    }

    public static void resetPageTransformer(List<? extends View> views) {
        if (views == null) {
            return;
        }
        for (View view : views) {
            view.setVisibility(0);
            ViewCompat.setAlpha((View)view, (float)1.0f);
            ViewCompat.setPivotX((View)view, (float)((float)view.getMeasuredWidth() * 0.5f));
            ViewCompat.setPivotY((View)view, (float)((float)view.getMeasuredHeight() * 0.5f));
            ViewCompat.setTranslationX((View)view, (float)0.0f);
            ViewCompat.setTranslationY((View)view, (float)0.0f);
            ViewCompat.setScaleX((View)view, (float)1.0f);
            ViewCompat.setScaleY((View)view, (float)1.0f);
            ViewCompat.setRotationX((View)view, (float)0.0f);
            ViewCompat.setRotationY((View)view, (float)0.0f);
            ViewCompat.setRotation((View)view, (float)0.0f);
        }
    }

    public static boolean isIndexNotOutOfBounds(int position, Collection collection) {
        return BGABannerUtil.isCollectionNotEmpty(collection, new Collection[0]) && position < collection.size();
    }

    public static boolean isCollectionEmpty(Collection collection, Collection ... args) {
        if (collection == null || collection.isEmpty()) {
            return true;
        }
        for (Collection arg : args) {
            if (arg != null && !arg.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isCollectionNotEmpty(Collection collection, Collection ... args) {
        return !BGABannerUtil.isCollectionEmpty(collection, args);
    }

    @Nullable
    public static Bitmap getScaledImageFromResource(@NonNull Context context, int resId, int maxWidth, int maxHeight, float minWidth, float minHeight) {
        LoadBitmapPair<Throwable> result;
        while (((result = BGABannerUtil.getImageFromResource(context, resId, maxWidth, maxHeight)) == null || result.first == null) && result != null && result.second instanceof OutOfMemoryError && (float)(maxWidth /= 2) > minWidth && (float)(maxHeight /= 2) > minHeight) {
        }
        if (result == null) {
            return null;
        }
        return (Bitmap)result.first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoadBitmapPair<Throwable> getImageFromResource(@NonNull Context context, int resId, int maxWidth, int maxHeight) {
        LoadBitmapPair<Throwable> result;
        BitmapFactory.Options decodeOptions = new BitmapFactory.Options();
        Bitmap.Config preferredConfig = Bitmap.Config.RGB_565;
        InputStream is = null;
        try {
            if (maxWidth == 0 && maxHeight == 0) {
                decodeOptions.inPreferredConfig = preferredConfig;
                is = context.getResources().openRawResource(resId);
                result = new LoadBitmapPair<Object>(BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)decodeOptions), null);
                is.close();
            } else {
                decodeOptions.inJustDecodeBounds = true;
                decodeOptions.inPreferredConfig = preferredConfig;
                is = context.getResources().openRawResource(resId);
                BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)decodeOptions);
                is.reset();
                is.close();
                int actualWidth = decodeOptions.outWidth;
                int actualHeight = decodeOptions.outHeight;
                int desiredWidth = BGABannerUtil.getResizedDimension(maxWidth, maxHeight, actualWidth, actualHeight);
                int desiredHeight = BGABannerUtil.getResizedDimension(maxHeight, maxWidth, actualHeight, actualWidth);
                decodeOptions.inJustDecodeBounds = false;
                decodeOptions.inSampleSize = BGABannerUtil.calculateInSampleSize(decodeOptions, desiredWidth, desiredHeight);
                decodeOptions.inPreferredConfig = preferredConfig;
                is = context.getResources().openRawResource(resId);
                Bitmap tempBitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)decodeOptions);
                is.close();
                if (tempBitmap != null && (tempBitmap.getWidth() > desiredWidth || tempBitmap.getHeight() > desiredHeight)) {
                    result = new LoadBitmapPair<Object>(Bitmap.createScaledBitmap((Bitmap)tempBitmap, (int)desiredWidth, (int)desiredHeight, (boolean)true), null);
                    tempBitmap.recycle();
                } else {
                    result = new LoadBitmapPair<Object>(tempBitmap, null);
                }
            }
        }
        catch (OutOfMemoryError exception) {
            exception.printStackTrace();
            result = new LoadBitmapPair<OutOfMemoryError>(null, exception);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            result = new LoadBitmapPair<Exception>(null, exception);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static int getResizedDimension(int maxPrimary, int maxSecondary, int actualPrimary, int actualSecondary) {
        if (maxPrimary == 0 && maxSecondary == 0) {
            return actualPrimary;
        }
        if (maxPrimary == 0) {
            double ratio = (double)maxSecondary / (double)actualSecondary;
            return (int)((double)actualPrimary * ratio);
        }
        if (maxSecondary == 0) {
            return maxPrimary;
        }
        int resized = maxPrimary;
        double ratio = (double)actualSecondary / (double)actualPrimary;
        if ((double)resized * ratio > (double)maxSecondary) {
            resized = (int)((double)maxSecondary / ratio);
        }
        return resized;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        if (reqWidth == 0 || reqHeight == 0) {
            return 1;
        }
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    private static class LoadBitmapPair<S extends Throwable>
    extends Pair<Bitmap, S> {
        LoadBitmapPair(@Nullable Bitmap first, @Nullable S second) {
            super((Object)first, second);
        }
    }
}

