/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.bgabanner;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.DimenRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import cn.bingoogolapple.bgabanner.BGABannerUtil;
import cn.bingoogolapple.bgabanner.BGALocalImageSize;
import cn.bingoogolapple.bgabanner.BGAOnNoDoubleClickListener;
import cn.bingoogolapple.bgabanner.BGAViewPager;
import cn.bingoogolapple.bgabanner.R;
import cn.bingoogolapple.bgabanner.transformer.BGAPageTransformer;
import cn.bingoogolapple.bgabanner.transformer.TransitionEffect;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BGABanner
extends RelativeLayout
implements BGAViewPager.AutoPlayDelegate,
ViewPager.OnPageChangeListener {
    private static final int RMP = -1;
    private static final int RWC = -2;
    private static final int LWC = -2;
    private static final int NO_PLACEHOLDER_DRAWABLE = -1;
    private static final int VEL_THRESHOLD = 400;
    private BGAViewPager mViewPager;
    private List<View> mHackyViews;
    private List<View> mViews;
    private List<String> mTips;
    private LinearLayout mPointRealContainerLl;
    private TextView mTipTv;
    private boolean mAutoPlayAble = true;
    private int mAutoPlayInterval = 3000;
    private int mPageChangeDuration = 800;
    private int mPointGravity = 81;
    private int mPointLeftRightMargin;
    private int mPointTopBottomMargin;
    private int mPointContainerLeftRightPadding;
    private int mTipTextSize;
    private int mTipTextColor = -1;
    private int mPointDrawableResId = R.drawable.bga_banner_selector_point_solid;
    private Drawable mPointContainerBackgroundDrawable;
    private AutoPlayTask mAutoPlayTask;
    private int mPageScrollPosition;
    private float mPageScrollPositionOffset;
    private TransitionEffect mTransitionEffect;
    private ImageView mPlaceholderIv;
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.CENTER_CROP;
    private int mPlaceholderDrawableResId = -1;
    private List<? extends Object> mModels;
    private Delegate mDelegate;
    private Adapter mAdapter;
    private int mOverScrollMode = 2;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private RelativeLayout mPointContainerRl;
    private boolean mIsNumberIndicator = false;
    private TextView mNumberIndicatorTv;
    private int mNumberIndicatorTextColor = -1;
    private int mNumberIndicatorTextSize;
    private Drawable mNumberIndicatorBackground;
    private boolean mIsNeedShowIndicatorOnOnlyOnePage;
    private int mContentBottomMargin;
    private float mAspectRatio;
    private boolean mAllowUserScrollable = true;
    private View mSkipView;
    private View mEnterView;
    private GuideDelegate mGuideDelegate;
    private boolean mIsFirstInvisible = true;
    private static final ImageView.ScaleType[] sScaleTypeArray = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    private BGAOnNoDoubleClickListener mGuideOnNoDoubleClickListener = new BGAOnNoDoubleClickListener(){

        @Override
        public void onNoDoubleClick(View v) {
            if (BGABanner.this.mGuideDelegate != null) {
                BGABanner.this.mGuideDelegate.onClickEnterOrSkip();
            }
        }
    };

    public BGABanner(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BGABanner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initDefaultAttrs(context);
        this.initCustomAttrs(context, attrs);
        this.initView(context);
    }

    private void initDefaultAttrs(Context context) {
        this.mAutoPlayTask = new AutoPlayTask(this);
        this.mPointLeftRightMargin = BGABannerUtil.dp2px(context, 3.0f);
        this.mPointTopBottomMargin = BGABannerUtil.dp2px(context, 6.0f);
        this.mPointContainerLeftRightPadding = BGABannerUtil.dp2px(context, 10.0f);
        this.mTipTextSize = BGABannerUtil.sp2px(context, 10.0f);
        this.mPointContainerBackgroundDrawable = new ColorDrawable(Color.parseColor((String)"#44aaaaaa"));
        this.mTransitionEffect = TransitionEffect.Default;
        this.mNumberIndicatorTextSize = BGABannerUtil.sp2px(context, 10.0f);
        this.mContentBottomMargin = 0;
        this.mAspectRatio = 0.0f;
    }

    private void initCustomAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BGABanner);
        int N = typedArray.getIndexCount();
        for (int i = 0; i < N; ++i) {
            this.initCustomAttr(typedArray.getIndex(i), typedArray);
        }
        typedArray.recycle();
    }

    private void initCustomAttr(int attr, TypedArray typedArray) {
        int index;
        if (attr == R.styleable.BGABanner_banner_pointDrawable) {
            this.mPointDrawableResId = typedArray.getResourceId(attr, R.drawable.bga_banner_selector_point_solid);
        } else if (attr == R.styleable.BGABanner_banner_pointContainerBackground) {
            this.mPointContainerBackgroundDrawable = typedArray.getDrawable(attr);
        } else if (attr == R.styleable.BGABanner_banner_pointLeftRightMargin) {
            this.mPointLeftRightMargin = typedArray.getDimensionPixelSize(attr, this.mPointLeftRightMargin);
        } else if (attr == R.styleable.BGABanner_banner_pointContainerLeftRightPadding) {
            this.mPointContainerLeftRightPadding = typedArray.getDimensionPixelSize(attr, this.mPointContainerLeftRightPadding);
        } else if (attr == R.styleable.BGABanner_banner_pointTopBottomMargin) {
            this.mPointTopBottomMargin = typedArray.getDimensionPixelSize(attr, this.mPointTopBottomMargin);
        } else if (attr == R.styleable.BGABanner_banner_indicatorGravity) {
            this.mPointGravity = typedArray.getInt(attr, this.mPointGravity);
        } else if (attr == R.styleable.BGABanner_banner_pointAutoPlayAble) {
            this.mAutoPlayAble = typedArray.getBoolean(attr, this.mAutoPlayAble);
        } else if (attr == R.styleable.BGABanner_banner_pointAutoPlayInterval) {
            this.mAutoPlayInterval = typedArray.getInteger(attr, this.mAutoPlayInterval);
        } else if (attr == R.styleable.BGABanner_banner_pageChangeDuration) {
            this.mPageChangeDuration = typedArray.getInteger(attr, this.mPageChangeDuration);
        } else if (attr == R.styleable.BGABanner_banner_transitionEffect) {
            int ordinal = typedArray.getInt(attr, TransitionEffect.Accordion.ordinal());
            this.mTransitionEffect = TransitionEffect.values()[ordinal];
        } else if (attr == R.styleable.BGABanner_banner_tipTextColor) {
            this.mTipTextColor = typedArray.getColor(attr, this.mTipTextColor);
        } else if (attr == R.styleable.BGABanner_banner_tipTextSize) {
            this.mTipTextSize = typedArray.getDimensionPixelSize(attr, this.mTipTextSize);
        } else if (attr == R.styleable.BGABanner_banner_placeholderDrawable) {
            this.mPlaceholderDrawableResId = typedArray.getResourceId(attr, this.mPlaceholderDrawableResId);
        } else if (attr == R.styleable.BGABanner_banner_isNumberIndicator) {
            this.mIsNumberIndicator = typedArray.getBoolean(attr, this.mIsNumberIndicator);
        } else if (attr == R.styleable.BGABanner_banner_numberIndicatorTextColor) {
            this.mNumberIndicatorTextColor = typedArray.getColor(attr, this.mNumberIndicatorTextColor);
        } else if (attr == R.styleable.BGABanner_banner_numberIndicatorTextSize) {
            this.mNumberIndicatorTextSize = typedArray.getDimensionPixelSize(attr, this.mNumberIndicatorTextSize);
        } else if (attr == R.styleable.BGABanner_banner_numberIndicatorBackground) {
            this.mNumberIndicatorBackground = typedArray.getDrawable(attr);
        } else if (attr == R.styleable.BGABanner_banner_isNeedShowIndicatorOnOnlyOnePage) {
            this.mIsNeedShowIndicatorOnOnlyOnePage = typedArray.getBoolean(attr, this.mIsNeedShowIndicatorOnOnlyOnePage);
        } else if (attr == R.styleable.BGABanner_banner_contentBottomMargin) {
            this.mContentBottomMargin = typedArray.getDimensionPixelSize(attr, this.mContentBottomMargin);
        } else if (attr == R.styleable.BGABanner_banner_aspectRatio) {
            this.mAspectRatio = typedArray.getFloat(attr, this.mAspectRatio);
        } else if (attr == R.styleable.BGABanner_android_scaleType && (index = typedArray.getInt(attr, -1)) >= 0 && index < sScaleTypeArray.length) {
            this.mScaleType = sScaleTypeArray[index];
        }
    }

    private void initView(Context context) {
        this.mPointContainerRl = new RelativeLayout(context);
        if (Build.VERSION.SDK_INT >= 16) {
            this.mPointContainerRl.setBackground(this.mPointContainerBackgroundDrawable);
        } else {
            this.mPointContainerRl.setBackgroundDrawable(this.mPointContainerBackgroundDrawable);
        }
        this.mPointContainerRl.setPadding(this.mPointContainerLeftRightPadding, this.mPointTopBottomMargin, this.mPointContainerLeftRightPadding, this.mPointTopBottomMargin);
        RelativeLayout.LayoutParams pointContainerLp = new RelativeLayout.LayoutParams(-1, -2);
        if ((this.mPointGravity & 0x70) == 48) {
            pointContainerLp.addRule(10);
        } else {
            pointContainerLp.addRule(12);
        }
        this.addView((View)this.mPointContainerRl, (ViewGroup.LayoutParams)pointContainerLp);
        RelativeLayout.LayoutParams indicatorLp = new RelativeLayout.LayoutParams(-2, -2);
        indicatorLp.addRule(15);
        if (this.mIsNumberIndicator) {
            this.mNumberIndicatorTv = new TextView(context);
            this.mNumberIndicatorTv.setId(R.id.banner_indicatorId);
            this.mNumberIndicatorTv.setGravity(16);
            this.mNumberIndicatorTv.setSingleLine(true);
            this.mNumberIndicatorTv.setEllipsize(TextUtils.TruncateAt.END);
            this.mNumberIndicatorTv.setTextColor(this.mNumberIndicatorTextColor);
            this.mNumberIndicatorTv.setTextSize(0, (float)this.mNumberIndicatorTextSize);
            this.mNumberIndicatorTv.setVisibility(4);
            if (this.mNumberIndicatorBackground != null) {
                if (Build.VERSION.SDK_INT >= 16) {
                    this.mNumberIndicatorTv.setBackground(this.mNumberIndicatorBackground);
                } else {
                    this.mNumberIndicatorTv.setBackgroundDrawable(this.mNumberIndicatorBackground);
                }
            }
            this.mPointContainerRl.addView((View)this.mNumberIndicatorTv, (ViewGroup.LayoutParams)indicatorLp);
        } else {
            this.mPointRealContainerLl = new LinearLayout(context);
            this.mPointRealContainerLl.setId(R.id.banner_indicatorId);
            this.mPointRealContainerLl.setOrientation(0);
            this.mPointRealContainerLl.setGravity(16);
            this.mPointContainerRl.addView((View)this.mPointRealContainerLl, (ViewGroup.LayoutParams)indicatorLp);
        }
        RelativeLayout.LayoutParams tipLp = new RelativeLayout.LayoutParams(-1, -2);
        tipLp.addRule(15);
        this.mTipTv = new TextView(context);
        this.mTipTv.setGravity(16);
        this.mTipTv.setSingleLine(true);
        this.mTipTv.setEllipsize(TextUtils.TruncateAt.END);
        this.mTipTv.setTextColor(this.mTipTextColor);
        this.mTipTv.setTextSize(0, (float)this.mTipTextSize);
        this.mPointContainerRl.addView((View)this.mTipTv, (ViewGroup.LayoutParams)tipLp);
        int horizontalGravity = this.mPointGravity & 7;
        if (horizontalGravity == 3) {
            indicatorLp.addRule(9);
            tipLp.addRule(1, R.id.banner_indicatorId);
            this.mTipTv.setGravity(21);
        } else if (horizontalGravity == 5) {
            indicatorLp.addRule(11);
            tipLp.addRule(0, R.id.banner_indicatorId);
        } else {
            indicatorLp.addRule(14);
            tipLp.addRule(0, R.id.banner_indicatorId);
        }
        this.showPlaceholder();
    }

    public void showPlaceholder() {
        if (this.mPlaceholderIv == null && this.mPlaceholderDrawableResId != -1) {
            this.mPlaceholderIv = BGABannerUtil.getItemImageView(this.getContext(), this.mPlaceholderDrawableResId, new BGALocalImageSize(720, 360, 640.0f, 320.0f), this.mScaleType);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
            layoutParams.setMargins(0, 0, 0, this.mContentBottomMargin);
            this.addView((View)this.mPlaceholderIv, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void setPageChangeDuration(int duration) {
        if (duration >= 0 && duration <= 2000) {
            this.mPageChangeDuration = duration;
            if (this.mViewPager != null) {
                this.mViewPager.setPageChangeDuration(duration);
            }
        }
    }

    public void setAutoPlayAble(boolean autoPlayAble) {
        this.mAutoPlayAble = autoPlayAble;
        this.stopAutoPlay();
        if (this.mViewPager != null && this.mViewPager.getAdapter() != null) {
            this.mViewPager.getAdapter().notifyDataSetChanged();
        }
    }

    public void setAutoPlayInterval(int autoPlayInterval) {
        this.mAutoPlayInterval = autoPlayInterval;
    }

    public void setData(List<View> views, List<? extends Object> models, List<String> tips) {
        if (BGABannerUtil.isCollectionEmpty(views, new Collection[0])) {
            this.mAutoPlayAble = false;
            views = new ArrayList<View>();
            models = new ArrayList<Object>();
            tips = new ArrayList<String>();
        }
        if (this.mAutoPlayAble && views.size() < 3 && this.mHackyViews == null) {
            this.mAutoPlayAble = false;
        }
        this.mModels = models;
        this.mViews = views;
        this.mTips = tips;
        this.initIndicator();
        this.initViewPager();
        this.removePlaceholder();
        this.handleGuideViewVisibility(0, 0.0f);
    }

    public void setData(@LayoutRes int layoutResId, List<? extends Object> models, List<String> tips) {
        this.mViews = new ArrayList<View>();
        if (models == null) {
            models = new ArrayList<Object>();
            tips = new ArrayList<String>();
        }
        for (int i = 0; i < models.size(); ++i) {
            this.mViews.add(this.inflateItemView(layoutResId));
        }
        if (this.mAutoPlayAble && this.mViews.size() < 3) {
            this.mHackyViews = new ArrayList<View>(this.mViews);
            this.mHackyViews.add(this.inflateItemView(layoutResId));
            if (this.mHackyViews.size() == 2) {
                this.mHackyViews.add(this.inflateItemView(layoutResId));
            }
        }
        this.setData(this.mViews, models, tips);
    }

    private View inflateItemView(@LayoutRes int layoutResId) {
        View itemView = View.inflate((Context)this.getContext(), (int)layoutResId, null);
        if (itemView instanceof ImageView) {
            ((ImageView)itemView).setScaleType(this.mScaleType);
        }
        return itemView;
    }

    public void setData(List<? extends Object> models, List<String> tips) {
        this.setData(R.layout.bga_banner_item_image, models, tips);
    }

    public void setData(List<View> views) {
        this.setData(views, null, null);
    }

    public void setData(@Nullable BGALocalImageSize localImageSize, @Nullable ImageView.ScaleType scaleType, int ... resIds) {
        if (localImageSize == null) {
            localImageSize = new BGALocalImageSize(720, 1280, 320.0f, 640.0f);
        }
        if (scaleType != null) {
            this.mScaleType = scaleType;
        }
        ArrayList<View> views = new ArrayList<View>();
        for (int resId : resIds) {
            views.add((View)BGABannerUtil.getItemImageView(this.getContext(), resId, localImageSize, this.mScaleType));
        }
        this.setData(views);
    }

    public void setAllowUserScrollable(boolean allowUserScrollable) {
        this.mAllowUserScrollable = allowUserScrollable;
        if (this.mViewPager != null) {
            this.mViewPager.setAllowUserScrollable(this.mAllowUserScrollable);
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
    }

    public void setEnterSkipViewId(int enterResId, int skipResId) {
        if (enterResId != 0) {
            this.mEnterView = ((Activity)this.getContext()).findViewById(enterResId);
        }
        if (skipResId != 0) {
            this.mSkipView = ((Activity)this.getContext()).findViewById(skipResId);
        }
    }

    public void setEnterSkipViewIdAndDelegate(int enterResId, int skipResId, GuideDelegate guideDelegate) {
        if (guideDelegate != null) {
            this.mGuideDelegate = guideDelegate;
            if (enterResId != 0) {
                this.mEnterView = ((Activity)this.getContext()).findViewById(enterResId);
                this.mEnterView.setOnClickListener((View.OnClickListener)this.mGuideOnNoDoubleClickListener);
            }
            if (skipResId != 0) {
                this.mSkipView = ((Activity)this.getContext()).findViewById(skipResId);
                this.mSkipView.setOnClickListener((View.OnClickListener)this.mGuideOnNoDoubleClickListener);
            }
        }
        this.handleGuideViewVisibility(0, 0.0f);
    }

    public int getCurrentItem() {
        if (this.mViewPager == null || BGABannerUtil.isCollectionEmpty(this.mViews, new Collection[0])) {
            return -1;
        }
        return this.mViewPager.getCurrentItem() % this.mViews.size();
    }

    public int getItemCount() {
        return this.mViews == null ? 0 : this.mViews.size();
    }

    public List<? extends View> getViews() {
        return this.mViews;
    }

    public <VT extends View> VT getItemView(int position) {
        return (VT)(this.mViews == null ? null : this.mViews.get(position));
    }

    public ImageView getItemImageView(int position) {
        return (ImageView)this.getItemView(position);
    }

    public List<String> getTips() {
        return this.mTips;
    }

    public BGAViewPager getViewPager() {
        return this.mViewPager;
    }

    public void setOverScrollMode(int overScrollMode) {
        this.mOverScrollMode = overScrollMode;
        if (this.mViewPager != null) {
            this.mViewPager.setOverScrollMode(this.mOverScrollMode);
        }
    }

    public void setIndicatorVisibility(boolean visible) {
        this.mPointContainerRl.setVisibility(visible ? 0 : 8);
    }

    public void setIndicatorTopBottomMarginDp(int marginDp) {
        this.setIndicatorTopBottomMarginPx(BGABannerUtil.dp2px(this.getContext(), marginDp));
    }

    public void setIndicatorTopBottomMarginRes(@DimenRes int resId) {
        this.setIndicatorTopBottomMarginPx(this.getResources().getDimensionPixelOffset(resId));
    }

    public void setIndicatorTopBottomMarginPx(int marginPx) {
        this.mPointTopBottomMargin = marginPx;
        this.mPointContainerRl.setPadding(this.mPointContainerLeftRightPadding, this.mPointTopBottomMargin, this.mPointContainerLeftRightPadding, this.mPointTopBottomMargin);
    }

    private void initIndicator() {
        if (this.mPointRealContainerLl != null) {
            this.mPointRealContainerLl.removeAllViews();
            if (this.mIsNeedShowIndicatorOnOnlyOnePage || !this.mIsNeedShowIndicatorOnOnlyOnePage && this.mViews.size() > 1) {
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
                lp.setMargins(this.mPointLeftRightMargin, 0, this.mPointLeftRightMargin, 0);
                for (int i = 0; i < this.mViews.size(); ++i) {
                    ImageView imageView = new ImageView(this.getContext());
                    imageView.setLayoutParams((ViewGroup.LayoutParams)lp);
                    imageView.setImageResource(this.mPointDrawableResId);
                    this.mPointRealContainerLl.addView((View)imageView);
                }
            }
        }
        if (this.mNumberIndicatorTv != null) {
            if (this.mIsNeedShowIndicatorOnOnlyOnePage || !this.mIsNeedShowIndicatorOnOnlyOnePage && this.mViews.size() > 1) {
                this.mNumberIndicatorTv.setVisibility(0);
            } else {
                this.mNumberIndicatorTv.setVisibility(4);
            }
        }
    }

    private void initViewPager() {
        if (this.mViewPager != null && this.equals(this.mViewPager.getParent())) {
            this.removeView((View)this.mViewPager);
            this.mViewPager = null;
        }
        this.mViewPager = new BGAViewPager(this.getContext());
        this.mViewPager.setOffscreenPageLimit(1);
        this.mViewPager.setAdapter(new PageAdapter());
        this.mViewPager.addOnPageChangeListener(this);
        this.mViewPager.setOverScrollMode(this.mOverScrollMode);
        this.mViewPager.setAllowUserScrollable(this.mAllowUserScrollable);
        this.mViewPager.setPageTransformer(true, BGAPageTransformer.getPageTransformer(this.mTransitionEffect));
        this.setPageChangeDuration(this.mPageChangeDuration);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.setMargins(0, 0, 0, this.mContentBottomMargin);
        this.addView((View)this.mViewPager, 0, (ViewGroup.LayoutParams)layoutParams);
        if (this.mAutoPlayAble && !BGABannerUtil.isCollectionEmpty(this.mViews, new Collection[0])) {
            this.mViewPager.setAutoPlayDelegate(this);
            int zeroItem = 0x3FFFFFFF - 0x3FFFFFFF % this.mViews.size();
            this.mViewPager.setCurrentItem(zeroItem);
            this.startAutoPlay();
        } else {
            this.switchToPoint(0);
        }
    }

    public void removePlaceholder() {
        if (this.mPlaceholderIv != null && this.equals(this.mPlaceholderIv.getParent())) {
            this.removeView((View)this.mPlaceholderIv);
            this.mPlaceholderIv = null;
        }
    }

    public void setAspectRatio(float aspectRatio) {
        this.mAspectRatio = aspectRatio;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mAspectRatio > 0.0f) {
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int height = (int)((float)width / this.mAspectRatio);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mAutoPlayAble) {
            switch (ev.getAction()) {
                case 0: {
                    this.stopAutoPlay();
                    break;
                }
                case 1: 
                case 3: {
                    this.startAutoPlay();
                }
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public void setIsNeedShowIndicatorOnOnlyOnePage(boolean isNeedShowIndicatorOnOnlyOnePage) {
        this.mIsNeedShowIndicatorOnOnlyOnePage = isNeedShowIndicatorOnOnlyOnePage;
    }

    public void setCurrentItem(int item) {
        if (this.mViewPager == null || this.mViews == null || item > this.getItemCount() - 1) {
            return;
        }
        if (this.mAutoPlayAble) {
            int realCurrentItem = this.mViewPager.getCurrentItem();
            int currentItem = realCurrentItem % this.mViews.size();
            int offset = item - currentItem;
            if (offset < 0) {
                for (int i = -1; i >= offset; --i) {
                    this.mViewPager.setCurrentItem(realCurrentItem + i, false);
                }
            } else if (offset > 0) {
                for (int i = 1; i <= offset; ++i) {
                    this.mViewPager.setCurrentItem(realCurrentItem + i, false);
                }
            }
            this.startAutoPlay();
        } else {
            this.mViewPager.setCurrentItem(item, false);
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            this.startAutoPlay();
        } else if (visibility == 4 || visibility == 8) {
            this.onInvisibleToUser();
        }
    }

    private void onInvisibleToUser() {
        this.stopAutoPlay();
        if (!this.mIsFirstInvisible && this.mAutoPlayAble && this.mViewPager != null && this.getItemCount() > 0 && this.mPageScrollPositionOffset != 0.0f) {
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() - 1);
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() + 1);
        }
        this.mIsFirstInvisible = false;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onInvisibleToUser();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startAutoPlay();
    }

    public void startAutoPlay() {
        this.stopAutoPlay();
        if (this.mAutoPlayAble) {
            this.postDelayed(this.mAutoPlayTask, this.mAutoPlayInterval);
        }
    }

    public void stopAutoPlay() {
        if (this.mAutoPlayTask != null) {
            this.removeCallbacks(this.mAutoPlayTask);
        }
    }

    private void switchToPoint(int newCurrentPoint) {
        if (this.mTipTv != null) {
            if (this.mTips == null || this.mTips.size() < 1 || newCurrentPoint >= this.mTips.size()) {
                this.mTipTv.setVisibility(8);
            } else {
                this.mTipTv.setVisibility(0);
                this.mTipTv.setText((CharSequence)this.mTips.get(newCurrentPoint));
            }
        }
        if (this.mPointRealContainerLl != null) {
            if (this.mViews != null && this.mViews.size() > 0 && newCurrentPoint < this.mViews.size() && (this.mIsNeedShowIndicatorOnOnlyOnePage || !this.mIsNeedShowIndicatorOnOnlyOnePage && this.mViews.size() > 1)) {
                this.mPointRealContainerLl.setVisibility(0);
                for (int i = 0; i < this.mPointRealContainerLl.getChildCount(); ++i) {
                    this.mPointRealContainerLl.getChildAt(i).setSelected(i == newCurrentPoint);
                    this.mPointRealContainerLl.getChildAt(i).requestLayout();
                }
            } else {
                this.mPointRealContainerLl.setVisibility(8);
            }
        }
        if (this.mNumberIndicatorTv != null) {
            if (this.mViews != null && this.mViews.size() > 0 && newCurrentPoint < this.mViews.size() && (this.mIsNeedShowIndicatorOnOnlyOnePage || !this.mIsNeedShowIndicatorOnOnlyOnePage && this.mViews.size() > 1)) {
                this.mNumberIndicatorTv.setVisibility(0);
                this.mNumberIndicatorTv.setText((CharSequence)(newCurrentPoint + 1 + "/" + this.mViews.size()));
            } else {
                this.mNumberIndicatorTv.setVisibility(8);
            }
        }
    }

    public void setTransitionEffect(TransitionEffect effect) {
        this.mTransitionEffect = effect;
        if (this.mViewPager != null) {
            this.initViewPager();
            if (this.mHackyViews == null) {
                BGABannerUtil.resetPageTransformer(this.mViews);
            } else {
                BGABannerUtil.resetPageTransformer(this.mHackyViews);
            }
        }
    }

    public void setPageTransformer(ViewPager.PageTransformer transformer) {
        if (transformer != null && this.mViewPager != null) {
            this.mViewPager.setPageTransformer(true, transformer);
        }
    }

    private void switchToNextPage() {
        if (this.mViewPager != null) {
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() + 1);
        }
    }

    @Override
    public void handleAutoPlayActionUpOrCancel(float xVelocity) {
        if (this.mViewPager != null) {
            if (this.mPageScrollPosition < this.mViewPager.getCurrentItem()) {
                if (xVelocity > 400.0f || this.mPageScrollPositionOffset < 0.7f && xVelocity > -400.0f) {
                    this.mViewPager.setBannerCurrentItemInternal(this.mPageScrollPosition, true);
                } else {
                    this.mViewPager.setBannerCurrentItemInternal(this.mPageScrollPosition + 1, true);
                }
            } else if (this.mPageScrollPosition == this.mViewPager.getCurrentItem()) {
                if (xVelocity < -400.0f || this.mPageScrollPositionOffset > 0.3f && xVelocity < 400.0f) {
                    this.mViewPager.setBannerCurrentItemInternal(this.mPageScrollPosition + 1, true);
                } else {
                    this.mViewPager.setBannerCurrentItemInternal(this.mPageScrollPosition, true);
                }
            } else {
                this.mViewPager.setBannerCurrentItemInternal(this.mPageScrollPosition, true);
            }
        }
    }

    public void onPageSelected(int position) {
        if (BGABannerUtil.isCollectionEmpty(this.mViews, new Collection[0])) {
            return;
        }
        this.switchToPoint(position %= this.mViews.size());
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(position);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (BGABannerUtil.isCollectionEmpty(this.mViews, new Collection[0])) {
            return;
        }
        this.handleGuideViewVisibility(position % this.mViews.size(), positionOffset);
        this.mPageScrollPosition = position;
        this.mPageScrollPositionOffset = positionOffset;
        if (this.mTipTv != null) {
            if (BGABannerUtil.isCollectionNotEmpty(this.mTips, new Collection[0])) {
                this.mTipTv.setVisibility(0);
                int leftPosition = position % this.mTips.size();
                int rightPosition = (position + 1) % this.mTips.size();
                if (rightPosition < this.mTips.size() && leftPosition < this.mTips.size()) {
                    if ((double)positionOffset > 0.5) {
                        this.mTipTv.setText((CharSequence)this.mTips.get(rightPosition));
                        ViewCompat.setAlpha((View)this.mTipTv, (float)positionOffset);
                    } else {
                        ViewCompat.setAlpha((View)this.mTipTv, (float)(1.0f - positionOffset));
                        this.mTipTv.setText((CharSequence)this.mTips.get(leftPosition));
                    }
                }
            } else {
                this.mTipTv.setVisibility(8);
            }
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(position % this.mViews.size(), positionOffset, positionOffsetPixels);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(state);
        }
    }

    private void handleGuideViewVisibility(int position, float positionOffset) {
        if (this.mEnterView == null && this.mSkipView == null) {
            return;
        }
        if (this.getItemCount() < 2) {
            if (this.mEnterView != null) {
                this.mEnterView.setVisibility(0);
                if (this.mSkipView != null) {
                    this.mSkipView.setVisibility(8);
                }
                return;
            }
            if (this.mSkipView != null) {
                this.mSkipView.setVisibility(0);
                return;
            }
        }
        if (position == this.getItemCount() - 2) {
            if (this.mEnterView != null) {
                ViewCompat.setAlpha((View)this.mEnterView, (float)positionOffset);
            }
            if (this.mSkipView != null) {
                ViewCompat.setAlpha((View)this.mSkipView, (float)(1.0f - positionOffset));
            }
            if (positionOffset > 0.5f) {
                if (this.mEnterView != null) {
                    this.mEnterView.setVisibility(0);
                }
                if (this.mSkipView != null) {
                    this.mSkipView.setVisibility(8);
                }
            } else {
                if (this.mEnterView != null) {
                    this.mEnterView.setVisibility(8);
                }
                if (this.mSkipView != null) {
                    this.mSkipView.setVisibility(0);
                }
            }
        } else if (position == this.getItemCount() - 1) {
            if (this.mEnterView != null) {
                ViewCompat.setAlpha((View)this.mEnterView, (float)(1.0f - positionOffset));
            }
            if (this.mSkipView != null) {
                ViewCompat.setAlpha((View)this.mSkipView, (float)positionOffset);
            }
            if (positionOffset < 0.5f) {
                if (this.mEnterView != null) {
                    this.mEnterView.setVisibility(0);
                }
                if (this.mSkipView != null) {
                    this.mSkipView.setVisibility(8);
                }
            } else {
                if (this.mEnterView != null) {
                    this.mEnterView.setVisibility(8);
                }
                if (this.mSkipView != null) {
                    this.mSkipView.setVisibility(0);
                }
            }
        } else {
            if (this.mSkipView != null) {
                this.mSkipView.setVisibility(0);
                ViewCompat.setAlpha((View)this.mSkipView, (float)1.0f);
            }
            if (this.mEnterView != null) {
                this.mEnterView.setVisibility(8);
            }
        }
    }

    public void setDelegate(Delegate delegate) {
        this.mDelegate = delegate;
    }

    public void setAdapter(Adapter adapter) {
        this.mAdapter = adapter;
    }

    public static interface GuideDelegate {
        public void onClickEnterOrSkip();
    }

    public static interface Adapter<V extends View, M> {
        public void fillBannerItem(BGABanner var1, V var2, @Nullable M var3, int var4);
    }

    public static interface Delegate<V extends View, M> {
        public void onBannerItemClick(BGABanner var1, V var2, @Nullable M var3, int var4);
    }

    private static class AutoPlayTask
    implements Runnable {
        private final WeakReference<BGABanner> mBanner;

        private AutoPlayTask(BGABanner banner) {
            this.mBanner = new WeakReference<BGABanner>(banner);
        }

        @Override
        public void run() {
            BGABanner banner = (BGABanner)this.mBanner.get();
            if (banner != null) {
                banner.startAutoPlay();
                banner.switchToNextPage();
            }
        }
    }

    private class PageAdapter
    extends PagerAdapter {
        private PageAdapter() {
        }

        public int getCount() {
            return BGABanner.this.mViews == null ? 0 : (BGABanner.this.mAutoPlayAble ? Integer.MAX_VALUE : BGABanner.this.mViews.size());
        }

        public Object instantiateItem(ViewGroup container, int position) {
            ViewParent viewParent;
            if (BGABannerUtil.isCollectionEmpty(BGABanner.this.mViews, new Collection[0])) {
                return null;
            }
            int finalPosition = position % BGABanner.this.mViews.size();
            View view = BGABanner.this.mHackyViews == null ? (View)BGABanner.this.mViews.get(finalPosition) : (View)BGABanner.this.mHackyViews.get(position % BGABanner.this.mHackyViews.size());
            if (BGABanner.this.mDelegate != null) {
                view.setOnClickListener((View.OnClickListener)new BGAOnNoDoubleClickListener(){

                    @Override
                    public void onNoDoubleClick(View view) {
                        int currentPosition = BGABanner.this.mViewPager.getCurrentItem() % BGABanner.this.mViews.size();
                        if (BGABannerUtil.isIndexNotOutOfBounds(currentPosition, BGABanner.this.mModels)) {
                            BGABanner.this.mDelegate.onBannerItemClick(BGABanner.this, view, BGABanner.this.mModels.get(currentPosition), currentPosition);
                        } else if (BGABannerUtil.isCollectionEmpty(BGABanner.this.mModels, new Collection[0])) {
                            BGABanner.this.mDelegate.onBannerItemClick(BGABanner.this, view, null, currentPosition);
                        }
                    }
                });
            }
            if (BGABanner.this.mAdapter != null) {
                if (BGABannerUtil.isIndexNotOutOfBounds(finalPosition, BGABanner.this.mModels)) {
                    BGABanner.this.mAdapter.fillBannerItem(BGABanner.this, view, BGABanner.this.mModels.get(finalPosition), finalPosition);
                } else if (BGABannerUtil.isCollectionEmpty(BGABanner.this.mModels, new Collection[0])) {
                    BGABanner.this.mAdapter.fillBannerItem(BGABanner.this, view, null, finalPosition);
                }
            }
            if ((viewParent = view.getParent()) != null) {
                ((ViewGroup)viewParent).removeView(view);
            }
            container.addView(view);
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public int getItemPosition(Object object) {
            return -2;
        }
    }
}

