/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.badgeview.compiler;

import cn.bingoogolapple.badgeview.annotation.BGABadge;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public class BGABadgeProcessor
extends AbstractProcessor {
    private static final String CLASS_JAVA_DOC = "Generated by BGABadgeView-Android. Do not edit it!\n";
    private static final String PACKAGE_NAME = "cn.bingoogolapple.badgeview";
    private static final String CLASS_PREFIX = "BGABadge";
    private Filer mFileUtils;
    private Elements mElementUtils;
    private Messager mMessager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.mFileUtils = this.processingEnv.getFiler();
        this.mElementUtils = this.processingEnv.getElementUtils();
        this.mMessager = this.processingEnv.getMessager();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotationTypes = new LinkedHashSet<String>();
        annotationTypes.add(BGABadge.class.getCanonicalName());
        return annotationTypes;
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Set<? extends Element> elements = roundEnvironment.getElementsAnnotatedWith(BGABadge.class);
        if (elements == null || elements.isEmpty()) {
            return true;
        }
        this.mMessager.printMessage(Diagnostic.Kind.NOTE, "====================================== BGABadgeProcessor process START ======================================");
        HashSet<String> viewClassSet = new HashSet<String>();
        this.parseParams(elements, viewClassSet);
        try {
            this.generate(viewClassSet);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            this.mMessager.printMessage(Diagnostic.Kind.ERROR, "Exception occurred when generating class file.");
            e.printStackTrace();
        }
        this.mMessager.printMessage(Diagnostic.Kind.NOTE, "====================================== BGABadgeProcessor process END ======================================");
        return true;
    }

    private void parseParams(Set<? extends Element> elements, Set<String> viewClassSet) {
        for (Element element : elements) {
            this.checkAnnotationValid(element, BGABadge.class);
            TypeElement classElement = (TypeElement)element;
            BGABadge badgeAnnotation = classElement.getAnnotation(BGABadge.class);
            try {
                badgeAnnotation.value();
            }
            catch (MirroredTypesException e) {
                List<? extends TypeMirror> typeMirrors = e.getTypeMirrors();
                for (TypeMirror typeMirror : typeMirrors) {
                    DeclaredType classTypeMirror = (DeclaredType)typeMirror;
                    TypeElement classTypeElement = (TypeElement)classTypeMirror.asElement();
                    String qualifiedName = classTypeElement.getQualifiedName().toString();
                    viewClassSet.add(qualifiedName);
                }
            }
        }
    }

    private void generate(Set<String> viewClassSet) throws IllegalAccessException, IOException {
        this.mMessager.printMessage(Diagnostic.Kind.NOTE, "\u751f\u6210 " + viewClassSet.size() + " \u4e2a");
        for (String clazz : viewClassSet) {
            int lastDotIndex = clazz.lastIndexOf(".");
            String superPackageName = clazz.substring(0, lastDotIndex);
            String superClassName = clazz.substring(lastDotIndex + 1);
            String className = CLASS_PREFIX + superClassName;
            this.mMessager.printMessage(Diagnostic.Kind.NOTE, clazz + " ====> " + className);
            TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((String)className).addJavadoc(CLASS_JAVA_DOC, new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ClassName.get((String)superPackageName, (String)superClassName, (String[])new String[0])).addSuperinterface((TypeName)ClassName.get((String)PACKAGE_NAME, (String)"BGABadgeable", (String[])new String[0])).addField((TypeName)ClassName.get((String)PACKAGE_NAME, (String)"BGABadgeViewHelper", (String[])new String[0]), "mBadgeViewHelper", new Modifier[]{Modifier.PRIVATE});
            this.generateMethod(typeBuilder, clazz);
            JavaFile javaFile = JavaFile.builder((String)PACKAGE_NAME, (TypeSpec)typeBuilder.build()).build();
            javaFile.writeTo(this.mFileUtils);
        }
    }

    private void generateMethod(TypeSpec.Builder typeBuilder, String clazz) {
        this.constructor(typeBuilder, clazz);
        this.onTouchEvent(typeBuilder);
        this.callSuperOnTouchEvent(typeBuilder);
        if (this.isAssignable(clazz, "android.view.ViewGroup")) {
            this.dispatchDraw(typeBuilder);
        } else {
            this.onDraw(typeBuilder);
        }
        this.showCirclePointBadge(typeBuilder);
        this.showTextBadge(typeBuilder);
        this.hiddenBadge(typeBuilder);
        this.showDrawableBadge(typeBuilder);
        this.setDragDismissDelegate(typeBuilder);
        this.isShowBadge(typeBuilder);
        this.isDraggable(typeBuilder);
        this.isDragging(typeBuilder);
        this.getBadgeViewHelper(typeBuilder);
    }

    private void constructor(TypeSpec.Builder typeBuilder, String clazz) {
        ClassName contextType = ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]);
        ClassName attributeSetType = ClassName.get((String)"android.util", (String)"AttributeSet", (String[])new String[0]);
        MethodSpec constructorOne = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)contextType, "context", new Modifier[0]).addStatement("this(context, null)", new Object[0]).build();
        MethodSpec constructorTwo = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)contextType, "context", new Modifier[0]).addParameter((TypeName)attributeSetType, "attrs", new Modifier[0]).addStatement("this(context, attrs, 0)", new Object[0]).build();
        MethodSpec.Builder constructorThreeBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)contextType, "context", new Modifier[0]).addParameter((TypeName)attributeSetType, "attrs", new Modifier[0]).addParameter(Integer.TYPE, "defStyleAttr", new Modifier[0]).addStatement("super(context, attrs, defStyleAttr)", new Object[0]);
        if (this.isAssignable(clazz, "android.widget.ImageView") || this.isAssignable(clazz, "android.widget.RadioButton")) {
            constructorThreeBuilder.addStatement("mBadgeViewHelper = new BGABadgeViewHelper(this, context, attrs, BGABadgeViewHelper.BadgeGravity.RightTop)", new Object[0]);
        } else {
            constructorThreeBuilder.addStatement("mBadgeViewHelper = new BGABadgeViewHelper(this, context, attrs, BGABadgeViewHelper.BadgeGravity.RightCenter)", new Object[0]);
        }
        typeBuilder.addMethod(constructorOne).addMethod(constructorTwo).addMethod(constructorThreeBuilder.build());
    }

    private void onTouchEvent(TypeSpec.Builder typeBuilder) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"onTouchEvent").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)"android.view", (String)"MotionEvent", (String[])new String[0]), "event", new Modifier[0]).addStatement("return mBadgeViewHelper.onTouchEvent(event)", new Object[0]).returns(Boolean.TYPE).build();
        typeBuilder.addMethod(methodSpec);
    }

    private void callSuperOnTouchEvent(TypeSpec.Builder typeBuilder) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"callSuperOnTouchEvent").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)"android.view", (String)"MotionEvent", (String[])new String[0]), "event", new Modifier[0]).addStatement("return super.onTouchEvent(event)", new Object[0]).returns(Boolean.TYPE).build();
        typeBuilder.addMethod(methodSpec);
    }

    private void onDraw(TypeSpec.Builder typeBuilder) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"onDraw").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)"android.graphics", (String)"Canvas", (String[])new String[0]), "canvas", new Modifier[0]).addStatement("super.onDraw(canvas)", new Object[0]).addStatement("mBadgeViewHelper.drawBadge(canvas)", new Object[0]).build();
        typeBuilder.addMethod(methodSpec);
    }

    private void dispatchDraw(TypeSpec.Builder typeBuilder) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"dispatchDraw").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)"android.graphics", (String)"Canvas", (String[])new String[0]), "canvas", new Modifier[0]).addStatement("super.dispatchDraw(canvas)", new Object[0]).addStatement("mBadgeViewHelper.drawBadge(canvas)", new Object[0]).build();
        typeBuilder.addMethod(methodSpec);
    }

    private void showCirclePointBadge(TypeSpec.Builder typeBuilder) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"showCirclePointBadge").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("mBadgeViewHelper.showCirclePointBadge()", new Object[0]).build();
        typeBuilder.addMethod(methodSpec);
    }

    private void showTextBadge(TypeSpec.Builder typeBuilder) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"showTextBadge").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "badgeText", new Modifier[0]).addStatement("mBadgeViewHelper.showTextBadge(badgeText)", new Object[0]).build();
        typeBuilder.addMethod(methodSpec);
    }

    private void hiddenBadge(TypeSpec.Builder typeBuilder) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"hiddenBadge").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("mBadgeViewHelper.hiddenBadge()", new Object[0]).build();
        typeBuilder.addMethod(methodSpec);
    }

    private void showDrawableBadge(TypeSpec.Builder typeBuilder) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"showDrawableBadge").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)"android.graphics", (String)"Bitmap", (String[])new String[0]), "bitmap", new Modifier[0]).addStatement("mBadgeViewHelper.showDrawable(bitmap)", new Object[0]).build();
        typeBuilder.addMethod(methodSpec);
    }

    private void setDragDismissDelegate(TypeSpec.Builder typeBuilder) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"setDragDismissDelegate").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)PACKAGE_NAME, (String)"BGADragDismissDelegate", (String[])new String[0]), "delegate", new Modifier[0]).addStatement("mBadgeViewHelper.setDragDismissDelegate(delegate)", new Object[0]).build();
        typeBuilder.addMethod(methodSpec);
    }

    private void isShowBadge(TypeSpec.Builder typeBuilder) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"isShowBadge").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return mBadgeViewHelper.isShowBadge()", new Object[0]).returns(Boolean.TYPE).build();
        typeBuilder.addMethod(methodSpec);
    }

    private void isDraggable(TypeSpec.Builder typeBuilder) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"isDraggable").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return mBadgeViewHelper.isDraggable()", new Object[0]).returns(Boolean.TYPE).build();
        typeBuilder.addMethod(methodSpec);
    }

    private void isDragging(TypeSpec.Builder typeBuilder) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"isDragging").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return mBadgeViewHelper.isDragging()", new Object[0]).returns(Boolean.TYPE).build();
        typeBuilder.addMethod(methodSpec);
    }

    private void getBadgeViewHelper(TypeSpec.Builder typeBuilder) {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"getBadgeViewHelper").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return mBadgeViewHelper", new Object[0]).returns((TypeName)ClassName.get((String)PACKAGE_NAME, (String)"BGABadgeViewHelper", (String[])new String[0])).build();
        typeBuilder.addMethod(methodSpec);
    }

    private boolean checkAnnotationValid(Element annotatedElement, Class clazz) {
        if (annotatedElement.getKind() != ElementKind.CLASS) {
            this.error(annotatedElement, "%s must be declared on class.", clazz.getSimpleName());
            return false;
        }
        if (annotatedElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.error(annotatedElement, "%s must can not be private.", ((TypeElement)annotatedElement).getQualifiedName());
            return false;
        }
        return true;
    }

    private void error(Element element, String message, Object ... args) {
        if (args.length > 0) {
            message = String.format(message, args);
        }
        this.mMessager.printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    private boolean isAssignable(String childClazz, String superClazz) {
        return this.processingEnv.getTypeUtils().isAssignable(this.processingEnv.getElementUtils().getTypeElement(childClazz).asType(), this.processingEnv.getElementUtils().getTypeElement(superClazz).asType());
    }
}

