/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.badgeview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.OvershootInterpolator;
import cn.bingoogolapple.badgeview.BGABadgeViewHelper;
import cn.bingoogolapple.badgeview.BGABadgeViewUtil;
import cn.bingoogolapple.badgeview.BGAExplosionAnimator;
import java.lang.ref.WeakReference;

class BGADragBadgeView
extends View {
    private static final String TAG = BGADragBadgeView.class.getSimpleName();
    private BGABadgeViewHelper mBadgeViewHelper;
    private Paint mBadgePaint;
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mLayoutParams;
    private int mStartX;
    private int mStartY;
    private BGAExplosionAnimator mExplosionAnimator;
    private SetExplosionAnimatorNullTask mSetExplosionAnimatorNullTask;
    private PointF[] mStickPoints = new PointF[]{new PointF(0.0f, 0.0f), new PointF(0.0f, 0.0f)};
    private PointF[] mDragPoints = new PointF[]{new PointF(0.0f, 0.0f), new PointF(0.0f, 0.0f)};
    private PointF mControlPoint = new PointF(0.0f, 0.0f);
    private PointF mDragCenter = new PointF(0.0f, 0.0f);
    private float mDragRadius;
    private PointF mStickCenter;
    private float mStickRadius;
    private int mMaxDragRadius;
    private int mDragStickRadiusDifference;
    private int mDismissThreshold;
    private boolean mDismissAble;
    private boolean mIsDragDisappear;

    public BGADragBadgeView(Context context, BGABadgeViewHelper badgeViewHelper) {
        super(context);
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mBadgeViewHelper = badgeViewHelper;
        this.initBadgePaint();
        this.initLayoutParams();
        this.initStick();
        this.mSetExplosionAnimatorNullTask = new SetExplosionAnimatorNullTask(this);
    }

    private void initBadgePaint() {
        this.mBadgePaint = new Paint();
        this.mBadgePaint.setAntiAlias(true);
        this.mBadgePaint.setStyle(Paint.Style.FILL);
        this.mBadgePaint.setTextAlign(Paint.Align.CENTER);
        this.mBadgePaint.setTextSize((float)this.mBadgeViewHelper.getBadgeTextSize());
    }

    private void initLayoutParams() {
        this.mLayoutParams = new WindowManager.LayoutParams();
        this.mLayoutParams.gravity = 51;
        this.mLayoutParams.flags = 8;
        this.mLayoutParams.format = -3;
        this.mLayoutParams.type = 1000;
        this.mLayoutParams.width = -1;
        this.mLayoutParams.height = -1;
    }

    private void initStick() {
        this.mMaxDragRadius = BGABadgeViewUtil.dp2px(this.getContext(), 10.0f);
        this.mDragStickRadiusDifference = BGABadgeViewUtil.dp2px(this.getContext(), 1.0f);
    }

    protected void onDraw(Canvas canvas) {
        try {
            if (this.mExplosionAnimator == null) {
                if (this.mBadgeViewHelper.isShowDrawable()) {
                    if (this.mBadgeViewHelper.getBadgeBgColor() == -65536) {
                        this.mBadgePaint.setColor(this.mBadgeViewHelper.getBitmap().getPixel(this.mBadgeViewHelper.getBitmap().getWidth() / 2, this.mBadgeViewHelper.getBitmap().getHeight() / 2));
                    } else {
                        this.mBadgePaint.setColor(this.mBadgeViewHelper.getBadgeBgColor());
                    }
                    this.drawStick(canvas);
                    this.drawDrawableBadge(canvas);
                } else {
                    this.mBadgePaint.setColor(this.mBadgeViewHelper.getBadgeBgColor());
                    this.drawStick(canvas);
                    this.drawTextBadge(canvas);
                }
            } else {
                this.mExplosionAnimator.draw(canvas);
            }
        }
        catch (Exception e) {
            this.removeSelfWithException();
        }
    }

    private void drawDrawableBadge(Canvas canvas) {
        canvas.drawBitmap(this.mBadgeViewHelper.getBitmap(), (float)this.mStartX, (float)this.mStartY, this.mBadgePaint);
    }

    private void drawTextBadge(Canvas canvas) {
        this.mBadgePaint.setColor(this.mBadgeViewHelper.getBadgeBgColor());
        canvas.drawRoundRect(new RectF((float)this.mStartX, (float)this.mStartY, (float)this.mStartX + this.mBadgeViewHelper.getBadgeRectF().width(), (float)this.mStartY + this.mBadgeViewHelper.getBadgeRectF().height()), this.mBadgeViewHelper.getBadgeRectF().height() / 2.0f, this.mBadgeViewHelper.getBadgeRectF().height() / 2.0f, this.mBadgePaint);
        this.mBadgePaint.setColor(this.mBadgeViewHelper.getBadgeTextColor());
        float x = (float)this.mStartX + this.mBadgeViewHelper.getBadgeRectF().width() / 2.0f;
        float y = (float)this.mStartY + this.mBadgeViewHelper.getBadgeRectF().height() - (float)this.mBadgeViewHelper.getBadgePadding();
        String badgeText = this.mBadgeViewHelper.getBadgeText() == null ? "" : this.mBadgeViewHelper.getBadgeText();
        canvas.drawText(badgeText, x, y, this.mBadgePaint);
    }

    private void drawStick(Canvas canvas) {
        float currentStickRadius = this.getCurrentStickRadius();
        float yOffset = this.mStickCenter.y - this.mDragCenter.y;
        float xOffset = this.mStickCenter.x - this.mDragCenter.x;
        Double lineK = null;
        if (xOffset != 0.0f) {
            lineK = yOffset / xOffset;
        }
        this.mDragPoints = BGABadgeViewUtil.getIntersectionPoints(this.mDragCenter, this.mDragRadius, lineK);
        this.mStickPoints = BGABadgeViewUtil.getIntersectionPoints(this.mStickCenter, currentStickRadius, lineK);
        this.mControlPoint = BGABadgeViewUtil.getMiddlePoint(this.mDragCenter, this.mStickCenter);
        if (!this.mIsDragDisappear) {
            if (!this.mDismissAble) {
                Path path = new Path();
                path.moveTo(this.mStickPoints[0].x, this.mStickPoints[0].y);
                path.quadTo(this.mControlPoint.x, this.mControlPoint.y, this.mDragPoints[0].x, this.mDragPoints[0].y);
                path.lineTo(this.mDragPoints[1].x, this.mDragPoints[1].y);
                path.quadTo(this.mControlPoint.x, this.mControlPoint.y, this.mStickPoints[1].x, this.mStickPoints[1].y);
                path.close();
                canvas.drawPath(path, this.mBadgePaint);
                canvas.drawCircle(this.mStickCenter.x, this.mStickCenter.y, currentStickRadius, this.mBadgePaint);
            }
            canvas.drawCircle(this.mDragCenter.x, this.mDragCenter.y, this.mDragRadius, this.mBadgePaint);
        }
    }

    private float getCurrentStickRadius() {
        float distance = BGABadgeViewUtil.getDistanceBetween2Points(this.mDragCenter, this.mStickCenter);
        distance = Math.min(distance, (float)this.mDismissThreshold);
        float percent = distance / (float)this.mDismissThreshold;
        return BGABadgeViewUtil.evaluate(percent, Float.valueOf(this.mStickRadius), Float.valueOf(this.mStickRadius * 0.2f)).floatValue();
    }

    public void setStickCenter(float x, float y) {
        this.mStickCenter = new PointF(x, y);
    }

    public boolean onTouchEvent(MotionEvent event) {
        try {
            switch (event.getAction()) {
                case 0: {
                    this.handleActionDown(event);
                    break;
                }
                case 2: {
                    this.handleActionMove(event);
                    break;
                }
                case 1: 
                case 3: {
                    this.handleActionUp(event);
                }
            }
        }
        catch (Exception e) {
            this.removeSelfWithException();
        }
        return true;
    }

    private void handleActionDown(MotionEvent event) {
        if (this.mExplosionAnimator == null && this.getParent() == null) {
            this.mDragRadius = Math.min(this.mBadgeViewHelper.getBadgeRectF().width() / 2.0f, (float)this.mMaxDragRadius);
            this.mStickRadius = this.mDragRadius - (float)this.mDragStickRadiusDifference;
            this.mDismissThreshold = (int)(this.mStickRadius * 10.0f);
            this.mDismissAble = false;
            this.mIsDragDisappear = false;
            this.mWindowManager.addView((View)this, (ViewGroup.LayoutParams)this.mLayoutParams);
            this.updateDragPosition(event.getRawX(), event.getRawY());
        }
    }

    private void handleActionMove(MotionEvent event) {
        if (this.mExplosionAnimator == null && this.getParent() != null) {
            this.updateDragPosition(event.getRawX(), event.getRawY());
            if (BGABadgeViewUtil.getDistanceBetween2Points(this.mDragCenter, this.mStickCenter) > (float)this.mDismissThreshold) {
                this.mDismissAble = true;
                this.postInvalidate();
            } else if (this.mBadgeViewHelper.isResumeTravel()) {
                this.mDismissAble = false;
                this.postInvalidate();
            }
        }
    }

    private void handleActionUp(MotionEvent event) {
        this.handleActionMove(event);
        if (this.mDismissAble) {
            if (BGABadgeViewUtil.getDistanceBetween2Points(this.mDragCenter, this.mStickCenter) > (float)this.mDismissThreshold) {
                try {
                    this.mIsDragDisappear = true;
                    this.startDismissAnim(this.getNewStartX(event.getRawX()), this.getNewStartY(event.getRawY()));
                }
                catch (Exception e) {
                    this.removeSelf();
                    this.mBadgeViewHelper.endDragWithDismiss();
                }
            } else {
                this.removeSelf();
                this.mBadgeViewHelper.endDragWithoutDismiss();
            }
        } else {
            try {
                this.startSpringAnim();
            }
            catch (Exception e) {
                this.removeSelf();
                this.mBadgeViewHelper.endDragWithoutDismiss();
            }
        }
    }

    private void startSpringAnim() {
        final PointF startReleaseDragCenter = new PointF(this.mDragCenter.x, this.mDragCenter.y);
        ValueAnimator springAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f});
        springAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator mAnim) {
                float percent = mAnim.getAnimatedFraction();
                PointF p = BGABadgeViewUtil.getPointByPercent(startReleaseDragCenter, BGADragBadgeView.this.mStickCenter, percent);
                BGADragBadgeView.this.updateDragPosition(p.x, p.y);
            }
        });
        springAnim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                BGADragBadgeView.this.removeSelf();
                BGADragBadgeView.this.mBadgeViewHelper.endDragWithoutDismiss();
            }

            public void onAnimationCancel(Animator animation) {
                BGADragBadgeView.this.removeSelf();
                BGADragBadgeView.this.mBadgeViewHelper.endDragWithoutDismiss();
            }
        });
        springAnim.setInterpolator((TimeInterpolator)new OvershootInterpolator(4.0f));
        springAnim.setRepeatCount(1);
        springAnim.setRepeatMode(-1);
        springAnim.setDuration(150L);
        springAnim.start();
    }

    private void startDismissAnim(int newX, int newY) {
        int badgeHeight;
        int badgeWidth = (int)this.mBadgeViewHelper.getBadgeRectF().width();
        Rect rect = new Rect(newX - badgeWidth / 2, newY - (badgeHeight = (int)this.mBadgeViewHelper.getBadgeRectF().height()) / 2, newX + badgeWidth / 2, newY + badgeHeight / 2);
        Bitmap badgeBitmap = BGABadgeViewUtil.createBitmapSafely(this, rect, 1);
        if (badgeBitmap == null) {
            this.removeSelf();
            this.mBadgeViewHelper.endDragWithDismiss();
            return;
        }
        if (this.mExplosionAnimator != null) {
            this.removeSelf();
            this.mBadgeViewHelper.endDragWithDismiss();
            return;
        }
        this.mExplosionAnimator = new BGAExplosionAnimator(this, rect, badgeBitmap);
        this.mExplosionAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                BGADragBadgeView.this.removeSelf();
                BGADragBadgeView.this.mBadgeViewHelper.endDragWithDismiss();
            }

            public void onAnimationCancel(Animator animation) {
                BGADragBadgeView.this.removeSelf();
                BGADragBadgeView.this.mBadgeViewHelper.endDragWithDismiss();
            }
        });
        this.mExplosionAnimator.start();
    }

    private void removeSelf() {
        if (this.getParent() != null) {
            this.mWindowManager.removeView((View)this);
        }
        this.mDismissAble = false;
        this.mIsDragDisappear = false;
        this.postDelayed(this.mSetExplosionAnimatorNullTask, 60L);
    }

    private void updateDragPosition(float rawX, float rawY) {
        this.mStartX = this.getNewStartX(rawX);
        this.mStartY = this.getNewStartY(rawY);
        this.mDragCenter.set(rawX, rawY);
        this.postInvalidate();
    }

    private int getNewStartX(float rawX) {
        int badgeWidth = (int)this.mBadgeViewHelper.getBadgeRectF().width();
        int newX = (int)rawX - badgeWidth / 2;
        if (newX < 0) {
            newX = 0;
        }
        if (newX > this.mWindowManager.getDefaultDisplay().getWidth() - badgeWidth) {
            newX = this.mWindowManager.getDefaultDisplay().getWidth() - badgeWidth;
        }
        return newX;
    }

    private int getNewStartY(float rawY) {
        int badgeHeight = (int)this.mBadgeViewHelper.getBadgeRectF().height();
        int maxNewY = this.getHeight() - badgeHeight;
        int newStartY = (int)rawY - badgeHeight / 2;
        return Math.min(Math.max(0, newStartY), maxNewY);
    }

    private void removeSelfWithException() {
        this.removeSelf();
        if (BGABadgeViewUtil.getDistanceBetween2Points(this.mDragCenter, this.mStickCenter) > (float)this.mDismissThreshold) {
            this.mBadgeViewHelper.endDragWithDismiss();
        } else {
            this.mBadgeViewHelper.endDragWithoutDismiss();
        }
    }

    private static class SetExplosionAnimatorNullTask
    implements Runnable {
        private final WeakReference<BGADragBadgeView> mDragBadgeView;

        public SetExplosionAnimatorNullTask(BGADragBadgeView dragBadgeView) {
            this.mDragBadgeView = new WeakReference<BGADragBadgeView>(dragBadgeView);
        }

        @Override
        public void run() {
            BGADragBadgeView dragBadgeView = (BGADragBadgeView)((Object)this.mDragBadgeView.get());
            if (dragBadgeView != null) {
                dragBadgeView.mExplosionAnimator = null;
            }
        }
    }
}

