/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.v3.auth;

import com.github.binarywang.wxpay.config.WxPayHttpProxy;
import com.github.binarywang.wxpay.util.HttpProxyUtils;
import com.github.binarywang.wxpay.v3.Credentials;
import com.github.binarywang.wxpay.v3.Validator;
import com.github.binarywang.wxpay.v3.WxPayV3HttpClientBuilder;
import com.github.binarywang.wxpay.v3.auth.CertificatesVerifier;
import com.github.binarywang.wxpay.v3.auth.Verifier;
import com.github.binarywang.wxpay.v3.auth.WxPayValidator;
import com.github.binarywang.wxpay.v3.util.AesUtils;
import com.github.binarywang.wxpay.v3.util.PemUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoUpdateCertificatesVerifier
implements Verifier {
    private static final Logger log = LoggerFactory.getLogger(AutoUpdateCertificatesVerifier.class);
    private static final String CERT_DOWNLOAD_PATH = "https://api.mch.weixin.qq.com/v3/certificates";
    private volatile Instant instant;
    private final int minutesInterval;
    private CertificatesVerifier verifier;
    private final Credentials credentials;
    private final byte[] apiV3Key;
    private final ReentrantLock lock = new ReentrantLock();
    private WxPayHttpProxy wxPayHttpProxy;

    public AutoUpdateCertificatesVerifier(Credentials credentials, byte[] apiV3Key) {
        this(credentials, apiV3Key, TimeInterval.OneHour.getMinutes());
    }

    public AutoUpdateCertificatesVerifier(Credentials credentials, byte[] apiV3Key, int minutesInterval) {
        this(credentials, apiV3Key, minutesInterval, null);
    }

    public AutoUpdateCertificatesVerifier(Credentials credentials, byte[] apiV3Key, int minutesInterval, WxPayHttpProxy wxPayHttpProxy) {
        this.credentials = credentials;
        this.apiV3Key = apiV3Key;
        this.minutesInterval = minutesInterval;
        this.wxPayHttpProxy = wxPayHttpProxy;
        try {
            this.autoUpdateCert();
            this.instant = Instant.now();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean verify(String serialNumber, byte[] message, String signature) {
        this.checkAndAutoUpdateCert();
        return this.verifier.verify(serialNumber, message, signature);
    }

    private void checkAndAutoUpdateCert() {
        if ((this.instant == null || this.instant.plus((long)this.minutesInterval, ChronoUnit.MINUTES).compareTo(Instant.now()) <= 0) && this.lock.tryLock()) {
            try {
                this.autoUpdateCert();
                this.instant = Instant.now();
            }
            catch (IOException | GeneralSecurityException e) {
                log.warn("Auto update cert failed, exception = " + e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void autoUpdateCert() throws IOException, GeneralSecurityException {
        WxPayV3HttpClientBuilder wxPayV3HttpClientBuilder = WxPayV3HttpClientBuilder.create().withCredentials(this.credentials).withValidator(this.verifier == null ? new Validator(){

            @Override
            public boolean validate(CloseableHttpResponse response) throws IOException {
                return true;
            }
        } : new WxPayValidator(this.verifier));
        HttpProxyUtils.initHttpProxy(wxPayV3HttpClientBuilder, this.wxPayHttpProxy);
        this.customHttpClientBuilder(wxPayV3HttpClientBuilder);
        CloseableHttpClient httpClient = wxPayV3HttpClientBuilder.build();
        HttpGet httpGet = new HttpGet(CERT_DOWNLOAD_PATH);
        httpGet.addHeader("Accept", "application/json");
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        int statusCode = response.getStatusLine().getStatusCode();
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        if (statusCode == 200) {
            List<X509Certificate> newCertList = this.deserializeToCerts(this.apiV3Key, body);
            if (newCertList.isEmpty()) {
                log.warn("Cert list is empty");
                return;
            }
            this.verifier = new CertificatesVerifier(newCertList);
        } else {
            log.warn("Auto update cert failed, statusCode = " + statusCode + ",body = " + body);
        }
    }

    public void customHttpClientBuilder(WxPayV3HttpClientBuilder builder) {
    }

    private List<X509Certificate> deserializeToCerts(byte[] apiV3Key, String body) throws GeneralSecurityException, IOException {
        AesUtils aesUtils = new AesUtils(apiV3Key);
        JsonObject json = GsonParser.parse((String)body);
        JsonArray dataNode = json.getAsJsonArray("data");
        if (dataNode == null) {
            return Collections.emptyList();
        }
        ArrayList<X509Certificate> newCertList = new ArrayList<X509Certificate>();
        int count = dataNode.size();
        for (int i = 0; i < count; ++i) {
            JsonObject encryptCertificateNode = ((JsonObject)dataNode.get(i)).getAsJsonObject("encrypt_certificate");
            String cert = aesUtils.decryptToString(encryptCertificateNode.get("associated_data").toString().replaceAll("\"", "").getBytes(StandardCharsets.UTF_8), encryptCertificateNode.get("nonce").toString().replaceAll("\"", "").getBytes(StandardCharsets.UTF_8), encryptCertificateNode.get("ciphertext").toString().replaceAll("\"", ""));
            X509Certificate x509Cert = PemUtils.loadCertificate(new ByteArrayInputStream(cert.getBytes(StandardCharsets.UTF_8)));
            try {
                x509Cert.checkValidity();
            }
            catch (CertificateExpiredException | CertificateNotYetValidException e) {
                continue;
            }
            newCertList.add(x509Cert);
        }
        return newCertList;
    }

    @Override
    public X509Certificate getValidCertificate() {
        this.checkAndAutoUpdateCert();
        return this.verifier.getValidCertificate();
    }

    public static enum TimeInterval {
        OneHour(60),
        SixHours(360),
        TwelveHours(720);

        private final int minutes;

        public int getMinutes() {
            return this.minutes;
        }

        private TimeInterval(int minutes) {
            this.minutes = minutes;
        }
    }
}

